/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.registry;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.sql.registry.SQLInsertReplaceMethodDescriptor;

public class SQLInsertReplaceMethodRegistry {
    private static final String TAG_METHOD = "method";
    private static SQLInsertReplaceMethodRegistry instance = null;
    private final List<SQLInsertReplaceMethodDescriptor> insertMethods = new ArrayList<SQLInsertReplaceMethodDescriptor>();

    public static synchronized SQLInsertReplaceMethodRegistry getInstance() {
        if (instance == null) {
            instance = new SQLInsertReplaceMethodRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SQLInsertReplaceMethodRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.sqlInsertMethod");
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_METHOD.equals(ext.getName())) {
                this.insertMethods.add(new SQLInsertReplaceMethodDescriptor(ext));
            }
            ++n2;
        }
    }

    public void dispose() {
        this.insertMethods.clear();
    }

    public List<SQLInsertReplaceMethodDescriptor> getInsertMethods() {
        return new ArrayList<SQLInsertReplaceMethodDescriptor>(this.insertMethods);
    }

    public SQLInsertReplaceMethodDescriptor getInsertMethod(String id) {
        for (SQLInsertReplaceMethodDescriptor method : this.insertMethods) {
            if (!method.getId().equalsIgnoreCase(id)) continue;
            return method;
        }
        return null;
    }

    public SQLInsertReplaceMethodDescriptor getInsertMethodOnLabel(String label) {
        for (SQLInsertReplaceMethodDescriptor method : this.insertMethods) {
            if (!method.getLabel().equalsIgnoreCase(label)) continue;
            return method;
        }
        return null;
    }
}

