/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionAnalyzer;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.text.parser.TPRuleBasedScanner;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenAbstract;
import org.jkiss.dbeaver.model.text.parser.TPWordDetector;
import org.jkiss.utils.Pair;

public class SQLIdentifierDetector
extends TPWordDetector {
    protected SQLDialect dialect;
    private final char structSeparator;
    @NotNull
    private final String[][] quoteStrings;
    private final String[][] stringQuoteStrings;

    public SQLIdentifierDetector(SQLDialect dialect) {
        this(dialect, dialect.getStructSeparator(), dialect.getIdentifierQuoteStrings());
    }

    public SQLIdentifierDetector(SQLDialect dialect, char structSeparator, @Nullable String[][] quoteStrings) {
        String[][] stringArray;
        this.dialect = dialect;
        this.structSeparator = structSeparator;
        Object object = this.quoteStrings = quoteStrings != null ? quoteStrings : new String[][]{};
        if (dialect == null) {
            String[][] stringArrayArray = new String[1][];
            stringArray = stringArrayArray;
            stringArrayArray[0] = new String[]{"'", "'"};
        } else {
            stringArray = dialect.getStringQuoteStrings();
        }
        this.stringQuoteStrings = stringArray;
    }

    protected boolean isQuote(char c) {
        String[][] stringArray = this.quoteStrings;
        int n = this.quoteStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String[] quoteString = stringArray[n2];
            if (quoteString[0].indexOf(c) != -1 || quoteString[1].indexOf(c) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isStringQuote(char c) {
        String[][] stringArray = this.stringQuoteStrings;
        int n = this.stringQuoteStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String[] stringQuoteString = stringArray[n2];
            if (stringQuoteString[0].indexOf(c) != -1 || stringQuoteString[1].indexOf(c) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public char getStructSeparator() {
        return this.structSeparator;
    }

    public boolean containsSeparator(String identifier) {
        return identifier.indexOf(this.structSeparator) != -1;
    }

    public String[] splitIdentifier(String identifier) {
        return SQLUtils.splitFullIdentifier((String)identifier, (String)String.valueOf(this.structSeparator), (String[][])this.quoteStrings, (boolean)true);
    }

    @Override
    public boolean isWordStart(char c) {
        return super.isWordStart(c) || this.dialect.validIdentifierStart(c);
    }

    @Override
    public boolean isWordPart(char c) {
        return super.isWordPart(c) || this.isQuote(c) || this.structSeparator == c || this.dialect.validIdentifierPart(c, true);
    }

    public boolean isPlainWordPart(char c) {
        return super.isWordPart(c) || this.dialect.validIdentifierPart(c, false);
    }

    public boolean isQuoted(String token) {
        String[][] stringArray = this.quoteStrings;
        int n = this.quoteStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String[] quoteString = stringArray[n2];
            if (token.startsWith(quoteString[0])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String removeQuotes(String name) {
        String[][] stringArray = this.quoteStrings;
        int n = this.quoteStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String[] quoteString = stringArray[n2];
            if (name.startsWith(quoteString[0])) {
                name = name.substring(quoteString[0].length());
            }
            if (name.endsWith(quoteString[1])) {
                name = name.substring(0, name.length() - quoteString[0].length());
            }
            ++n2;
        }
        return name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private WordRegion detectIdentifier(@NotNull IDocument document, @NotNull IRegion region) {
        WordRegion id = new WordRegion(region.getOffset());
        int docLength = document.getLength();
        try {
            char ch;
            if (!this.isPlainWordPart(document.getChar(region.getOffset()))) {
                return id;
            }
            while (id.identStart >= 0 && this.isWordPart(ch = document.getChar(id.identStart))) {
                if (id.wordStart < 0 && !this.isPlainWordPart(ch)) {
                    id.wordStart = id.identStart + 1;
                }
                --id.identStart;
            }
            ++id.identStart;
            while (id.identEnd < docLength && this.isWordPart(ch = document.getChar(id.identEnd))) {
                if (!this.isPlainWordPart(ch)) {
                    id.wordEnd = id.identEnd;
                }
                ++id.identEnd;
            }
            id.extract(document);
            return id;
        }
        catch (BadLocationException badLocationException) {}
        return id;
    }

    @NotNull
    public WordRegion extractIdentifier(@NotNull IDocument document, @NotNull IRegion region, @Nullable SQLRuleManager ruleManager) {
        if (ruleManager == null) {
            return this.detectIdentifier(document, region);
        }
        WordRegion id = new WordRegion(region.getOffset());
        try {
            Region maybeSepRegion;
            String maybeSepText;
            IRegion line = document.getLineInformationOfOffset(region.getOffset());
            TPRuleBasedScanner scanner = new TPRuleBasedScanner();
            scanner.setRules(ruleManager.getAllRules());
            scanner.setRange(document, line.getOffset(), line.getLength());
            ArrayList<Pair> tokens = new ArrayList<Pair>();
            int tokenIndex = -1;
            TPToken token = scanner.nextToken();
            while (!token.isEOF()) {
                if (token instanceof TPTokenAbstract && !token.isWhitespace()) {
                    if (scanner.getTokenOffset() <= region.getOffset() && scanner.getTokenEndOffset() > region.getOffset()) {
                        if (!SQLCompletionAnalyzer.isNamePartToken(token)) {
                            return id;
                        }
                        tokenIndex = tokens.size();
                    }
                    tokens.add(new Pair((Object)token, (Object)new Region(scanner.getTokenOffset(), scanner.getTokenLength())));
                }
                token = scanner.nextToken();
            }
            if (tokenIndex == -1) {
                return id;
            }
            LinkedList<String> parts = new LinkedList<String>();
            Region r = (Region)((Pair)tokens.get(tokenIndex)).getSecond();
            String word = document.get(r.getOffset(), r.getLength());
            parts.add(word);
            id.word = word;
            id.wordStart = r.getOffset();
            id.wordEnd = r.getOffset() + r.getLength();
            id.identStart = id.wordStart;
            id.identEnd = id.wordEnd;
            int i = tokenIndex;
            while (i - 2 >= 0) {
                if ((maybeSepText = document.get((maybeSepRegion = (Region)((Pair)tokens.get(--i)).getSecond()).getOffset(), maybeSepRegion.getLength())).indexOf(this.structSeparator) < 0 || !SQLCompletionAnalyzer.isNamePartToken((TPToken)((Pair)tokens.get(--i)).getFirst())) break;
                Region prefixWordRegion = (Region)((Pair)tokens.get(i)).getSecond();
                String prefixWord = document.get(prefixWordRegion.getOffset(), prefixWordRegion.getLength());
                parts.addFirst(maybeSepText);
                parts.addFirst(prefixWord);
                id.identStart = prefixWordRegion.getOffset();
            }
            i = tokenIndex;
            while (i + 2 < tokens.size()) {
                if ((maybeSepText = document.get((maybeSepRegion = (Region)((Pair)tokens.get(++i)).getSecond()).getOffset(), maybeSepRegion.getLength())).indexOf(this.structSeparator) < 0 || !SQLCompletionAnalyzer.isNamePartToken((TPToken)((Pair)tokens.get(++i)).getFirst())) break;
                Region suffixWordRegion = (Region)((Pair)tokens.get(i)).getSecond();
                String suffixWord = document.get(suffixWordRegion.getOffset(), suffixWordRegion.getLength());
                parts.addLast(maybeSepText);
                parts.addLast(suffixWord);
                id.identEnd = suffixWordRegion.getOffset() + suffixWordRegion.getLength();
            }
            id.identifier = String.join((CharSequence)"", parts);
            return id;
        }
        catch (BadLocationException badLocationException) {
            return id;
        }
    }

    public static class WordRegion {
        public int identStart;
        public int identEnd;
        public int wordStart = -1;
        public int wordEnd = -1;
        public String identifier = "";
        public String word = "";

        WordRegion(int offset) {
            this.identStart = offset;
            this.identEnd = offset;
        }

        void extract(IDocument document) throws BadLocationException {
            if (this.wordStart < 0) {
                this.wordStart = this.identStart;
            }
            if (this.wordEnd < 0) {
                this.wordEnd = this.identEnd;
            }
            this.identifier = document.get(this.identStart, this.identEnd - this.identStart);
            this.word = document.get(this.wordStart, this.wordEnd - this.wordStart);
        }

        public boolean isEmpty() {
            return this.word.isEmpty();
        }
    }
}

