/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.statistics;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.statistics.PrefPageUsageStatistics;
import org.jkiss.dbeaver.ui.statistics.UIStatisticsActivator;

public class StatisticsCollectionConfirmDialog
extends BaseDialog {
    public StatisticsCollectionConfirmDialog(Shell parentShell) {
        super(parentShell, "Statistics collection", (DBPImage)DBIcon.STATUS_INFO);
    }

    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite dialogArea = super.createDialogArea(parent);
        Composite composite = UIUtils.createComposite((Composite)dialogArea, (int)1);
        Label label = UIUtils.createLabel((Composite)composite, (String)"Data share");
        label.setFont(JFaceResources.getFont((String)"org.eclipse.jface.headerfont"));
        UIUtils.createHorizontalLine((Composite)composite);
        PrefPageUsageStatistics.createDataShareComposite(composite);
        UIUtils.createEmptyLabel((Composite)composite, (int)1, (int)1);
        UIUtils.createLink((Composite)composite, (String)"You can always change this behavior in <a>preferences</a>", (SelectionListener)SelectionListener.widgetSelectedAdapter(selectionEvent -> {
            Shell parentShell = this.getParentShell();
            this.close();
            UIUtils.showPreferencesFor((Shell)parentShell, null, (String[])new String[]{"org.jkiss.dbeaver.preferences.main.usageStatistics"});
        }));
        return composite;
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        this.createButton(parent, 2, "Send anonymous statistics", true);
        this.createButton(parent, 3, "Do not send", false);
    }

    protected void buttonPressed(int buttonId) {
        UIStatisticsActivator.setSkipDataShareConfirmation(true);
        UIStatisticsActivator.setTrackingEnabled(buttonId == 2);
        this.close();
        super.buttonPressed(buttonId);
    }
}

