/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.clickhouse.ClickhouseTypeParser;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseSQLDialect;
import org.jkiss.dbeaver.ext.clickhouse.model.ClickhouseTableEngine;
import org.jkiss.dbeaver.ext.clickhouse.model.jdbc.ClickhouseJdbcFactory;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSourceInfo;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCFactory;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class ClickhouseDataSource
extends GenericDataSource {
    private static final Log log = Log.getLog(ClickhouseDataSource.class);
    private static Map<String, String> dataTypeMap = new HashMap<String, String>();
    private final TableEnginesCache engineCache = new TableEnginesCache();

    static {
        dataTypeMap.put(String.class.getName(), "String");
        dataTypeMap.put(Integer.class.getName(), "Int32");
        dataTypeMap.put(Long.class.getName(), "Int64");
        dataTypeMap.put(Short.class.getName(), "Int16");
        dataTypeMap.put(Byte.class.getName(), "Int8");
        dataTypeMap.put(Float.class.getName(), "Float32");
        dataTypeMap.put(Double.class.getName(), "Float64");
        dataTypeMap.put(Date.class.getName(), "DateTime");
    }

    public ClickhouseDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, GenericMetaModel metaModel) throws DBException {
        super(monitor, container, metaModel, (SQLDialect)new ClickhouseSQLDialect());
        this.engineCache.getAllObjects(monitor, (DBSObject)this);
    }

    List<ClickhouseTableEngine> getTableEngines() {
        return this.engineCache.getCachedObjects();
    }

    ClickhouseTableEngine getEngineByName(@NotNull String engineName) {
        return (ClickhouseTableEngine)this.engineCache.getCachedObject(engineName);
    }

    @Nullable
    protected Properties getAllConnectionProperties(@NotNull DBRProgressMonitor monitor, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        Properties properties = super.getAllConnectionProperties(monitor, context, purpose, connectionInfo);
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getHandler("clickhouse-ssl");
        if (sslConfig != null && sslConfig.isEnabled()) {
            try {
                this.initSSL(monitor, properties, sslConfig);
            }
            catch (Exception e) {
                throw new DBCException("Error configuring SSL certificates", (Throwable)e);
            }
        }
        return properties;
    }

    private void initSSL(DBRProgressMonitor monitor, Properties properties, DBWHandlerConfiguration sslConfig) throws DBException {
        monitor.subTask("Initialising SSL configuration");
        properties.put("ssl", "true");
        try {
            if ("com_clickhouse".equals(this.getContainer().getDriver().getId())) {
                if (DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser()) {
                    String clientKeyProp;
                    String clientCertProp = sslConfig.getSecureProperty("ssl.client.cert.value");
                    if (!CommonUtils.isEmpty((String)clientCertProp)) {
                        properties.put("sslcert", this.saveCertificateToFile(clientCertProp));
                    }
                    if (!CommonUtils.isEmpty((String)(clientKeyProp = sslConfig.getSecureProperty("ssl.client.key.value")))) {
                        properties.put("sslkey", this.saveCertificateToFile(clientKeyProp));
                    }
                } else {
                    properties.put("sslcert", sslConfig.getStringProperty("ssl.client.cert"));
                    properties.put("sslkey", sslConfig.getStringProperty("ssl.client.key"));
                }
                properties.put("sslmode", sslConfig.getStringProperty("ssl.mode"));
            } else {
                String mode = sslConfig.getStringProperty("ssl.mode");
                if (mode != null) {
                    properties.put("sslmode", mode.toLowerCase());
                }
            }
            if (DBWorkbench.isDistributed() || DBWorkbench.getPlatform().getApplication().isMultiuser()) {
                String caCertProp = sslConfig.getSecureProperty("ssl.ca.cert.value");
                if (!CommonUtils.isEmpty((String)caCertProp)) {
                    properties.put("sslrootcert", this.saveCertificateToFile(caCertProp));
                }
            } else {
                properties.put("sslrootcert", sslConfig.getStringProperty("ssl.ca.cert"));
            }
        }
        catch (IOException e) {
            throw new DBException("Can not configure SSL", (Throwable)e);
        }
    }

    @Nullable
    public DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        DBSDataType type;
        String shortName = dataTypeMap.get(typeFullName);
        if (shortName != null) {
            typeFullName = shortName;
        }
        if (ClickhouseTypeParser.isComplexType(typeFullName) && (type = ClickhouseTypeParser.getType(monitor, this, typeFullName)) != null) {
            return type;
        }
        return super.resolveDataType(monitor, typeFullName);
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        GenericDataSourceInfo info = (GenericDataSourceInfo)super.createDataSourceInfo(monitor, metaData);
        info.setSupportsIndexes(false);
        return info;
    }

    @NotNull
    public JDBCFactory getJdbcFactory() {
        return new ClickhouseJdbcFactory();
    }

    boolean isSupportTableComments() {
        return this.isServerVersionAtLeast(21, 6);
    }

    static class TableEnginesCache
    extends JDBCObjectCache<ClickhouseDataSource, ClickhouseTableEngine> {
        TableEnginesCache() {
            this.setListOrderComparator(DBUtils.nameComparator());
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull ClickhouseDataSource clickhouseDataSource) throws SQLException {
            return session.prepareStatement("SELECT name FROM system.table_engines");
        }

        @Nullable
        protected ClickhouseTableEngine fetchObject(@NotNull JDBCSession session, @NotNull ClickhouseDataSource clickhouseDataSource, @NotNull JDBCResultSet dbResult) {
            String engineName = JDBCUtils.safeGetString((ResultSet)dbResult, (int)1);
            if (CommonUtils.isNotEmpty((String)engineName)) {
                return new ClickhouseTableEngine(engineName, clickhouseDataSource);
            }
            return null;
        }
    }
}

