/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources.projects;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizard;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.GlobalPropertyTester;
import org.jkiss.dbeaver.ui.dialogs.MultiPageWizardDialog;
import org.jkiss.dbeaver.ui.project.EditProjectWizard;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;

public class ProjectHandlerImpl
extends AbstractResourceHandler {
    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        return "project";
    }

    public int getFeatures(IResource resource) {
        int features = 4;
        if (GlobalPropertyTester.canManageProjects()) {
            features |= 8;
            DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
            if (activeProject == null || resource != activeProject.getEclipseProject()) {
                boolean isPrivateProject = false;
                if (!DBWorkbench.isDistributed() || !isPrivateProject) {
                    features |= 2;
                }
            }
        }
        return features;
    }

    @NotNull
    public DBNProject makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) {
        return new DBNProject(parentNode, DBPPlatformDesktop.getInstance().getWorkspace().getProject((IProject)resource), (DBPResourceHandler)this);
    }

    public void openResource(@NotNull IResource resource) {
        DBPProject project = DBPPlatformDesktop.getInstance().getWorkspace().getProject((IProject)resource);
        if (project == null) {
            DBWorkbench.getPlatformUI().showError("No project", "Can't get project metadata for resource " + resource.getName());
            return;
        }
        MultiPageWizardDialog dialog = new MultiPageWizardDialog(UIUtils.getActiveWorkbenchWindow(), (IWizard)new EditProjectWizard(project));
        dialog.open();
    }
}

