/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model;

import java.util.Arrays;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.ext.hana.model.HANATableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.data.DBDBinaryFormatter;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.data.formatters.BinaryFormatterHexString;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.parser.rules.SQLVariableRule;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.text.parser.TPRule;
import org.jkiss.dbeaver.model.text.parser.TPRuleProvider;
import org.jkiss.utils.CommonUtils;

public class HANASQLDialect
extends GenericSQLDialect
implements TPRuleProvider {
    private static final Log log = Log.getLog(HANASQLDialect.class);
    private static final String[][] HANA_BEGIN_END_BLOCK = new String[][]{{"BEGIN", "END"}, {"IF", "END IF"}, {"CASE", "END"}, {"FOR", "END FOR"}, {"WHILE", "END WHILE"}};
    private static String[] HANA_FUNCTIONS = new String[]{"ADD_DAYS", "ADD_MONTH", "ADD_MONTHS_LAST", "ADD_SECONDS", "ADD_WORKDAYS", "ADD_YEARS", "CONCAT_NAZ", "CONVERT_CURRENCY", "CONVERT_UNIT", "CURRENT_CONNECTION", "CURRENT_DATE", "CURRENT_OBJECT_SCHEMA", "CURRENT_SCHEMA", "CURRENT_SITE_ID", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_TRANSACTION_ISOLATION_LEVEL", "CURRENT_USER", "CURRENT_USER_ID", "DAYS_BETWEEN", "ESCAPE_DOUBLE_QUOTES", "ESCAPE_SINGLE_QUOTES", "FIRST_VALUE", "GENERATE_PASSWORD", "GREATEST", "INITCAP", "JSON_QUERY", "JSON_TABLE", "JSON_VALUE", "LAST_DAY", "LAST_VALUE", "LEAD", "LEAST", "MONTHS_BETWEEN", "NEXT_DAY", "PLAINTEXT", "REPLACE_REGEXPR", "SECONDS_BETWEEN", "SERIES_GENERATE", "SERIES_ROUND", "SESSION_CONTEXT", "SUBARRAY", "SUBSTR_AFTER", "SUBSTR_BEFORE", "SUBSTRING_REGEXPR", "TO_BIGINT", "TO_BINARY", "TO_BLOB", "TO_BOOLEAN", "TO_CLOB", "TO_DATE", "TO_DECIMAL", "TO_DOUBLE", "TO_INT", "TO_INTEGER", "TO_JSON_BOOLEAN", "TO_NCLOB", "TO_NVARCHAR", "TO_REAL", "TO_SECONDDATE", "TO_SMALLDECIMAL", "TO_SMALLINT", "TO_TIME", "TO_TIMESTAMP", "TO_TINYINT", "TO_VARCHAR", "TRIM", "TRIM_ARRAY", "UNICODE", "WEEKDAY", "WORKDAYS_BETWEEN", "XMLEXTRACT", "XMLEXTRACTVALUE", "XMLTABLE", "YEARS_BETWEEN"};

    @Nullable
    public String[] getBlockHeaderStrings() {
        return new String[]{"DO"};
    }

    public HANASQLDialect() {
        super("HANA", "sap_hana");
    }

    public String[][] getBlockBoundStrings() {
        return HANA_BEGIN_END_BLOCK;
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
        this.addFunctions(Arrays.asList(HANA_FUNCTIONS));
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public boolean validIdentifierStart(char c) {
        return super.validIdentifierStart(c) || c == '_';
    }

    public String getDualTableName() {
        return "DUMMY";
    }

    public String getColumnTypeModifiers(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column, @NotNull String typeName, @NotNull DBPDataKind dataKind) {
        String ucTypeName = CommonUtils.notEmpty((String)typeName).toUpperCase(Locale.ENGLISH);
        if (("ST_POINT".equals(ucTypeName) || "ST_GEOMETRY".equals(ucTypeName)) && column instanceof HANATableColumn) {
            HANATableColumn hanaColumn = (HANATableColumn)column;
            try {
                int srid = hanaColumn.getAttributeGeometrySRID((DBRProgressMonitor)new VoidProgressMonitor());
                return "(" + Integer.toString(srid) + ")";
            }
            catch (DBCException e) {
                log.info((Object)"Could not determine SRID of column", (Throwable)e);
            }
        }
        return super.getColumnTypeModifiers(dataSource, column, ucTypeName, dataKind);
    }

    @NotNull
    public DBDBinaryFormatter getNativeBinaryFormatter() {
        return BinaryFormatterHexString.INSTANCE;
    }

    @NotNull
    public String getSearchStringEscape() {
        return "\\";
    }

    @NotNull
    public TPRule[] extendRules(@Nullable DBPDataSourceContainer dataSource, @NotNull TPRuleProvider.RulePosition position) {
        if (position == TPRuleProvider.RulePosition.FINAL) {
            return new TPRule[]{new SQLVariableRule((SQLDialect)this)};
        }
        return new TPRule[0];
    }

    public boolean isStripCommentsBeforeBlocks() {
        return true;
    }
}

