/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.mapping.internal;

import java.util.Stack;
import java.util.function.Predicate;
import org.jkiss.dbeaver.model.lsm.mapping.internal.EmptyNodesList;
import org.jkiss.dbeaver.model.lsm.mapping.internal.NodesList;
import org.jkiss.dbeaver.model.lsm.mapping.internal.TreeRuleNode;
import org.jkiss.dbeaver.model.lsm.mapping.internal.XTreeNodeBase;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public interface XTreeElementBase
extends XTreeNodeBase,
Element {
    @Override
    default public String getTagName() {
        return this.getLocalName();
    }

    @Override
    default public String getAttribute(String name) {
        return "";
    }

    @Override
    default public void setAttribute(String name, String value) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void removeAttribute(String name) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public Attr getAttributeNode(String name) {
        return null;
    }

    @Override
    default public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public NodeList getElementsByTagName(String name) {
        Predicate<Node> condition = "*".equals(name) ? n -> true : n -> n.getLocalName().equals(name);
        NodesList result = new NodesList(5);
        Stack<XTreeNodeBase> stack = new Stack<XTreeNodeBase>();
        stack.addAll(this.getSubnodes().getCollection());
        while (!stack.isEmpty()) {
            XTreeNodeBase nodeInfo = (XTreeNodeBase)stack.pop();
            if (nodeInfo != null) {
                stack.push(nodeInfo);
                stack.push(null);
                TreeRuleNode.SubnodesList subnodes = nodeInfo.getSubnodes();
                int i = subnodes.getLength() - 1;
                while (i >= 0) {
                    stack.push(subnodes.item(i));
                    --i;
                }
                continue;
            }
            nodeInfo = (XTreeNodeBase)stack.pop();
            if (!condition.test(nodeInfo)) continue;
            result.add(nodeInfo);
        }
        return result;
    }

    @Override
    default public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        return "";
    }

    @Override
    default public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return null;
    }

    @Override
    default public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public NodeList getElementsByTagNameNS(String namespaceURI, String localName) throws DOMException {
        if (namespaceURI == null || namespaceURI.length() == 0) {
            return this.getElementsByTagName(localName);
        }
        return EmptyNodesList.INSTANCE;
    }

    @Override
    default public boolean hasAttribute(String name) {
        return false;
    }

    @Override
    default public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        return false;
    }

    @Override
    default public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    default public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new UnsupportedOperationException();
    }
}

