/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.lsm.mapping.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.runtime.tree.Trees;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.lsm.mapping.AbstractSyntaxNode;
import org.jkiss.dbeaver.model.lsm.mapping.internal.TreeTermErrorNode;
import org.jkiss.dbeaver.model.lsm.mapping.internal.TreeTermNode;
import org.jkiss.dbeaver.model.lsm.mapping.internal.XTreeElementBase;
import org.jkiss.dbeaver.model.lsm.mapping.internal.XTreeNodeBase;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TreeRuleNode
extends ParserRuleContext
implements Element,
XTreeElementBase {
    private final SubnodesList subnodes = new SubnodesListImpl();
    private String nodeName = null;
    private int index = -1;
    private AbstractSyntaxNode model;
    private Map<String, Object> userData;

    public TreeRuleNode() {
    }

    public TreeRuleNode(@NotNull ParserRuleContext parent, int invokingStateNumber) {
        super(parent, invokingStateNumber);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setModel(@Nullable AbstractSyntaxNode model) {
        if (this.model != null) {
            throw new IllegalStateException();
        }
        this.model = model;
    }

    @Override
    @Nullable
    public AbstractSyntaxNode getModel() {
        return this.model;
    }

    @Override
    @NotNull
    public Interval getRealInterval() {
        return new Interval(this.getStart().getStartIndex(), this.getStop().getStopIndex());
    }

    @Override
    public void fixup(@NotNull Parser parserCtx, int index) {
        this.index = index;
        if (this.getChildCount() > 0) {
            this.nodeName = Trees.getNodeText((Tree)this, (Parser)parserCtx);
            List<XTreeNodeBase> subnodes = this.getSubnodes().getCollection();
            int i = 0;
            while (i < subnodes.size()) {
                subnodes.get(i).fixup(parserCtx, i);
                ++i;
            }
        } else {
            throw new IllegalStateException();
        }
    }

    @NotNull
    public RuleContext addChild(@NotNull RuleContext ruleInvocation) {
        if (!(ruleInvocation instanceof XTreeNodeBase)) {
            throw new IllegalStateException();
        }
        return super.addChild(ruleInvocation);
    }

    @NotNull
    public TerminalNode addChild(@NotNull Token matchedToken) {
        return super.addChild((TerminalNode)new TreeTermNode(matchedToken));
    }

    @NotNull
    public TerminalNode addChild(@NotNull TerminalNode t) {
        if (!(t instanceof XTreeNodeBase)) {
            throw new IllegalStateException();
        }
        return super.addChild(t);
    }

    @NotNull
    public <T extends ParseTree> T addAnyChild(@NotNull T t) {
        if (!(t instanceof XTreeNodeBase)) {
            throw new IllegalStateException();
        }
        return (T)super.addAnyChild(t);
    }

    @NotNull
    public ErrorNode addErrorNode(@NotNull Token badToken) {
        return (ErrorNode)super.addAnyChild((ParseTree)new TreeTermErrorNode(badToken));
    }

    @NotNull
    public ErrorNode addErrorNode(@NotNull ErrorNode errorNode) {
        if (!(errorNode instanceof XTreeNodeBase)) {
            throw new IllegalStateException();
        }
        return super.addErrorNode(errorNode);
    }

    @Override
    public SubnodesList getSubnodes() {
        return this.subnodes;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public short getNodeType() {
        return 1;
    }

    @Override
    public Map<String, Object> getUserDataMap(boolean createIfMissing) {
        return this.userData != null ? this.userData : (this.userData = new HashMap<String, Object>());
    }

    public static interface SubnodesList
    extends NodeList {
        @NotNull
        public List<XTreeNodeBase> getCollection();

        @Override
        @Nullable
        public XTreeNodeBase item(int var1);

        @Nullable
        public XTreeNodeBase getFirst();

        @Nullable
        public XTreeNodeBase getLast();
    }

    private class SubnodesListImpl
    implements SubnodesList {
        private SubnodesListImpl() {
        }

        @Override
        @NotNull
        public List<XTreeNodeBase> getCollection() {
            return TreeRuleNode.this.children;
        }

        @Override
        @Nullable
        public XTreeNodeBase item(int index) {
            List<XTreeNodeBase> items = this.getCollection();
            return index < 0 || index >= items.size() ? null : items.get(index);
        }

        @Override
        public int getLength() {
            return this.getCollection().size();
        }

        @Override
        @Nullable
        public XTreeNodeBase getFirst() {
            List<XTreeNodeBase> items = this.getCollection();
            return items.size() > 0 ? items.get(0) : null;
        }

        @Override
        @Nullable
        public XTreeNodeBase getLast() {
            List<XTreeNodeBase> items = this.getCollection();
            return items.size() > 0 ? items.get(items.size() - 1) : null;
        }
    }
}

