/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.model;

import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericSQLDialect;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class SQLiteSQLDialect
extends GenericSQLDialect {
    public SQLiteSQLDialect() {
        super("SQLite", "sqlite");
        this.addKeywords(Set.of("STRICT"), DBPKeywordType.OTHER);
    }

    @NotNull
    public String escapeScriptValue(DBSTypedObject attribute, @NotNull Object value, @NotNull String strValue) {
        if (CommonUtils.isNaN((Object)value) || CommonUtils.isInfinite((Object)value)) {
            return "'" + value + "'";
        }
        return super.escapeScriptValue(attribute, value, strValue);
    }

    public void initDriverSettings(JDBCSession session, JDBCDataSource dataSource, JDBCDatabaseMetaData metaData) {
        super.initDriverSettings(session, dataSource, metaData);
    }

    protected void loadFunctions(JDBCSession session, JDBCDatabaseMetaData metaData, Set<String> allFunctions) throws DBException, SQLException {
        allFunctions.addAll(List.of("AVG", "COUNT", "MAX", "MIN", "SUM", "GROUP", "SUBSTR", "TRIM", "LTRIM", "RTRIM", "LENGTH", "REPLACE", "UPPER", "LOWER", "INSTR", "COALESCE", "IFNULL", "IIF", "NULLIF", "SQlite", "DATE", "TIME", "DATETIME", "JULIANDAY", "STRFTIME", "ABS", "RANDOM", "ROUND"));
        super.loadFunctions(session, metaData, allFunctions);
    }

    public boolean supportsAliasInSelect() {
        return true;
    }

    public String[][] getIdentifierQuoteStrings() {
        return BasicSQLDialect.DEFAULT_IDENTIFIER_QUOTES;
    }

    public boolean supportsAlterTableStatement() {
        return false;
    }

    @NotNull
    public SQLDialect.MultiValueInsertMode getDefaultMultiValueInsertMode() {
        return SQLDialect.MultiValueInsertMode.GROUP_ROWS;
    }

    public boolean supportsInsertAllDefaultValuesStatement() {
        return true;
    }

    public boolean supportsIndexCreateAndDrop() {
        return true;
    }
}

