/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.processor;

import java.io.File;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.tools.transfer.IDataTransferEventProcessor;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;
import org.jkiss.utils.CommonUtils;

public class ExecuteCommandEventProcessor
implements IDataTransferEventProcessor<StreamTransferConsumer> {
    public static final String ID = "executeCommand";
    public static final String PROP_COMMAND = "command";
    public static final String PROP_WORKING_DIRECTORY = "workingDirectory";

    @Override
    public void processEvent(@NotNull DBRProgressMonitor monitor, @NotNull IDataTransferEventProcessor.Event event, @NotNull StreamTransferConsumer consumer, @Nullable DBTTask task, @NotNull Map<String, Object> processorSettings) throws DBException {
        String commandLine = consumer.translatePattern(CommonUtils.toString((Object)processorSettings.get(PROP_COMMAND)), new File(consumer.getOutputFolder(), consumer.getOutputFileName()));
        String workingDirectory = CommonUtils.toString((Object)processorSettings.get(PROP_WORKING_DIRECTORY));
        DBRShellCommand command = new DBRShellCommand(commandLine);
        command.setWorkingDirectory(workingDirectory);
        DBRProcessDescriptor processDescriptor = new DBRProcessDescriptor(command);
        processDescriptor.execute();
    }
}

