/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DataSourceVariableResolver;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;

public class SQLEditorVariablesResolver
extends DataSourceVariableResolver {
    private final DBPDataSourceContainer dataSourceContainer;
    private final DBCExecutionContext context;
    private final String scriptName;
    private final IFile file;
    private final DBPProject project;

    public SQLEditorVariablesResolver(@Nullable DBPDataSourceContainer dataSourceContainer, @Nullable DBPConnectionConfiguration configuration, @Nullable DBCExecutionContext context, @Nullable String scriptName, @Nullable IFile file, DBPProject project) {
        super(dataSourceContainer, configuration);
        this.dataSourceContainer = dataSourceContainer;
        this.context = context;
        this.scriptName = scriptName;
        this.file = file;
        this.project = project;
    }

    @Nullable
    public String get(String name) {
        switch (name) {
            case "projectName": {
                if (this.project != null) {
                    return this.project.getName();
                }
                return this.dataSourceContainer == null ? null : this.dataSourceContainer.getProject().getName();
            }
            case "connectionName": {
                return this.dataSourceContainer == null ? "none" : this.dataSourceContainer.getName();
            }
            case "driverName": {
                return this.dataSourceContainer == null ? "?" : this.dataSourceContainer.getDriver().getFullName();
            }
            case "database": {
                return this.getContextInfo("database");
            }
            case "schema": {
                return this.getContextInfo("schema");
            }
            case "fileName": {
                return Objects.requireNonNullElse(this.scriptName, "");
            }
            case "fileExt": {
                if (this.file != null) {
                    return this.file.getFullPath().getFileExtension();
                }
                return "";
            }
        }
        return super.get(name);
    }

    private String getContextInfo(String type) {
        DBCExecutionContextDefaults contextDefaults;
        if (this.context != null && (contextDefaults = this.context.getContextDefaults()) != null) {
            if (type.equals("database")) {
                return contextDefaults.getDefaultCatalog() == null ? null : contextDefaults.getDefaultCatalog().getName();
            }
            if (type.equals("schema")) {
                return contextDefaults.getDefaultSchema() == null ? null : contextDefaults.getDefaultSchema().getName();
            }
        }
        return null;
    }
}

