/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hive.model.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.ext.generic.edit.GenericIndexManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableIndex;
import org.jkiss.dbeaver.ext.hive.model.HiveIndex;
import org.jkiss.dbeaver.ext.hive.model.HiveTable;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;

public class HiveIndexManager
extends GenericIndexManager {
    public boolean canCreateObject(Object container) {
        return true;
    }

    public boolean canDeleteObject(GenericTableIndex object) {
        return true;
    }

    protected GenericTableIndex createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object from, Map<String, Object> options) {
        return new HiveIndex((HiveTable)((Object)container), "NewIndex", false, "", "Compact", null);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        HiveIndex tableIndex = (HiveIndex)command.getObject();
        DBSIndexType indexType = tableIndex.getIndexType();
        String indexName = tableIndex.getName();
        String tableName = ((GenericTableBase)tableIndex.getTable()).getName();
        List indexColumns = tableIndex.getAttributeReferences(monitor);
        String hiveIndexType = indexType.getId().equals("COMPACT") ? "'COMPACT'" : "'BITMAP'";
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE INDEX ").append(indexName).append(" ON TABLE ").append(tableName).append(" (");
        if (indexColumns != null) {
            int i = 0;
            while (i < indexColumns.size()) {
                if (i == 0) {
                    ddl.append(DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)indexColumns.get(i))));
                } else {
                    ddl.append(", ").append(DBUtils.getQuotedIdentifier((DBSObject)((DBSObject)indexColumns.get(i))));
                }
                ++i;
            }
        }
        ddl.append(") AS ").append(hiveIndexType).append(" WITH DEFERRED REBUILD");
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create table index", ddl.toString()));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("ALTER INDEX " + indexName + " ON " + tableName + " REBUILD"));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        GenericTableIndex tableIndex = (GenericTableIndex)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop index table", "DROP INDEX " + tableIndex.getName() + " ON " + ((GenericTableBase)tableIndex.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }
}

