/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLGroupingQueryGenerator;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.ui.DataEditorFeatures;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.view.EmptyPresentation;
import org.jkiss.utils.CommonUtils;

public class GroupingResultsContainer
implements IResultSetContainer {
    private static final Log log = Log.getLog(GroupingResultsContainer.class);
    public static final String FUNCTION_COUNT = "COUNT";
    private final IResultSetPresentation presentation;
    private final GroupingDataContainer dataContainer;
    private final ResultSetViewer groupingViewer;
    private final List<String> groupAttributes = new ArrayList<String>();
    private final List<String> groupFunctions = new ArrayList<String>();

    public GroupingResultsContainer(Composite parent, IResultSetPresentation presentation) {
        this.presentation = presentation;
        this.dataContainer = new GroupingDataContainer(presentation.getController());
        this.groupingViewer = new ResultSetViewer(parent, presentation.getController().getSite(), this);
        this.initDefaultSettings();
    }

    private String getDefaultFunction() {
        DBPDataSource dataSource = this.dataContainer.getDataSource();
        return "COUNT(" + (dataSource == null ? "*" : dataSource.getSQLDialect().getDefaultGroupAttribute()) + ")";
    }

    private void initDefaultSettings() {
        this.groupAttributes.clear();
        this.groupFunctions.clear();
        this.addGroupingFunctions(Collections.singletonList(this.getDefaultFunction()));
    }

    public IResultSetPresentation getOwnerPresentation() {
        return this.presentation;
    }

    public List<String> getGroupAttributes() {
        return this.groupAttributes;
    }

    public List<String> getGroupFunctions() {
        return this.groupFunctions;
    }

    @Override
    @Nullable
    public DBPProject getProject() {
        DBSDataContainer dataContainer = this.getDataContainer();
        return dataContainer == null || dataContainer.getDataSource() == null ? null : dataContainer.getDataSource().getContainer().getProject();
    }

    public DBCExecutionContext getExecutionContext() {
        return this.presentation.getController().getExecutionContext();
    }

    @Override
    @NotNull
    public IResultSetController getResultSetController() {
        return this.groupingViewer;
    }

    @Override
    public DBSDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public boolean isReadyToRun() {
        return true;
    }

    @Override
    public void openNewContainer(DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter newFilter) {
    }

    @Override
    public IResultSetDecorator createResultSetDecorator() {
        return new GroupingResultsDecorator(this);
    }

    void clearGroupingAttributes() {
        this.groupAttributes.clear();
    }

    void addGroupingAttributes(List<String> attributes) {
        for (String attrName : attributes) {
            if (this.groupAttributes.contains(attrName = this.cleanupObjectName(attrName))) continue;
            this.groupAttributes.add(attrName);
        }
    }

    boolean removeGroupingAttribute(List<String> attributes) {
        boolean changed = false;
        for (String attrName : attributes) {
            if (!this.groupAttributes.contains(attrName = this.cleanupObjectName(attrName))) continue;
            this.groupAttributes.remove(attrName);
            changed = true;
        }
        if (changed) {
            this.resetDataFilters();
        }
        return changed;
    }

    private String cleanupObjectName(String attrName) {
        DBPDataSource dataSource = this.getDataContainer().getDataSource();
        attrName = DBUtils.isQuotedIdentifier((DBPDataSource)dataSource, (String)attrName) ? DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)attrName) : DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)attrName);
        return attrName;
    }

    public void addGroupingFunctions(List<String> functions) {
        for (String func : functions) {
            func = DBUtils.getUnQuotedIdentifier((DBPDataSource)this.getDataContainer().getDataSource(), (String)func);
            if (this.groupFunctions.contains(func)) continue;
            this.groupFunctions.add(func);
        }
    }

    public boolean removeGroupingFunction(List<String> attributes) {
        boolean changed = false;
        for (String func : attributes) {
            func = DBUtils.getUnQuotedIdentifier((DBPDataSource)this.getDataContainer().getDataSource(), (String)func);
            if (!this.groupFunctions.contains(func)) continue;
            this.groupFunctions.remove(func);
            changed = true;
        }
        return changed;
    }

    public void clearGrouping() {
        this.initDefaultSettings();
        this.groupingViewer.clearData(true);
        this.groupingViewer.clearDataFilter(false);
        this.groupingViewer.resetHistory();
        this.dataContainer.setGroupingQuery(null);
        this.dataContainer.setGroupingAttributes(null);
        if (!(this.groupingViewer.getActivePresentation() instanceof EmptyPresentation)) {
            this.groupingViewer.showEmptyPresentation();
        }
    }

    public void rebuildGrouping() throws DBException {
        if (this.groupAttributes.isEmpty() || this.groupFunctions.isEmpty()) {
            this.groupingViewer.showEmptyPresentation();
            return;
        }
        DBCStatistics statistics = this.presentation.getController().getModel().getStatistics();
        if (statistics == null) {
            throw new DBException("No main query - can't perform grouping");
        }
        DBSDataContainer dbsDataContainer = this.presentation.getController().getDataContainer();
        boolean isCustomQuery = !(dbsDataContainer instanceof DBSEntity);
        DBPDataSource dataSource = this.dataContainer.getDataSource();
        if (dataSource == null) {
            throw new DBException("No active datasource");
        }
        SQLDialect dialect = SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        syntaxManager.init(dialect, this.presentation.getController().getPreferenceStore());
        String queryText = statistics.getQueryText();
        boolean isShowDuplicatesOnly = dataSource.getContainer().getPreferenceStore().getBoolean("resultset.grouping.showDuplicatesOnly");
        SQLGroupingQueryGenerator groupingQueryGenerator = new SQLGroupingQueryGenerator(dataSource, dbsDataContainer, dialect, syntaxManager, this.groupAttributes, this.groupFunctions, isShowDuplicatesOnly);
        this.dataContainer.setGroupingQuery(groupingQueryGenerator.generateGroupingQuery(queryText));
        this.dataContainer.setGroupingAttributes((String[])this.groupAttributes.toArray(String[]::new));
        DBDDataFilter dataFilter = this.presentation.getController().getModel().isMetadataChanged() ? new DBDDataFilter() : new DBDDataFilter(this.groupingViewer.getModel().getDataFilter());
        boolean isDefaultGrouping = this.groupFunctions.size() == 1 && this.groupFunctions.get(0).equalsIgnoreCase(this.getDefaultFunction());
        String defaultSorting = dataSource.getContainer().getPreferenceStore().getString("resultset.grouping.defaultSorting");
        if (!CommonUtils.isEmpty((String)defaultSorting) && isDefaultGrouping) {
            String[] funcAliases = groupingQueryGenerator.getFuncAliases();
            dataFilter.setOrder(String.valueOf(funcAliases[funcAliases.length - 1]) + " " + defaultSorting);
        }
        DataEditorFeatures.RESULT_SET_PANEL_GROUPING.use(Map.of("custom", isCustomQuery, "default", isDefaultGrouping, "dups", isShowDuplicatesOnly));
        this.groupingViewer.setDataFilter(dataFilter, true);
    }

    void setGrouping(List<String> attributes, List<String> functions) {
        this.groupAttributes.clear();
        this.addGroupingAttributes(attributes);
        this.groupFunctions.clear();
        this.addGroupingFunctions(functions);
        this.resetDataFilters();
    }

    private void resetDataFilters() {
        this.groupingViewer.getModel().createDataFilter();
    }
}

