/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.generator;

import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.impl.sql.ChangeTableDataStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.generator.SQLGeneratorResultSet;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorUpdateFromData
extends SQLGeneratorResultSet {
    public boolean isDMLOption() {
        return true;
    }

    @Override
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, IResultSetController object) throws DBException {
        DBSEntity dbsEntity = this.getSingleEntity();
        String entityName = this.getEntityName(dbsEntity);
        String separator = this.getLineSeparator();
        for (ResultSetRow firstRow : this.getSelectedRows()) {
            List<DBDAttributeBinding> keyAttributes = this.getKeyAttributes(monitor, object);
            List<DBDAttributeBinding> valueAttributes = this.getValueAttributes(monitor, object, keyAttributes);
            if (dbsEntity instanceof ChangeTableDataStatement) {
                ChangeTableDataStatement dataStatement = (ChangeTableDataStatement)dbsEntity;
                sql.append(dataStatement.generateTableUpdateBegin(entityName));
                String string = dataStatement.generateTableUpdateSet();
                if (CommonUtils.isNotEmpty((String)string)) {
                    sql.append(separator).append(string);
                }
            } else {
                sql.append("UPDATE ").append(entityName);
                sql.append(separator).append("SET ");
            }
            boolean hasAttr = false;
            if (CommonUtils.isEmpty((Collection)valueAttributes)) {
                valueAttributes = keyAttributes;
            }
            for (DBSAttributeBase dBSAttributeBase : valueAttributes) {
                if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase)) continue;
                if (hasAttr) {
                    sql.append(", ");
                }
                sql.append(DBUtils.getObjectFullName((DBPNamedObject)dBSAttributeBase, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
                DBDAttributeBinding binding = this.getController().getModel().getAttributeBinding(dBSAttributeBase);
                if (binding == null) {
                    this.appendDefaultValue(sql, dBSAttributeBase);
                } else {
                    this.appendAttributeValue(this.getController(), sql, binding, firstRow);
                }
                hasAttr = true;
            }
            if (!CommonUtils.isEmpty(keyAttributes)) {
                sql.append(separator).append("WHERE ");
                this.appendKeyConditions(sql, keyAttributes, firstRow);
            }
            sql.append(";\n");
        }
    }
}

