/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import java.io.File;
import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.PropertyPermission;
import java.util.concurrent.Callable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.osgi.framework.AdminPermission;

public class SecurityManagerUtils {
    private static final List<Permission> DEFAULT_PERMISSIONS = List.of(new SocketPermission("*", "connect"), new NetPermission("*"), new ReflectPermission("*"), new AdminPermission(), new RuntimePermission("accessDeclaredMembers"), new PropertyPermission("*", "read"), new RuntimePermission("getClassLoader"), new RuntimePermission("createClassLoader"), new RuntimePermission("getenv.*"));

    public static List<Permission> getDefaultPermissions() {
        return new ArrayList<Permission>(DEFAULT_PERMISSIONS);
    }

    public static <T> T executeWithAccessControlContext(AccessControlContext controlContext, Callable<T> callable) throws Throwable {
        try {
            return (T)AccessController.doPrivileged(() -> {
                try {
                    return callable.call();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }, controlContext);
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof RuntimeException && throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            throw throwable;
        }
    }

    public static AccessControlContext controlContextOf(List<Permission> permissions) {
        Permissions noPermissions = new Permissions();
        for (Permission permission : permissions) {
            noPermissions.add(permission);
        }
        noPermissions.setReadOnly();
        return new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, noPermissions)});
    }

    public static <T> T wrapDriverActions(DBPDataSourceContainer container, Callable<T> callable) throws Throwable {
        DBPDriver driver = container.getDriver();
        if (System.getSecurityManager() != null && DBWorkbench.getPlatform().getApplication().isMultiuser() && container.isAccessCheckRequired()) {
            List<Permission> permissions = SecurityManagerUtils.getDefaultPermissions();
            permissions.addAll(SecurityManagerUtils.getDriverFilesPermissions(driver));
            return SecurityManagerUtils.executeWithAccessControlContext(SecurityManagerUtils.controlContextOf(permissions), callable);
        }
        return callable.call();
    }

    private static List<Permission> getDriverFilesPermissions(DBPDriver driver) {
        ArrayList<Permission> driverFilesPermissions = new ArrayList<Permission>();
        List<? extends DBPDriverLibrary> driverLibraries = driver.getDriverLibraries();
        for (DBPDriverLibrary dBPDriverLibrary : driverLibraries) {
            Path libraryFile = dBPDriverLibrary.getLocalFile();
            if (libraryFile == null) continue;
            String relativeFilePath = libraryFile.toString();
            String absoluteFilePath = libraryFile.toAbsolutePath().toString();
            if (Files.isDirectory(libraryFile, new LinkOption[0])) {
                driverFilesPermissions.add(new FilePermission(relativeFilePath, "read"));
                driverFilesPermissions.add(new FilePermission(absoluteFilePath, "read"));
                absoluteFilePath = String.valueOf(absoluteFilePath) + File.separator + "*";
                relativeFilePath = String.valueOf(relativeFilePath) + File.separator + "*";
            }
            driverFilesPermissions.add(new FilePermission(relativeFilePath, "read"));
            driverFilesPermissions.add(new FilePermission(absoluteFilePath, "read"));
        }
        return driverFilesPermissions;
    }
}

