import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { memo, useState, useEffect, Children, isValidElement, cloneElement } from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/TreeView/tree-view.mjs';
import AngleRightIcon from '@patternfly/react-icons/dist/esm/icons/angle-right-icon';
import { Badge } from '../Badge';
import { GenerateId } from '../../helpers/GenerateId/GenerateId';
import { useHasAnimations } from '../../helpers';
const TreeViewListItemBase = ({ name, title, id, isExpanded, defaultExpanded = false, children = null, onSelect, onExpand, onCollapse, onCheck, hasCheckbox = false, checkProps = {
    checked: false
}, hasBadge = false, customBadgeContent, badgeProps = { isRead: true }, isSelectable = false, isCompact, activeItems = [], itemData, parentItem, icon, expandedIcon, action, compareItems, hasAnimations: hasAnimationsProp, 
// eslint-disable-next-line @typescript-eslint/no-unused-vars
useMemo }) => {
    const hasAnimations = useHasAnimations(hasAnimationsProp);
    const [internalIsExpanded, setIsExpanded] = useState(defaultExpanded);
    useEffect(() => {
        if (isExpanded !== undefined && isExpanded !== null) {
            setIsExpanded(isExpanded);
        }
        else if (defaultExpanded !== undefined && defaultExpanded !== null) {
            setIsExpanded(internalIsExpanded || defaultExpanded);
        }
    }, [isExpanded, defaultExpanded]);
    let Component = 'button';
    if (hasCheckbox) {
        Component = 'label';
    }
    else if (isSelectable) {
        Component = 'div';
    }
    const ToggleComponent = hasCheckbox || isSelectable ? 'button' : 'span';
    const renderToggle = (randomId) => (_jsx(ToggleComponent, Object.assign({ className: css(styles.treeViewNodeToggle), onClick: (evt) => {
            if (isSelectable || hasCheckbox) {
                if (internalIsExpanded) {
                    onCollapse && onCollapse(evt, itemData, parentItem);
                }
                else {
                    onExpand && onExpand(evt, itemData, parentItem);
                }
                setIsExpanded(!internalIsExpanded);
            }
            if (isSelectable) {
                evt.stopPropagation();
            }
        } }, ((hasCheckbox || isSelectable) && { 'aria-labelledby': `label-${randomId}` }), (ToggleComponent === 'button' && { type: 'button' }), { tabIndex: -1, children: _jsx("span", { className: css(styles.treeViewNodeToggleIcon), children: _jsx(AngleRightIcon, {}) }) })));
    const isCheckboxChecked = checkProps.checked === null ? false : checkProps.checked;
    const renderCheck = (randomId) => (_jsx("span", { className: css(styles.treeViewNodeCheck), children: _jsx("input", Object.assign({ type: "checkbox", onChange: (evt) => onCheck && onCheck(evt, itemData, parentItem), onClick: (evt) => evt.stopPropagation(), ref: (elem) => {
                elem && (elem.indeterminate = checkProps.checked === null);
            } }, checkProps, { checked: isCheckboxChecked, id: randomId, tabIndex: -1 })) }));
    const iconRendered = (_jsxs("span", { className: css(styles.treeViewNodeIcon), children: [!internalIsExpanded && icon, internalIsExpanded && (expandedIcon || icon)] }));
    const renderNodeContent = () => {
        const content = (_jsxs(_Fragment, { children: [isCompact && title && _jsx("span", { className: css(styles.treeViewNodeTitle), children: title }), isSelectable ? (_jsx("button", { tabIndex: -1, className: css(styles.treeViewNodeText), type: "button", children: name })) : (_jsx("span", { className: css(styles.treeViewNodeText), children: name }))] }));
        return isCompact ? _jsx("span", { className: css(styles.treeViewNodeContent), children: content }) : content;
    };
    const badgeRendered = (_jsxs(_Fragment, { children: [hasBadge && children && (_jsx("span", { className: css(styles.treeViewNodeCount), children: _jsx(Badge, Object.assign({}, badgeProps, { children: customBadgeContent !== null && customBadgeContent !== void 0 ? customBadgeContent : children.props.data.length })) })), hasBadge && !children && customBadgeContent !== undefined && (_jsx("span", { className: css(styles.treeViewNodeCount), children: _jsx(Badge, Object.assign({}, badgeProps, { children: customBadgeContent })) }))] }));
    const isSelected = (!children || isSelectable) &&
        activeItems &&
        activeItems.length > 0 &&
        activeItems.some((item) => compareItems && item && compareItems(item, itemData));
    const clonedChildren = Children.map(children, (child) => isValidElement(child) &&
        cloneElement(child, {
            inert: internalIsExpanded ? undefined : ''
        }));
    return (_jsxs("li", Object.assign({ id: id, className: css(styles.treeViewListItem, internalIsExpanded && styles.modifiers.expanded), "aria-expanded": internalIsExpanded, role: "treeitem", tabIndex: -1 }, (hasCheckbox && { 'aria-checked': isCheckboxChecked }), (!hasCheckbox && { 'aria-selected': isSelected }), { children: [_jsxs("div", { className: css(styles.treeViewContent), children: [_jsx(GenerateId, { prefix: isSelectable ? 'selectable-id' : 'checkbox-id', children: (randomId) => (_jsx(Component, Object.assign({ className: css(styles.treeViewNode, isSelected && styles.modifiers.current), onClick: (evt) => {
                                if (!hasCheckbox) {
                                    onSelect && onSelect(evt, itemData, parentItem);
                                    if (!isSelectable && children && evt.isDefaultPrevented() !== true) {
                                        if (internalIsExpanded) {
                                            onCollapse && onCollapse(evt, itemData, parentItem);
                                        }
                                        else {
                                            onExpand && onExpand(evt, itemData, parentItem);
                                        }
                                        setIsExpanded(!internalIsExpanded);
                                    }
                                }
                            } }, (hasCheckbox && { htmlFor: randomId }), ((hasCheckbox || (isSelectable && children)) && { id: `label-${randomId}` }), (Component === 'button' && { type: 'button' }), { children: _jsxs("span", { className: css(styles.treeViewNodeContainer), children: [children && renderToggle(randomId), hasCheckbox && renderCheck(randomId), icon && iconRendered, renderNodeContent(), badgeRendered] }) }))) }), action && _jsx("div", { className: css(styles.treeViewAction), children: action })] }), (internalIsExpanded || hasAnimations) && clonedChildren] })));
};
export const TreeViewListItem = memo(TreeViewListItemBase, (prevProps, nextProps) => {
    if (!nextProps.useMemo) {
        return false;
    }
    const prevIncludes = prevProps.activeItems &&
        prevProps.activeItems.length > 0 &&
        prevProps.activeItems.some((item) => prevProps.compareItems && item && prevProps.compareItems(item, prevProps.itemData));
    const nextIncludes = nextProps.activeItems &&
        nextProps.activeItems.length > 0 &&
        nextProps.activeItems.some((item) => nextProps.compareItems && item && nextProps.compareItems(item, nextProps.itemData));
    if (prevIncludes || nextIncludes) {
        return false;
    }
    if (prevProps.name !== nextProps.name ||
        prevProps.title !== nextProps.title ||
        prevProps.id !== nextProps.id ||
        prevProps.isExpanded !== nextProps.isExpanded ||
        prevProps.defaultExpanded !== nextProps.defaultExpanded ||
        prevProps.onSelect !== nextProps.onSelect ||
        prevProps.onCheck !== nextProps.onCheck ||
        prevProps.onExpand !== nextProps.onExpand ||
        prevProps.onCollapse !== nextProps.onCollapse ||
        prevProps.hasCheckbox !== nextProps.hasCheckbox ||
        prevProps.checkProps !== nextProps.checkProps ||
        prevProps.hasBadge !== nextProps.hasBadge ||
        prevProps.customBadgeContent !== nextProps.customBadgeContent ||
        prevProps.badgeProps !== nextProps.badgeProps ||
        prevProps.isCompact !== nextProps.isCompact ||
        prevProps.icon !== nextProps.icon ||
        prevProps.expandedIcon !== nextProps.expandedIcon ||
        prevProps.action !== nextProps.action ||
        prevProps.parentItem !== nextProps.parentItem ||
        prevProps.itemData !== nextProps.itemData) {
        return false;
    }
    return true;
});
TreeViewListItem.displayName = 'TreeViewListItem';
//# sourceMappingURL=TreeViewListItem.js.map