// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package ipam

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/cilium/cilium/api/v1/models"
)

// DeleteIpamIPReader is a Reader for the DeleteIpamIP structure.
type DeleteIpamIPReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteIpamIPReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteIpamIPOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteIpamIPInvalid()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteIpamIPForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteIpamIPNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteIpamIPFailure()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 501:
		result := NewDeleteIpamIPDisabled()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewDeleteIpamIPOK creates a DeleteIpamIPOK with default headers values
func NewDeleteIpamIPOK() *DeleteIpamIPOK {
	return &DeleteIpamIPOK{}
}

/*
DeleteIpamIPOK describes a response with status code 200, with default header values.

Success
*/
type DeleteIpamIPOK struct {
}

// IsSuccess returns true when this delete ipam Ip o k response has a 2xx status code
func (o *DeleteIpamIPOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete ipam Ip o k response has a 3xx status code
func (o *DeleteIpamIPOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete ipam Ip o k response has a 4xx status code
func (o *DeleteIpamIPOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete ipam Ip o k response has a 5xx status code
func (o *DeleteIpamIPOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete ipam Ip o k response a status code equal to that given
func (o *DeleteIpamIPOK) IsCode(code int) bool {
	return code == 200
}

func (o *DeleteIpamIPOK) Error() string {
	return fmt.Sprintf("[DELETE /ipam/{ip}][%d] deleteIpamIpOK ", 200)
}

func (o *DeleteIpamIPOK) String() string {
	return fmt.Sprintf("[DELETE /ipam/{ip}][%d] deleteIpamIpOK ", 200)
}

func (o *DeleteIpamIPOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteIpamIPInvalid creates a DeleteIpamIPInvalid with default headers values
func NewDeleteIpamIPInvalid() *DeleteIpamIPInvalid {
	return &DeleteIpamIPInvalid{}
}

/*
DeleteIpamIPInvalid describes a response with status code 400, with default header values.

Invalid IP address
*/
type DeleteIpamIPInvalid struct {
}

// IsSuccess returns true when this delete ipam Ip invalid response has a 2xx status code
func (o *DeleteIpamIPInvalid) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete ipam Ip invalid response has a 3xx status code
func (o *DeleteIpamIPInvalid) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete ipam Ip invalid response has a 4xx status code
func (o *DeleteIpamIPInvalid) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete ipam Ip invalid response has a 5xx status code
func (o *DeleteIpamIPInvalid) IsServerError() bool {
	return false
}

// IsCode returns true when this delete ipam Ip invalid response a status code equal to that given
func (o *DeleteIpamIPInvalid) IsCode(code int) bool {
	return code == 400
}

func (o *DeleteIpamIPInvalid) Error() string {
	return fmt.Sprintf("[DELETE /ipam/{ip}][%d] deleteIpamIpInvalid ", 400)
}

func (o *DeleteIpamIPInvalid) String() string {
	return fmt.Sprintf("[DELETE /ipam/{ip}][%d] deleteIpamIpInvalid ", 400)
}

func (o *DeleteIpamIPInvalid) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteIpamIPForbidden creates a DeleteIpamIPForbidden with default headers values
func NewDeleteIpamIPForbidden() *DeleteIpamIPForbidden {
	return &DeleteIpamIPForbidden{}
}

/*
DeleteIpamIPForbidden describes a response with status code 403, with default header values.

Forbidden
*/
type DeleteIpamIPForbidden struct {
}

// IsSuccess returns true when this delete ipam Ip forbidden response has a 2xx status code
func (o *DeleteIpamIPForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete ipam Ip forbidden response has a 3xx status code
func (o *DeleteIpamIPForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete ipam Ip forbidden response has a 4xx status code
func (o *DeleteIpamIPForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete ipam Ip forbidden response has a 5xx status code
func (o *DeleteIpamIPForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete ipam Ip forbidden response a status code equal to that given
func (o *DeleteIpamIPForbidden) IsCode(code int) bool {
	return code == 403
}

func (o *DeleteIpamIPForbidden) Error() string {
	return fmt.Sprintf("[DELETE /ipam/{ip}][%d] deleteIpamIpForbidden ", 403)
}

func (o *DeleteIpamIPForbidden) String() string {
	return fmt.Sprintf("[DELETE /ipam/{ip}][%d] deleteIpamIpForbidden ", 403)
}

func (o *DeleteIpamIPForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteIpamIPNotFound creates a DeleteIpamIPNotFound with default headers values
func NewDeleteIpamIPNotFound() *DeleteIpamIPNotFound {
	return &DeleteIpamIPNotFound{}
}

/*
DeleteIpamIPNotFound describes a response with status code 404, with default header values.

IP address not found
*/
type DeleteIpamIPNotFound struct {
}

// IsSuccess returns true when this delete ipam Ip not found response has a 2xx status code
func (o *DeleteIpamIPNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete ipam Ip not found response has a 3xx status code
func (o *DeleteIpamIPNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete ipam Ip not found response has a 4xx status code
func (o *DeleteIpamIPNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete ipam Ip not found response has a 5xx status code
func (o *DeleteIpamIPNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete ipam Ip not found response a status code equal to that given
func (o *DeleteIpamIPNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *DeleteIpamIPNotFound) Error() string {
	return fmt.Sprintf("[DELETE /ipam/{ip}][%d] deleteIpamIpNotFound ", 404)
}

func (o *DeleteIpamIPNotFound) String() string {
	return fmt.Sprintf("[DELETE /ipam/{ip}][%d] deleteIpamIpNotFound ", 404)
}

func (o *DeleteIpamIPNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewDeleteIpamIPFailure creates a DeleteIpamIPFailure with default headers values
func NewDeleteIpamIPFailure() *DeleteIpamIPFailure {
	return &DeleteIpamIPFailure{}
}

/*
DeleteIpamIPFailure describes a response with status code 500, with default header values.

Address release failure
*/
type DeleteIpamIPFailure struct {
	Payload models.Error
}

// IsSuccess returns true when this delete ipam Ip failure response has a 2xx status code
func (o *DeleteIpamIPFailure) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete ipam Ip failure response has a 3xx status code
func (o *DeleteIpamIPFailure) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete ipam Ip failure response has a 4xx status code
func (o *DeleteIpamIPFailure) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete ipam Ip failure response has a 5xx status code
func (o *DeleteIpamIPFailure) IsServerError() bool {
	return true
}

// IsCode returns true when this delete ipam Ip failure response a status code equal to that given
func (o *DeleteIpamIPFailure) IsCode(code int) bool {
	return code == 500
}

func (o *DeleteIpamIPFailure) Error() string {
	return fmt.Sprintf("[DELETE /ipam/{ip}][%d] deleteIpamIpFailure  %+v", 500, o.Payload)
}

func (o *DeleteIpamIPFailure) String() string {
	return fmt.Sprintf("[DELETE /ipam/{ip}][%d] deleteIpamIpFailure  %+v", 500, o.Payload)
}

func (o *DeleteIpamIPFailure) GetPayload() models.Error {
	return o.Payload
}

func (o *DeleteIpamIPFailure) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteIpamIPDisabled creates a DeleteIpamIPDisabled with default headers values
func NewDeleteIpamIPDisabled() *DeleteIpamIPDisabled {
	return &DeleteIpamIPDisabled{}
}

/*
DeleteIpamIPDisabled describes a response with status code 501, with default header values.

Allocation for address family disabled
*/
type DeleteIpamIPDisabled struct {
}

// IsSuccess returns true when this delete ipam Ip disabled response has a 2xx status code
func (o *DeleteIpamIPDisabled) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete ipam Ip disabled response has a 3xx status code
func (o *DeleteIpamIPDisabled) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete ipam Ip disabled response has a 4xx status code
func (o *DeleteIpamIPDisabled) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete ipam Ip disabled response has a 5xx status code
func (o *DeleteIpamIPDisabled) IsServerError() bool {
	return true
}

// IsCode returns true when this delete ipam Ip disabled response a status code equal to that given
func (o *DeleteIpamIPDisabled) IsCode(code int) bool {
	return code == 501
}

func (o *DeleteIpamIPDisabled) Error() string {
	return fmt.Sprintf("[DELETE /ipam/{ip}][%d] deleteIpamIpDisabled ", 501)
}

func (o *DeleteIpamIPDisabled) String() string {
	return fmt.Sprintf("[DELETE /ipam/{ip}][%d] deleteIpamIpDisabled ", 501)
}

func (o *DeleteIpamIPDisabled) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}
