/*
cdcd - Command Driven CD player
Copyright (C) 1998-99 Tony Arcieri
Copyright (C) 2001, 2002, 2003 Fabrice Bauzac

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef CMDLINE_H
#define CMDLINE_H

#include "cdcd.h"
#include "mycdaudio.h"
#include "rlhist.h"

#define TYPE_CDI 1
#define TYPE_CDDB 2

/* Valid return values from functions of type Execfunc */
#define XRET_NULL 0		/* Nothing to do. */
#define XRET_BACK 1		/* Go back to previous command-line */
#define XRET_QUIT 2		/* Quit the whole program */

/* argv[0] is the name of the command (e.g. "play") */
typedef int Execfunc (char **args);

typedef int Helpfunc (char **specific_args);

struct Command
{
  char *name;
  char *usage;			/* These are the parameters */
  char *description;		/* name-independant description (this is
				   important for aliases) */
  Execfunc *cmd;		/* The function that is actually called when the
				   command is executed */
  char *alias;			/* If CMD1 is in fact an alias of CMD2, then set
				   NAME to CMD1 and ALIAS to CMD2.  Everything
				   else is ignored. */
  int display_cmdline;		/* If nonzero, then `cdcd --help' will show
				   the command. */
};

#define ALIAS(from, to) { from, 0, 0, 0, to, 0 }

/* Initialize the cmdline.c module.  */
void init_cmdline (void);

/* FIXME: this function is hell */
void get_input_text (char *buffer, char *prompt, int len);
char *trackname_matcher (const char *text, int state);
char **cdcd_completion (char *text, int start, int end);

int read_trackname (char *s, int *ret,
		    struct disc_data *data, struct disc_info *disc);
int read_tv (char *s, struct disc_timeval *ret);
int read_int (char *s, int *ret);
int read_url (char *s, char **ret);
int read_type (char *s, int *ret);

#define ACC_LOCAL 0
#define ACC_REMOTE 1
#define ACC_PROXY 2

int read_access (char *s, int *ret, char **prox);
int dt2sec (struct disc_timeval *dt);
char *cddb_host_prettystr (struct cddb_host *h);
char *cddb_serverlist_prettystr (struct cddb_serverlist *s);
char *cddb_serverlist_prettystr (struct cddb_serverlist *s);
int get_width (void);

int cmd_mainloop (rl_compentry_func_t * cmdmatcher,
		  char *prompt, struct Command *c);
char *command_matcher (struct Command *c, const char *text, int state);
void sort_commands (struct Command *com);
struct Command *find_command (char *name, struct Command *com);
void print_all_commands (struct Command *com, int commandline);
void cmdhelp (struct Command *com, char **argv, int commandline);
int execute_command (char **argv, struct Command *com);

/* Very useful */
#define NOARG                   \
  if(argv[1]) {                 \
    puts("Too many arguments"); \
    return 0;                   \
  }

#endif /* CMDLINE_H */
