/*
 * Decompiled with CFR 0.152.
 */
package eu.bibl.banalysis.asm.insn;

import eu.bibl.banalysis.asm.desc.OpcodeInfo;
import eu.bibl.banalysis.asm.insn.InstructionPattern;
import eu.bibl.banalysis.asm.insn.InstructionSearcher;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InstructionPrinter {
    protected MethodNode mNode;
    protected int[] pattern;
    protected boolean match;
    protected InstructionSearcher searcher;
    protected List<AbstractInsnNode> matchedInsns;
    protected Map<LabelNode, Integer> labels;

    public InstructionPrinter(MethodNode m) {
        this.mNode = m;
        this.labels = new HashMap<LabelNode, Integer>();
        this.match = false;
    }

    public InstructionPrinter(MethodNode m, InstructionPattern pattern) {
        this.mNode = m;
        this.labels = new HashMap<LabelNode, Integer>();
        this.searcher = new InstructionSearcher(m.instructions, pattern);
        this.match = this.searcher.search();
        if (this.match) {
            for (AbstractInsnNode[] ains : this.searcher.getMatches()) {
                for (AbstractInsnNode ain : ains) {
                    this.matchedInsns.add(ain);
                }
            }
        }
    }

    public ArrayList<String> createPrint() {
        ArrayList<String> info = new ArrayList<String>();
        ListIterator it = this.mNode.instructions.iterator();
        while (it.hasNext()) {
            AbstractInsnNode ain = (AbstractInsnNode)it.next();
            String line = "";
            line = ain instanceof VarInsnNode ? this.printVarInsnNode((VarInsnNode)ain, it) : (ain instanceof IntInsnNode ? this.printIntInsnNode((IntInsnNode)ain, it) : (ain instanceof FieldInsnNode ? this.printFieldInsnNode((FieldInsnNode)ain, it) : (ain instanceof MethodInsnNode ? this.printMethodInsnNode((MethodInsnNode)ain, it) : (ain instanceof LdcInsnNode ? this.printLdcInsnNode((LdcInsnNode)ain, it) : (ain instanceof InsnNode ? this.printInsnNode((InsnNode)ain, it) : (ain instanceof JumpInsnNode ? this.printJumpInsnNode((JumpInsnNode)ain, it) : (ain instanceof LineNumberNode ? this.printLineNumberNode((LineNumberNode)ain, it) : (ain instanceof LabelNode ? this.printLabelnode((LabelNode)ain) : (ain instanceof TypeInsnNode ? this.printTypeInsnNode((TypeInsnNode)ain) : (ain instanceof FrameNode ? "" : (ain instanceof IincInsnNode ? this.printIincInsnNode((IincInsnNode)ain) : (ain instanceof TableSwitchInsnNode ? this.printTableSwitchInsnNode((TableSwitchInsnNode)ain) : (ain instanceof LookupSwitchInsnNode ? this.printLookupSwitchInsnNode((LookupSwitchInsnNode)ain) : line + "UNKNOWN-NODE: " + this.nameOpcode(ain.getOpcode()) + " " + ain.toString())))))))))))));
            if (line.equals("")) continue;
            if (this.match && this.matchedInsns.contains(ain)) {
                line = "   -> " + line;
            }
            info.add(line);
        }
        return info;
    }

    protected String printVarInsnNode(VarInsnNode vin, ListIterator<?> it) {
        return this.nameOpcode(vin.getOpcode()) + " " + vin.var;
    }

    protected String printIntInsnNode(IntInsnNode iin, ListIterator<?> it) {
        return this.nameOpcode(iin.getOpcode()) + " " + iin.operand;
    }

    protected String printFieldInsnNode(FieldInsnNode fin, ListIterator<?> it) {
        return this.nameOpcode(fin.getOpcode()) + " " + fin.owner + " " + fin.name + ":" + fin.desc;
    }

    protected String printMethodInsnNode(MethodInsnNode min, ListIterator<?> it) {
        return this.nameOpcode(min.getOpcode()) + " " + min.owner + " " + min.name + ":" + min.desc;
    }

    protected String printLdcInsnNode(LdcInsnNode ldc, ListIterator<?> it) {
        if (ldc.cst instanceof String) {
            return this.nameOpcode(ldc.getOpcode()) + " \"" + ldc.cst + "\" (" + ldc.cst.getClass().getCanonicalName() + ")";
        }
        return this.nameOpcode(ldc.getOpcode()) + " " + ldc.cst + " (" + ldc.cst.getClass().getCanonicalName() + ")";
    }

    protected String printInsnNode(InsnNode in, ListIterator<?> it) {
        return this.nameOpcode(in.getOpcode());
    }

    protected String printJumpInsnNode(JumpInsnNode jin, ListIterator<?> it) {
        String line = this.nameOpcode(jin.getOpcode()) + " L" + this.resolveLabel(jin.label);
        return line;
    }

    protected String printLineNumberNode(LineNumberNode lin, ListIterator<?> it) {
        return "";
    }

    protected String printLabelnode(LabelNode label) {
        return "L" + this.resolveLabel(label);
    }

    protected String printTypeInsnNode(TypeInsnNode tin) {
        return this.nameOpcode(tin.getOpcode()) + " " + tin.desc;
    }

    protected String printIincInsnNode(IincInsnNode iin) {
        return this.nameOpcode(iin.getOpcode()) + " " + iin.var + " " + iin.incr;
    }

    protected String printTableSwitchInsnNode(TableSwitchInsnNode tin) {
        String line = this.nameOpcode(tin.getOpcode()) + " \n";
        List labels = tin.labels;
        int count = 0;
        for (int i = tin.min; i < tin.max; ++i) {
            line = line + "           val: " + i + " -> " + "L" + this.resolveLabel((LabelNode)labels.get(count++)) + "\n";
        }
        line = line + "           default -> L" + this.resolveLabel(tin.dflt) + "";
        return line;
    }

    protected String printLookupSwitchInsnNode(LookupSwitchInsnNode lin) {
        String line = this.nameOpcode(lin.getOpcode()) + ": \n";
        List keys = lin.keys;
        List labels = lin.labels;
        for (int i = 0; i < keys.size(); ++i) {
            int key = (Integer)keys.get(i);
            LabelNode label = (LabelNode)labels.get(i);
            line = line + "           val: " + key + " -> " + "L" + this.resolveLabel(label) + "\n";
        }
        line = line + "           default -> L" + this.resolveLabel(lin.dflt) + "";
        return line;
    }

    protected String nameOpcode(int opcode) {
        return "    " + OpcodeInfo.OPCODES.get(opcode).toLowerCase();
    }

    protected int resolveLabel(LabelNode label) {
        if (this.labels.containsKey(label)) {
            return this.labels.get(label);
        }
        int newLabelIndex = this.labels.size() + 1;
        this.labels.put(label, newLabelIndex);
        return newLabelIndex;
    }

    public String[] getLines() {
        ArrayList<String> lines = this.createPrint();
        return lines.toArray(new String[lines.size()]);
    }

    public static void consolePrint(String[] lines) {
        for (String line : lines) {
            System.out.println(line);
        }
    }

    public static void consolePrint(MethodNode m) {
        InstructionPrinter.consolePrint(new InstructionPrinter(m).getLines());
    }

    public static String[] getLines(MethodNode m) {
        return new InstructionPrinter(m).getLines();
    }

    public static void saveTo(File file, InstructionPrinter printer) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            for (String s : printer.createPrint()) {
                bw.write(s);
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

