export interface BadgeClasses {
    /** Styles applied to the root element. */
    root: string;
    /** Styles applied to the badge `span` element. */
    badge: string;
    /** Styles applied to the badge `span` element if `variant="dot"`. */
    dot: string;
    /** Styles applied to the badge `span` element if `variant="standard"`. */
    standard: string;
    /** Styles applied to the badge `span` element if `anchorOrigin={{ 'top', 'right' }}`. */
    anchorOriginTopRight: string;
    /** Styles applied to the badge `span` element if `anchorOrigin={{ 'bottom', 'right' }}`. */
    anchorOriginBottomRight: string;
    /** Styles applied to the badge `span` element if `anchorOrigin={{ 'top', 'left' }}`. */
    anchorOriginTopLeft: string;
    /** Styles applied to the badge `span` element if `anchorOrigin={{ 'bottom', 'left' }}`. */
    anchorOriginBottomLeft: string;
    /** State class applied to the badge `span` element if `invisible={true}`. */
    invisible: string;
    /** Styles applied to the badge `span` element if `color="primary"`. */
    colorPrimary: string;
    /** Styles applied to the badge `span` element if `color="secondary"`. */
    colorSecondary: string;
    /** Styles applied to the badge `span` element if `color="error"`. */
    colorError: string;
    /** Styles applied to the badge `span` element if `color="info"`. */
    colorInfo: string;
    /** Styles applied to the badge `span` element if `color="success"`. */
    colorSuccess: string;
    /** Styles applied to the badge `span` element if `color="warning"`. */
    colorWarning: string;
    /** Styles applied to the badge `span` element if `anchorOrigin={{ 'top', 'right' }} overlap="rectangular"`. */
    anchorOriginTopRightRectangular: string;
    /** Styles applied to the badge `span` element if `anchorOrigin={{ 'bottom', 'right' }} overlap="rectangular"`. */
    anchorOriginBottomRightRectangular: string;
    /** Styles applied to the badge `span` element if `anchorOrigin={{ 'top', 'left' }} overlap="rectangular"`. */
    anchorOriginTopLeftRectangular: string;
    /** Styles applied to the badge `span` element if `anchorOrigin={{ 'bottom', 'left' }} overlap="rectangular"`. */
    anchorOriginBottomLeftRectangular: string;
    /** Styles applied to the badge `span` element if `anchorOrigin={{ 'top', 'right' }} overlap="circular"`. */
    anchorOriginTopRightCircular: string;
    /** Styles applied to the badge `span` element if `anchorOrigin={{ 'bottom', 'right' }} overlap="circular"`. */
    anchorOriginBottomRightCircular: string;
    /** Styles applied to the badge `span` element if `anchorOrigin={{ 'top', 'left' }} overlap="circular"`. */
    anchorOriginTopLeftCircular: string;
    /** Styles applied to the badge `span` element if `anchorOrigin={{ 'bottom', 'left' }} overlap="circular"`. */
    anchorOriginBottomLeftCircular: string;
    /** Styles applied to the badge `span` element if `overlap="rectangular"`. */
    overlapRectangular: string;
    /** Styles applied to the badge `span` element if `overlap="circular"`. */
    overlapCircular: string;
}
export type BadgeClassKey = keyof BadgeClasses;
export declare function getBadgeUtilityClass(slot: string): string;
declare const badgeClasses: BadgeClasses;
export default badgeClasses;
