/**
 * Copyright (c) "Neo4j"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import ConnectionProvider from '../connection-provider';
import { ServerInfo } from '../result-summary';
/**
 * Verifies connectivity using the given connection provider.
 */
export declare class ConnectivityVerifier {
    private readonly _connectionProvider;
    /**
     * @constructor
     * @param {ConnectionProvider} connectionProvider the provider to obtain connections from.
     */
    constructor(connectionProvider: ConnectionProvider);
    /**
     * Try to obtain a working connection from the connection provider.
     * @returns {Promise<object>} promise resolved with server info or rejected with error.
     */
    verify({ database }?: {
        database?: string | undefined;
    }): Promise<ServerInfo>;
}
