import React from 'react';

export interface FrameProps {
  accessibility?: boolean;
  autoSize?: boolean | 'width' | 'height';
  springConfig?: { [key: string]: number };
  tag?: string;
}

export interface Formatters {
  getAltText?: (props: CommonProps) => string;
  getNextLabel?: (props: CommonProps) => string;
  getPrevLabel?: (props: CommonProps) => string;
  getNextTitle?: (props: CommonProps) => string;
  getPrevTitle?: (props: CommonProps) => string;
  getCloseLabel?: (props: CommonProps) => string;
  getFullscreenLabel?: (props: CommonProps) => string;
}

export interface TrackProps {
  align?: number;
  animations?: Array<{ props: string, stops: Array<[number, number]> }>;
  axis?: 'x' | 'y';
  contain?: boolean;
  currentView?: any;
  flickTimeout?: number;
  infinite?: boolean;
  instant?: boolean;
  onRest?: () => void;
  onScroll?: () => void;
  onSwipeEnd?: () => void;
  onSwipeMove?: () => void;
  onSwipeStart?: () => void;
  onViewChange?: (view: number) => void;
  springConfig?: { [key: string]: number };
  swipe?: boolean | 'mouse' | 'touch';
  swipeThreshold?: number;
  tag?: any;
  viewsToMove?: number;
  viewsToShow?: number | 'auto';
}

export interface ViewType {
  caption?: React.ReactNode;
  source: string | {
    download?: string;
    fullscreen?: string;
    regular: string;
    thumbnail?: string;
  };
}

export interface CarouselModalProps {
  allowFullscreen?: boolean;
  isFullscreen?: boolean;
  onClose?(event: React.SyntheticEvent<HTMLButtonElement>): void;
  toggleFullscreen?: () => void;
}

export interface ModalProps {
  allowFullscreen?: boolean;
  children?: React.ReactNode;
  closeOnBackdropClick?: boolean;
  closeOnEsc?: boolean;
  onClose?(event: React.SyntheticEvent<HTMLButtonElement>): void;
  styles?: {
    blanket?(base: React.CSSProperties, state: any): React.CSSProperties;
    dialog?(base: React.CSSProperties, state: any): React.CSSProperties;
    positioner?(base: React.CSSProperties, state: any): React.CSSProperties;
  };
}

export interface CommonProps {
  carouselProps?: CarouselProps;
  currentIndex?: number;
  currentView?: ViewType;
  frameProps?: FrameProps;
  getStyles?(base: React.CSSProperties, state: any): React.CSSProperties;
  innerProps?: { [key: string]: any };
  isFullscreen?: boolean;
  isModal?: boolean;
  modalProps?: CarouselModalProps;
  interactionIsIdle?: boolean;
  trackProps?: TrackProps;
  views?: Array<ViewType>;
}

export type Components = {
  Container?: React.ComponentType<CommonProps>,
  Footer?: React.ComponentType<CommonProps>,
  FooterCaption?: React.ComponentType<CommonProps>,
  FooterCount?: React.ComponentType<CommonProps>,
  Header?: React.ComponentType<CommonProps>,
  HeaderClose?: React.ComponentType<CommonProps>,
  HeaderFullscreen?: React.ComponentType<CommonProps>,
  Navigation?: React.ComponentType<CommonProps>,
  NavigationPrev?: React.ComponentType<CommonProps>,
  NavigationNext?: React.ComponentType<CommonProps>,
  View?: React.ComponentType<CommonProps>,
};

export interface CarouselState {
  isFullscreen?: boolean;
  isModal?: boolean;
  interactionIsIdle?: boolean;
}

export interface CarouselStyles {
  container?(base: React.CSSProperties, state: CarouselState): React.CSSProperties;
  footer?(base: React.CSSProperties, state: CarouselState): React.CSSProperties;
  footerCaption?(base: React.CSSProperties, state: CarouselState): React.CSSProperties;
  footerCount?(base: React.CSSProperties, state: CarouselState): React.CSSProperties;
  header?(base: React.CSSProperties, state: CarouselState): React.CSSProperties;
  headerClose?(base: React.CSSProperties, state: CarouselState): React.CSSProperties;
  headerFullscreen?(base: React.CSSProperties, state: CarouselState): React.CSSProperties;
  navigation?(base: React.CSSProperties, state: CarouselState): React.CSSProperties;
  navigationPrev?(base: React.CSSProperties, state: CarouselState): React.CSSProperties;
  navigationNext?(base: React.CSSProperties, state: CarouselState): React.CSSProperties;
  view?(base: React.CSSProperties, state: CarouselState): React.CSSProperties;
}

export interface CarouselProps {
  components?: Components;
  currentIndex?: number;
  frameProps?: FrameProps;
  formatters?: Formatters;
  hideControlsWhenIdle?: number | false;
  modalProps?: CarouselModalProps;
  styles?: CarouselStyles;
  trackProps?: TrackProps;
  views: Array<ViewType>;
}

declare const Carousel: React.ComponentType<CarouselProps>;

declare const Modal: React.ComponentType<ModalProps>;

declare const ModalGateway: React.ComponentType<{}>;

export default Carousel;
export { Modal, ModalGateway };