import { PropsWithChildren } from 'react';
import type { AsyncSupportProps, ExtendablePromise } from './types';
/**
 * Props for IfAsync
 */
interface Props<T> extends AsyncSupportProps, PropsWithChildren<{
    promise: ExtendablePromise<T>;
}> {
}
/**
 * Is included in the `<If />` component, rendered when the condition prop of `<If />` is a Promise;
 * Renders the Fallback component, if contains any, until provided promise is fulfilled;
 * Renders `<Then />` when promise is fulfilled, `<Else />` when rejected
 */
export declare function IfAsync<T = any>({ promise, keepAlive, children }: Props<T>): JSX.Element | null;
export {};
//# sourceMappingURL=IfAsync.d.ts.map