/*
 * Copyright (c) 2020 Bitdefender
 * SPDX-License-Identifier: Apache-2.0
 */
#include "disasm.hpp"


std::string enc_mode_to_str(const uint8_t enc_mode)
{
    switch (enc_mode) {
    case ND_ENCM_LEGACY: return "legacy";
    case ND_ENCM_XOP: return "xop";
    case ND_ENCM_VEX: return "vex";
    case ND_ENCM_EVEX: return "evex";
    }

    return "<unknown>";
}


std::string op_enc_to_str(const ND_OPERAND_ENCODING Encoding)
{
    switch (Encoding) {
    case ND_OPE_NP: return "NP";
    case ND_OPE_R: return "R";
    case ND_OPE_M: return "M";
    case ND_OPE_V: return "V";
    case ND_OPE_O: return "O";
    case ND_OPE_I: return "I";
    case ND_OPE_D: return "D";
    case ND_OPE_C: return "C";
    case ND_OPE_1: return "1";
    case ND_OPE_A: return "A";
    case ND_OPE_L: return "L";
    case ND_OPE_E: return "E";
    case ND_OPE_S: return "S";
    default: return "";
    }
}


std::string op_type_to_str(const ND_OPERAND_TYPE type)
{
    switch(type) {
    case ND_OP_NOT_PRESENT:
        return "not_present";
    case ND_OP_REG:
        return "register";
    case ND_OP_MEM:
        return "memory";
    case ND_OP_IMM:
        return "immediate";
    case ND_OP_OFFS:
        return "offset";
    case ND_OP_ADDR:
        return "address";
    case ND_OP_CONST:
        return "const";
    case ND_OP_BANK:
        return "bank";
    }

    return "<unknown>";
}


std::string ins_class_to_str(const ND_INS_CLASS cls)
{
    switch (cls) {
    case ND_INS_INVALID: return "invalid";
    case ND_INS_AAA: return "aaa";
    case ND_INS_AAD: return "aad";
    case ND_INS_AAM: return "aam";
    case ND_INS_AAS: return "aas";
    case ND_INS_ADC: return "adc";
    case ND_INS_ADCX: return "adcx";
    case ND_INS_ADD: return "add";
    case ND_INS_ADDPD: return "addpd";
    case ND_INS_ADDPS: return "addps";
    case ND_INS_ADDSD: return "addsd";
    case ND_INS_ADDSS: return "addss";
    case ND_INS_ADDSUBPD: return "addsubpd";
    case ND_INS_ADDSUBPS: return "addsubps";
    case ND_INS_ADOX: return "adox";
    case ND_INS_AESDEC: return "aesdec";
    case ND_INS_AESDEC128KL: return "aesdec128kl";
    case ND_INS_AESDEC256KL: return "aesdec256kl";
    case ND_INS_AESDECWIDE128KL: return "aesdecwide128kl";
    case ND_INS_AESDECWIDE256KL: return "aesdecwide256kl";
    case ND_INS_AESDECLAST: return "aesdeclast";
    case ND_INS_AESENC: return "aesenc";
    case ND_INS_AESENC128KL: return "aesenc128kl";
    case ND_INS_AESENC256KL: return "aesenc256kl";
    case ND_INS_AESENCWIDE128KL: return "aesencwide128kl";
    case ND_INS_AESENCWIDE256KL: return "aesencwide256kl";
    case ND_INS_AESENCLAST: return "aesenclast";
    case ND_INS_AESIMC: return "aesimc";
    case ND_INS_AESKEYGENASSIST: return "aeskeygenassist";
    case ND_INS_ALTINST: return "altinst";
    case ND_INS_AND: return "and";
    case ND_INS_ANDN: return "andn";
    case ND_INS_ANDNPD: return "andnpd";
    case ND_INS_ANDNPS: return "andnps";
    case ND_INS_ANDPD: return "andpd";
    case ND_INS_ANDPS: return "andps";
    case ND_INS_ARPL: return "arpl";
    case ND_INS_BEXTR: return "bextr";
    case ND_INS_BLCFILL: return "blcfill";
    case ND_INS_BLCI: return "blci";
    case ND_INS_BLCIC: return "blcic";
    case ND_INS_BLCMSK: return "blcmsk";
    case ND_INS_BLCS: return "blcs";
    case ND_INS_BLENDPD: return "blendpd";
    case ND_INS_BLENDPS: return "blendps";
    case ND_INS_BLENDVPD: return "blendvpd";
    case ND_INS_BLENDVPS: return "blendvps";
    case ND_INS_BLSFILL: return "blsfill";
    case ND_INS_BLSI: return "blsi";
    case ND_INS_BLSIC: return "blsic";
    case ND_INS_BLSMSK: return "blsmsk";
    case ND_INS_BLSR: return "blsr";
    case ND_INS_BNDCL: return "bndcl";
    case ND_INS_BNDCN: return "bndcn";
    case ND_INS_BNDCU: return "bndcu";
    case ND_INS_BNDLDX: return "bndldx";
    case ND_INS_BNDMK: return "bndmk";
    case ND_INS_BNDMOV: return "bndmov";
    case ND_INS_BNDSTX: return "bndstx";
    case ND_INS_BOUND: return "bound";
    case ND_INS_BSF: return "bsf";
    case ND_INS_BSR: return "bsr";
    case ND_INS_BSWAP: return "bswap";
    case ND_INS_BT: return "bt";
    case ND_INS_BTC: return "btc";
    case ND_INS_BTR: return "btr";
    case ND_INS_BTS: return "bts";
    case ND_INS_BZHI: return "bzhi";
    case ND_INS_CALLFD: return "callfd";
    case ND_INS_CALLFI: return "callfi";
    case ND_INS_CALLNI: return "callni";
    case ND_INS_CALLNR: return "callnr";
    case ND_INS_CBW: return "cbw";
    case ND_INS_CDQ: return "cdq";
    case ND_INS_CDQE: return "cdqe";
    case ND_INS_CLAC: return "clac";
    case ND_INS_CLC: return "clc";
    case ND_INS_CLD: return "cld";
    case ND_INS_CLDEMOTE: return "cldemote";
    case ND_INS_CLEVICT0: return "clevict0";
    case ND_INS_CLEVICT1: return "clevict1";
    case ND_INS_CLFLUSH: return "clflush";
    case ND_INS_CLFLUSHOPT: return "clflushopt";
    case ND_INS_CLGI: return "clgi";
    case ND_INS_CLI: return "cli";
    case ND_INS_CLRSSBSY: return "clrssbsy";
    case ND_INS_CLTS: return "clts";
    case ND_INS_CLWB: return "clwb";
    case ND_INS_CLZERO: return "clzero";
    case ND_INS_CMC: return "cmc";
    case ND_INS_CMOVcc: return "cmovcc";
    case ND_INS_CMP: return "cmp";
    case ND_INS_CMPPD: return "cmppd";
    case ND_INS_CMPPS: return "cmpps";
    case ND_INS_CMPS: return "cmps";
    case ND_INS_CMPSD: return "cmpsd";
    case ND_INS_CMPSS: return "cmpss";
    case ND_INS_CMPXCHG: return "cmpxchg";
    case ND_INS_CMPXCHG16B: return "cmpxchg16b";
    case ND_INS_CMPXCHG8B: return "cmpxchg8b";
    case ND_INS_COMISD: return "comisd";
    case ND_INS_COMISS: return "comiss";
    case ND_INS_CPUID: return "cpuid";
    case ND_INS_CPU_READ: return "cpuread";
    case ND_INS_CPU_WRITE: return "cpuwrite";
    case ND_INS_CQO: return "cqo";
    case ND_INS_CRC32: return "crc32";
    case ND_INS_CVTDQ2PD: return "cvtdq2pd";
    case ND_INS_CVTDQ2PS: return "cvtdq2ps";
    case ND_INS_CVTPD2DQ: return "cvtpd2dq";
    case ND_INS_CVTPD2PI: return "cvtpd2pi";
    case ND_INS_CVTPD2PS: return "cvtpd2ps";
    case ND_INS_CVTPI2PD: return "cvtpi2pd";
    case ND_INS_CVTPI2PS: return "cvtpi2ps";
    case ND_INS_CVTPS2DQ: return "cvtps2dq";
    case ND_INS_CVTPS2PD: return "cvtps2pd";
    case ND_INS_CVTPS2PI: return "cvtps2pi";
    case ND_INS_CVTSD2SI: return "cvtsd2si";
    case ND_INS_CVTSD2SS: return "cvtsd2ss";
    case ND_INS_CVTSI2SD: return "cvtsi2sd";
    case ND_INS_CVTSI2SS: return "cvtsi2ss";
    case ND_INS_CVTSS2SD: return "cvtss2sd";
    case ND_INS_CVTSS2SI: return "cvtss2si";
    case ND_INS_CVTTPD2DQ: return "cvttpd2dq";
    case ND_INS_CVTTPD2PI: return "cvttpd2pi";
    case ND_INS_CVTTPS2DQ: return "cvttps2dq";
    case ND_INS_CVTTPS2PI: return "cvttps2pi";
    case ND_INS_CVTTSD2SI: return "cvttsd2si";
    case ND_INS_CVTTSS2SI: return "cvttss2si";
    case ND_INS_CWD: return "cwd";
    case ND_INS_CWDE: return "cwde";
    case ND_INS_DAA: return "daa";
    case ND_INS_DAS: return "das";
    case ND_INS_DEC: return "dec";
    case ND_INS_DELAY: return "delay";
    case ND_INS_DIV: return "div";
    case ND_INS_DIVPD: return "divpd";
    case ND_INS_DIVPS: return "divps";
    case ND_INS_DIVSD: return "divsd";
    case ND_INS_DIVSS: return "divss";
    case ND_INS_DMINT: return "dmint";
    case ND_INS_DPPD: return "dppd";
    case ND_INS_DPPS: return "dpps";
    case ND_INS_EMMS: return "emms";
    case ND_INS_ENCLS: return "encls";
    case ND_INS_ENCLU: return "enclu";
    case ND_INS_ENCLV: return "enclv";
    case ND_INS_ENCODEKEY128: return "encodekey128";
    case ND_INS_ENCODEKEY256: return "encodekey256";
    case ND_INS_ENDBR: return "endbr";
    case ND_INS_ENQCMD: return "enqcmd";
    case ND_INS_ENQCMDS: return "enqcmds";
    case ND_INS_ENTER: return "enter";
    case ND_INS_ERETS: return "erets";
    case ND_INS_ERETU: return "eretu";
    case ND_INS_EXTRACTPS: return "extractps";
    case ND_INS_EXTRQ: return "extrq";
    case ND_INS_F2XM1: return "f2xm1";
    case ND_INS_FABS: return "fabs";
    case ND_INS_FADD: return "fadd";
    case ND_INS_FADDP: return "faddp";
    case ND_INS_FBLD: return "fbld";
    case ND_INS_FBSTP: return "fbstp";
    case ND_INS_FCHS: return "fchs";
    case ND_INS_FCMOVB: return "fcmovb";
    case ND_INS_FCMOVBE: return "fcmovbe";
    case ND_INS_FCMOVE: return "fcmove";
    case ND_INS_FCMOVNB: return "fcmovnb";
    case ND_INS_FCMOVNBE: return "fcmovnbe";
    case ND_INS_FCMOVNE: return "fcmovne";
    case ND_INS_FCMOVNU: return "fcmovnu";
    case ND_INS_FCMOVU: return "fcmovu";
    case ND_INS_FCOM: return "fcom";
    case ND_INS_FCOMI: return "fcomi";
    case ND_INS_FCOMIP: return "fcomip";
    case ND_INS_FCOMP: return "fcomp";
    case ND_INS_FCOMPP: return "fcompp";
    case ND_INS_FCOS: return "fcos";
    case ND_INS_FDECSTP: return "fdecstp";
    case ND_INS_FDIV: return "fdiv";
    case ND_INS_FDIVP: return "fdivp";
    case ND_INS_FDIVR: return "fdivr";
    case ND_INS_FDIVRP: return "fdivrp";
    case ND_INS_FEMMS: return "femms";
    case ND_INS_FFREE: return "ffree";
    case ND_INS_FFREEP: return "ffreep";
    case ND_INS_FIADD: return "fiadd";
    case ND_INS_FICOM: return "ficom";
    case ND_INS_FICOMP: return "ficomp";
    case ND_INS_FIDIV: return "fidiv";
    case ND_INS_FIDIVR: return "fidivr";
    case ND_INS_FILD: return "fild";
    case ND_INS_FIMUL: return "fimul";
    case ND_INS_FINCSTP: return "fincstp";
    case ND_INS_FIST: return "fist";
    case ND_INS_FISTP: return "fistp";
    case ND_INS_FISTTP: return "fisttp";
    case ND_INS_FISUB: return "fisub";
    case ND_INS_FISUBR: return "fisubr";
    case ND_INS_FLD: return "fld";
    case ND_INS_FLD1: return "fld1";
    case ND_INS_FLDCW: return "fldcw";
    case ND_INS_FLDENV: return "fldenv";
    case ND_INS_FLDL2E: return "fldl2e";
    case ND_INS_FLDL2T: return "fldl2t";
    case ND_INS_FLDLG2: return "fldlg2";
    case ND_INS_FLDLN2: return "fldln2";
    case ND_INS_FLDPI: return "fldpi";
    case ND_INS_FLDZ: return "fldz";
    case ND_INS_FMUL: return "fmul";
    case ND_INS_FMULP: return "fmulp";
    case ND_INS_FNCLEX: return "fnclex";
    case ND_INS_FNDISI: return "fndisi";
    case ND_INS_FNINIT: return "fninit";
    case ND_INS_FNOP: return "fnop";
    case ND_INS_FNSAVE: return "fnsave";
    case ND_INS_FNSTCW: return "fnstcw";
    case ND_INS_FNSTENV: return "fnstenv";
    case ND_INS_FNSTSW: return "fnstsw";
    case ND_INS_FPATAN: return "fpatan";
    case ND_INS_FPREM: return "fprem";
    case ND_INS_FPREM1: return "fprem1";
    case ND_INS_FPTAN: return "fptan";
    case ND_INS_FRINEAR: return "frinear";
    case ND_INS_FRNDINT: return "frndint";
    case ND_INS_FRSTOR: return "frstor";
    case ND_INS_FSCALE: return "fscale";
    case ND_INS_FSIN: return "fsin";
    case ND_INS_FSINCOS: return "fsincos";
    case ND_INS_FSQRT: return "fsqrt";
    case ND_INS_FST: return "fst";
    case ND_INS_FSTDW: return "fstdw";
    case ND_INS_FSTP: return "fstp";
    case ND_INS_FSTPNCE: return "fstpnce";
    case ND_INS_FSTSG: return "fstsg";
    case ND_INS_FSUB: return "fsub";
    case ND_INS_FSUBP: return "fsubp";
    case ND_INS_FSUBR: return "fsubr";
    case ND_INS_FSUBRP: return "fsubrp";
    case ND_INS_FTST: return "ftst";
    case ND_INS_FUCOM: return "fucom";
    case ND_INS_FUCOMI: return "fucomi";
    case ND_INS_FUCOMIP: return "fucomip";
    case ND_INS_FUCOMP: return "fucomp";
    case ND_INS_FUCOMPP: return "fucompp";
    case ND_INS_FXAM: return "fxam";
    case ND_INS_FXCH: return "fxch";
    case ND_INS_FXRSTOR: return "fxrstor";
    case ND_INS_FXRSTOR64: return "fxrstor64";
    case ND_INS_FXSAVE: return "fxsave";
    case ND_INS_FXSAVE64: return "fxsave64";
    case ND_INS_FXTRACT: return "fxtract";
    case ND_INS_FYL2X: return "fyl2x";
    case ND_INS_FYL2XP1: return "fyl2xp1";
    case ND_INS_GETSEC: return "getsec";
    case ND_INS_GF2P8AFFINEINVQB: return "gf2p8affineinvqb";
    case ND_INS_GF2P8AFFINEQB: return "gf2p8affineqb";
    case ND_INS_GF2P8MULB: return "gf2p8mulb";
    case ND_INS_HADDPD: return "haddpd";
    case ND_INS_HADDPS: return "haddps";
    case ND_INS_HLT: return "hlt";
    case ND_INS_HSUBPD: return "hsubpd";
    case ND_INS_HSUBPS: return "hsubps";
    case ND_INS_IDIV: return "idiv";
    case ND_INS_IMUL: return "imul";
    case ND_INS_IN: return "in";
    case ND_INS_INC: return "inc";
    case ND_INS_INCSSP: return "incssp";
    case ND_INS_INS: return "ins";
    case ND_INS_INSERTPS: return "insertps";
    case ND_INS_INSERTQ: return "insertq";
    case ND_INS_INT: return "int";
    case ND_INS_INT1: return "int1";
    case ND_INS_INT3: return "int3";
    case ND_INS_INTO: return "into";
    case ND_INS_INVD: return "invd";
    case ND_INS_INVEPT: return "invept";
    case ND_INS_INVLPG: return "invlpg";
    case ND_INS_INVLPGA: return "invlpga";
    case ND_INS_INVLPGB: return "invlpgb";
    case ND_INS_INVPCID: return "invpcid";
    case ND_INS_INVVPID: return "invvpid";
    case ND_INS_IRET: return "iret";
    case ND_INS_JMPE: return "jmpe";
    case ND_INS_JMPFD: return "jmpfd";
    case ND_INS_JMPFI: return "jmpfi";
    case ND_INS_JMPNI: return "jmpni";
    case ND_INS_JMPNR: return "jmpnr";
    case ND_INS_Jcc: return "jcc";
    case ND_INS_JrCXZ: return "jrcxz";
    case ND_INS_KADD: return "kadd";
    case ND_INS_KAND: return "kand";
    case ND_INS_KANDN: return "kandn";
    case ND_INS_KMERGE2L1H: return "kmerge2l1h";
    case ND_INS_KMERGE2L1L: return "kmerge2l1l";
    case ND_INS_KMOV: return "kmov";
    case ND_INS_KNOT: return "knot";
    case ND_INS_KOR: return "kor";
    case ND_INS_KORTEST: return "kortest";
    case ND_INS_KSHIFTL: return "kshiftl";
    case ND_INS_KSHIFTR: return "kshiftr";
    case ND_INS_KTEST: return "ktest";
    case ND_INS_KUNPCKBW: return "kunpckbw";
    case ND_INS_KUNPCKDQ: return "kunpckdq";
    case ND_INS_KUNPCKWD: return "kunpckwd";
    case ND_INS_KXNOR: return "kxnor";
    case ND_INS_KXOR: return "kxor";
    case ND_INS_LAHF: return "lahf";
    case ND_INS_LAR: return "lar";
    case ND_INS_LDDQU: return "lddqu";
    case ND_INS_LDMXCSR: return "ldmxcsr";
    case ND_INS_LDS: return "lds";
    case ND_INS_LDTILECFG: return "ldtilecfg";
    case ND_INS_LEA: return "lea";
    case ND_INS_LEAVE: return "leave";
    case ND_INS_LES: return "les";
    case ND_INS_LFENCE: return "lfence";
    case ND_INS_LFS: return "lfs";
    case ND_INS_LGDT: return "lgdt";
    case ND_INS_LGS: return "lgs";
    case ND_INS_LIDT: return "lidt";
    case ND_INS_LKGS: return "lkgs";
    case ND_INS_LLDT: return "lldt";
    case ND_INS_LLWPCB: return "llwpcb";
    case ND_INS_LMSW: return "lmsw";
    case ND_INS_LOADIWKEY: return "loadiwkey";
    case ND_INS_LODS: return "lods";
    case ND_INS_LOOP: return "loop";
    case ND_INS_LOOPNZ: return "loopnz";
    case ND_INS_LOOPZ: return "loopz";
    case ND_INS_LSL: return "lsl";
    case ND_INS_LSS: return "lss";
    case ND_INS_LTR: return "ltr";
    case ND_INS_LWPINS: return "lwpins";
    case ND_INS_LWPVAL: return "lwpval";
    case ND_INS_LZCNT: return "lzcnt";
    case ND_INS_MASKMOVDQU: return "maskmovdqu";
    case ND_INS_MASKMOVQ: return "maskmovq";
    case ND_INS_MAXPD: return "maxpd";
    case ND_INS_MAXPS: return "maxps";
    case ND_INS_MAXSD: return "maxsd";
    case ND_INS_MAXSS: return "maxss";
    case ND_INS_MCOMMIT: return "mcommit";
    case ND_INS_MFENCE: return "mfence";
    case ND_INS_MINPD: return "minpd";
    case ND_INS_MINPS: return "minps";
    case ND_INS_MINSD: return "minsd";
    case ND_INS_MINSS: return "minss";
    case ND_INS_MONITOR: return "monitor";
    case ND_INS_MONITORX: return "monitorx";
    case ND_INS_MONTMUL: return "montmul";
    case ND_INS_MOV: return "mov";
    case ND_INS_MOVAPD: return "movapd";
    case ND_INS_MOVAPS: return "movaps";
    case ND_INS_MOVBE: return "movbe";
    case ND_INS_MOVD: return "movd";
    case ND_INS_MOVDDUP: return "movddup";
    case ND_INS_MOVDIR64B: return "movdir64b";
    case ND_INS_MOVDIRI: return "movdiri";
    case ND_INS_MOVDQ2Q: return "movdq2q";
    case ND_INS_MOVDQA: return "movdqa";
    case ND_INS_MOVDQU: return "movdqu";
    case ND_INS_MOVHLPS: return "movhlps";
    case ND_INS_MOVHPD: return "movhpd";
    case ND_INS_MOVHPS: return "movhps";
    case ND_INS_MOVLHPS: return "movlhps";
    case ND_INS_MOVLPD: return "movlpd";
    case ND_INS_MOVLPS: return "movlps";
    case ND_INS_MOVMSKPD: return "movmskpd";
    case ND_INS_MOVMSKPS: return "movmskps";
    case ND_INS_MOVNTDQ: return "movntdq";
    case ND_INS_MOVNTDQA: return "movntdqa";
    case ND_INS_MOVNTI: return "movnti";
    case ND_INS_MOVNTPD: return "movntpd";
    case ND_INS_MOVNTPS: return "movntps";
    case ND_INS_MOVNTQ: return "movntq";
    case ND_INS_MOVNTSD: return "movntsd";
    case ND_INS_MOVNTSS: return "movntss";
    case ND_INS_MOVQ: return "movq";
    case ND_INS_MOVQ2DQ: return "movq2dq";
    case ND_INS_MOVS: return "movs";
    case ND_INS_MOVSD: return "movsd";
    case ND_INS_MOVSHDUP: return "movshdup";
    case ND_INS_MOVSLDUP: return "movsldup";
    case ND_INS_MOVSS: return "movss";
    case ND_INS_MOVSX: return "movsx";
    case ND_INS_MOVSXD: return "movsxd";
    case ND_INS_MOVUPD: return "movupd";
    case ND_INS_MOVUPS: return "movups";
    case ND_INS_MOVZX: return "movzx";
    case ND_INS_MOV_CR: return "movcr";
    case ND_INS_MOV_DR: return "movdr";
    case ND_INS_MOV_TR: return "movtr";
    case ND_INS_MPSADBW: return "mpsadbw";
    case ND_INS_MUL: return "mul";
    case ND_INS_MULPD: return "mulpd";
    case ND_INS_MULPS: return "mulps";
    case ND_INS_MULSD: return "mulsd";
    case ND_INS_MULSS: return "mulss";
    case ND_INS_MULX: return "mulx";
    case ND_INS_MWAIT: return "mwait";
    case ND_INS_MWAITX: return "mwaitx";
    case ND_INS_NEG: return "neg";
    case ND_INS_NOP: return "nop";
    case ND_INS_NOT: return "not";
    case ND_INS_OR: return "or";
    case ND_INS_ORPD: return "orpd";
    case ND_INS_ORPS: return "orps";
    case ND_INS_OUT: return "out";
    case ND_INS_OUTS: return "outs";
    case ND_INS_PABSB: return "pabsb";
    case ND_INS_PABSD: return "pabsd";
    case ND_INS_PABSW: return "pabsw";
    case ND_INS_PACKSSDW: return "packssdw";
    case ND_INS_PACKSSWB: return "packsswb";
    case ND_INS_PACKUSDW: return "packusdw";
    case ND_INS_PACKUSWB: return "packuswb";
    case ND_INS_PADDB: return "paddb";
    case ND_INS_PADDD: return "paddd";
    case ND_INS_PADDQ: return "paddq";
    case ND_INS_PADDSB: return "paddsb";
    case ND_INS_PADDSW: return "paddsw";
    case ND_INS_PADDUSB: return "paddusb";
    case ND_INS_PADDUSW: return "paddusw";
    case ND_INS_PADDW: return "paddw";
    case ND_INS_PALIGNR: return "palignr";
    case ND_INS_PAND: return "pand";
    case ND_INS_PANDN: return "pandn";
    case ND_INS_PAUSE: return "pause";
    case ND_INS_PAVGB: return "pavgb";
    case ND_INS_PAVGUSB: return "pavgusb";
    case ND_INS_PAVGW: return "pavgw";
    case ND_INS_PBLENDVB: return "pblendvb";
    case ND_INS_PBLENDW: return "pblendw";
    case ND_INS_PCLMULQDQ: return "pclmulqdq";
    case ND_INS_PCMPEQB: return "pcmpeqb";
    case ND_INS_PCMPEQD: return "pcmpeqd";
    case ND_INS_PCMPEQQ: return "pcmpeqq";
    case ND_INS_PCMPEQW: return "pcmpeqw";
    case ND_INS_PCMPESTRI: return "pcmpestri";
    case ND_INS_PCMPESTRM: return "pcmpestrm";
    case ND_INS_PCMPGTB: return "pcmpgtb";
    case ND_INS_PCMPGTD: return "pcmpgtd";
    case ND_INS_PCMPGTQ: return "pcmpgtq";
    case ND_INS_PCMPGTW: return "pcmpgtw";
    case ND_INS_PCMPISTRI: return "pcmpistri";
    case ND_INS_PCMPISTRM: return "pcmpistrm";
    case ND_INS_PCONFIG: return "pconfig";
    case ND_INS_PDEP: return "pdep";
    case ND_INS_PEXT: return "pext";
    case ND_INS_PEXTRB: return "pextrb";
    case ND_INS_PEXTRD: return "pextrd";
    case ND_INS_PEXTRQ: return "pextrq";
    case ND_INS_PEXTRW: return "pextrw";
    case ND_INS_PF2ID: return "pf2id";
    case ND_INS_PF2IW: return "pf2iw";
    case ND_INS_PFACC: return "pfacc";
    case ND_INS_PFADD: return "pfadd";
    case ND_INS_PFCMPEQ: return "pfcmpeq";
    case ND_INS_PFCMPGE: return "pfcmpge";
    case ND_INS_PFCMPGT: return "pfcmpgt";
    case ND_INS_PFMAX: return "pfmax";
    case ND_INS_PFMIN: return "pfmin";
    case ND_INS_PFMUL: return "pfmul";
    case ND_INS_PFNACC: return "pfnacc";
    case ND_INS_PFPNACC: return "pfpnacc";
    case ND_INS_PFRCP: return "pfrcp";
    case ND_INS_PFRCPIT1: return "pfrcpit1";
    case ND_INS_PFRCPIT2: return "pfrcpit2";
    case ND_INS_PFRCPV: return "pfrcpv";
    case ND_INS_PFRSQIT1: return "pfrsqit1";
    case ND_INS_PFRSQRT: return "pfrsqrt";
    case ND_INS_PFRSQRTV: return "pfrsqrtv";
    case ND_INS_PFSUB: return "pfsub";
    case ND_INS_PFSUBR: return "pfsubr";
    case ND_INS_PHADDD: return "phaddd";
    case ND_INS_PHADDSW: return "phaddsw";
    case ND_INS_PHADDW: return "phaddw";
    case ND_INS_PHMINPOSUW: return "phminposuw";
    case ND_INS_PHSUBD: return "phsubd";
    case ND_INS_PHSUBSW: return "phsubsw";
    case ND_INS_PHSUBW: return "phsubw";
    case ND_INS_PI2FD: return "pi2fd";
    case ND_INS_PI2FW: return "pi2fw";
    case ND_INS_PINSRB: return "pinsrb";
    case ND_INS_PINSRD: return "pinsrd";
    case ND_INS_PINSRQ: return "pinsrq";
    case ND_INS_PINSRW: return "pinsrw";
    case ND_INS_PMADDUBSW: return "pmaddubsw";
    case ND_INS_PMADDWD: return "pmaddwd";
    case ND_INS_PMAXSB: return "pmaxsb";
    case ND_INS_PMAXSD: return "pmaxsd";
    case ND_INS_PMAXSW: return "pmaxsw";
    case ND_INS_PMAXUB: return "pmaxub";
    case ND_INS_PMAXUD: return "pmaxud";
    case ND_INS_PMAXUW: return "pmaxuw";
    case ND_INS_PMINSB: return "pminsb";
    case ND_INS_PMINSD: return "pminsd";
    case ND_INS_PMINSW: return "pminsw";
    case ND_INS_PMINUB: return "pminub";
    case ND_INS_PMINUD: return "pminud";
    case ND_INS_PMINUW: return "pminuw";
    case ND_INS_PMOVMSKB: return "pmovmskb";
    case ND_INS_PMOVSXBD: return "pmovsxbd";
    case ND_INS_PMOVSXBQ: return "pmovsxbq";
    case ND_INS_PMOVSXBW: return "pmovsxbw";
    case ND_INS_PMOVSXDQ: return "pmovsxdq";
    case ND_INS_PMOVSXWD: return "pmovsxwd";
    case ND_INS_PMOVSXWQ: return "pmovsxwq";
    case ND_INS_PMOVZXBD: return "pmovzxbd";
    case ND_INS_PMOVZXBQ: return "pmovzxbq";
    case ND_INS_PMOVZXBW: return "pmovzxbw";
    case ND_INS_PMOVZXDQ: return "pmovzxdq";
    case ND_INS_PMOVZXWD: return "pmovzxwd";
    case ND_INS_PMOVZXWQ: return "pmovzxwq";
    case ND_INS_PMULDQ: return "pmuldq";
    case ND_INS_PMULHRSW: return "pmulhrsw";
    case ND_INS_PMULHRW: return "pmulhrw";
    case ND_INS_PMULHUW: return "pmulhuw";
    case ND_INS_PMULHW: return "pmulhw";
    case ND_INS_PMULLD: return "pmulld";
    case ND_INS_PMULLW: return "pmullw";
    case ND_INS_PMULUDQ: return "pmuludq";
    case ND_INS_POP: return "pop";
    case ND_INS_POPA: return "popa";
    case ND_INS_POPAD: return "popad";
    case ND_INS_POPCNT: return "popcnt";
    case ND_INS_POPF: return "popf";
    case ND_INS_POR: return "por";
    case ND_INS_PREFETCH: return "prefetch";
    case ND_INS_PREFETCHE: return "prefetche";
    case ND_INS_PREFETCHM: return "prefetchm";
    case ND_INS_PREFETCHNTA: return "prefetchnta";
    case ND_INS_PREFETCHT0: return "prefetcht0";
    case ND_INS_PREFETCHT1: return "prefetcht1";
    case ND_INS_PREFETCHT2: return "prefetcht2";
    case ND_INS_PREFETCHW: return "prefetchw";
    case ND_INS_PREFETCHWT1: return "prefetchwt1";
    case ND_INS_PSADBW: return "psadbw";
    case ND_INS_PSHUFB: return "pshufb";
    case ND_INS_PSHUFD: return "pshufd";
    case ND_INS_PSHUFHW: return "pshufhw";
    case ND_INS_PSHUFLW: return "pshuflw";
    case ND_INS_PSHUFW: return "pshufw";
    case ND_INS_PSIGNB: return "psignb";
    case ND_INS_PSIGND: return "psignd";
    case ND_INS_PSIGNW: return "psignw";
    case ND_INS_PSLLD: return "pslld";
    case ND_INS_PSLLDQ: return "pslldq";
    case ND_INS_PSLLQ: return "psllq";
    case ND_INS_PSLLW: return "psllw";
    case ND_INS_PSMASH: return "psmash";
    case ND_INS_PSRAD: return "psrad";
    case ND_INS_PSRAW: return "psraw";
    case ND_INS_PSRLD: return "psrld";
    case ND_INS_PSRLDQ: return "psrldq";
    case ND_INS_PSRLQ: return "psrlq";
    case ND_INS_PSRLW: return "psrlw";
    case ND_INS_PSUBB: return "psubb";
    case ND_INS_PSUBD: return "psubd";
    case ND_INS_PSUBQ: return "psubq";
    case ND_INS_PSUBSB: return "psubsb";
    case ND_INS_PSUBSW: return "psubsw";
    case ND_INS_PSUBUSB: return "psubusb";
    case ND_INS_PSUBUSW: return "psubusw";
    case ND_INS_PSUBW: return "psubw";
    case ND_INS_PSWAPD: return "pswapd";
    case ND_INS_PTEST: return "ptest";
    case ND_INS_PTWRITE: return "ptwrite";
    case ND_INS_PUNPCKHBW: return "punpckhbw";
    case ND_INS_PUNPCKHDQ: return "punpckhdq";
    case ND_INS_PUNPCKHQDQ: return "punpckhqdq";
    case ND_INS_PUNPCKHWD: return "punpckhwd";
    case ND_INS_PUNPCKLBW: return "punpcklbw";
    case ND_INS_PUNPCKLDQ: return "punpckldq";
    case ND_INS_PUNPCKLQDQ: return "punpcklqdq";
    case ND_INS_PUNPCKLWD: return "punpcklwd";
    case ND_INS_PUSH: return "push";
    case ND_INS_PUSHA: return "pusha";
    case ND_INS_PUSHAD: return "pushad";
    case ND_INS_PUSHF: return "pushf";
    case ND_INS_PVALIDATE: return "pvalidate";
    case ND_INS_PXOR: return "pxor";
    case ND_INS_RCL: return "rcl";
    case ND_INS_RCPPS: return "rcpps";
    case ND_INS_RCPSS: return "rcpss";
    case ND_INS_RCR: return "rcr";
    case ND_INS_RDFSBASE: return "rdfsbase";
    case ND_INS_RDGSBASE: return "rdgsbase";
    case ND_INS_RDMSR: return "rdmsr";
    case ND_INS_RDPID: return "rdpid";
    case ND_INS_RDPKRU: return "rdpkru";
    case ND_INS_RDPMC: return "rdpmc";
    case ND_INS_RDPRU: return "rdpru";
    case ND_INS_RDRAND: return "rdrand";
    case ND_INS_RDSEED: return "rdseed";
    case ND_INS_RDSHR: return "rdshr";
    case ND_INS_RDTSC: return "rdtsc";
    case ND_INS_RDTSCP: return "rdtscp";
    case ND_INS_RETF: return "retf";
    case ND_INS_RETN: return "retn";
    case ND_INS_RMPADJUST: return "rmpadjust";
    case ND_INS_RMPUPDATE: return "rmpupdate";
    case ND_INS_ROL: return "rol";
    case ND_INS_ROR: return "ror";
    case ND_INS_RORX: return "rorx";
    case ND_INS_ROUNDPD: return "roundpd";
    case ND_INS_ROUNDPS: return "roundps";
    case ND_INS_ROUNDSD: return "roundsd";
    case ND_INS_ROUNDSS: return "roundss";
    case ND_INS_RSDC: return "rsdc";
    case ND_INS_RSLDT: return "rsldt";
    case ND_INS_RSM: return "rsm";
    case ND_INS_RSQRTPS: return "rsqrtps";
    case ND_INS_RSQRTSS: return "rsqrtss";
    case ND_INS_RSSSP: return "rsssp";
    case ND_INS_RSTORSSP: return "rstorssp";
    case ND_INS_RSTS: return "rsts";
    case ND_INS_SAHF: return "sahf";
    case ND_INS_SAL: return "sal";
    case ND_INS_SALC: return "salc";
    case ND_INS_SAR: return "sar";
    case ND_INS_SARX: return "sarx";
    case ND_INS_SAVEPREVSSP: return "saveprevssp";
    case ND_INS_SBB: return "sbb";
    case ND_INS_SCAS: return "scas";
    case ND_INS_SEAMOPS: return "seamops";
    case ND_INS_SEAMCALL: return "seamcall";
    case ND_INS_SEAMRET: return "seamret";
    case ND_INS_SERIALIZE: return "serialize";
    case ND_INS_SETSSBSY: return "setssbsy";
    case ND_INS_SETcc: return "setcc";
    case ND_INS_SFENCE: return "sfence";
    case ND_INS_SGDT: return "sgdt";
    case ND_INS_SHA1MSG1: return "sha1msg1";
    case ND_INS_SHA1MSG2: return "sha1msg2";
    case ND_INS_SHA1NEXTE: return "sha1nexte";
    case ND_INS_SHA1RNDS4: return "sha1rnds4";
    case ND_INS_SHA256MSG1: return "sha256msg1";
    case ND_INS_SHA256MSG2: return "sha256msg2";
    case ND_INS_SHA256RNDS2: return "sha256rnds2";
    case ND_INS_SHL: return "shl";
    case ND_INS_SHLD: return "shld";
    case ND_INS_SHLX: return "shlx";
    case ND_INS_SHR: return "shr";
    case ND_INS_SHRD: return "shrd";
    case ND_INS_SHRX: return "shrx";
    case ND_INS_SHUFPD: return "shufpd";
    case ND_INS_SHUFPS: return "shufps";
    case ND_INS_SIDT: return "sidt";
    case ND_INS_SKINIT: return "skinit";
    case ND_INS_SLDT: return "sldt";
    case ND_INS_SLWPCB: return "slwpcb";
    case ND_INS_SMINT: return "smint";
    case ND_INS_SMSW: return "smsw";
    case ND_INS_SPFLT: return "spflt";
    case ND_INS_SQRTPD: return "sqrtpd";
    case ND_INS_SQRTPS: return "sqrtps";
    case ND_INS_SQRTSD: return "sqrtsd";
    case ND_INS_SQRTSS: return "sqrtss";
    case ND_INS_STAC: return "stac";
    case ND_INS_STC: return "stc";
    case ND_INS_STD: return "std";
    case ND_INS_STGI: return "stgi";
    case ND_INS_STI: return "sti";
    case ND_INS_STMXCSR: return "stmxcsr";
    case ND_INS_STOS: return "stos";
    case ND_INS_STR: return "str";
    case ND_INS_STTILECFG: return "sttilecfg";
    case ND_INS_SUB: return "sub";
    case ND_INS_SUBPD: return "subpd";
    case ND_INS_SUBPS: return "subps";
    case ND_INS_SUBSD: return "subsd";
    case ND_INS_SUBSS: return "subss";
    case ND_INS_SVDC: return "svdc";
    case ND_INS_SVLDT: return "svldt";
    case ND_INS_SVTS: return "svts";
    case ND_INS_SWAPGS: return "swapgs";
    case ND_INS_SYSCALL: return "syscall";
    case ND_INS_SYSENTER: return "sysenter";
    case ND_INS_SYSEXIT: return "sysexit";
    case ND_INS_SYSRET: return "sysret";
    case ND_INS_T1MSKC: return "t1mskc";
    case ND_INS_TDCALL: return "tdcall";
    case ND_INS_TDPBF16PS: return "tdpbf16ps";
    case ND_INS_TDPBSSD: return "tdpbssd";
    case ND_INS_TDPBSUD: return "tdpbsud";
    case ND_INS_TDPBUSD: return "tdpbusd";
    case ND_INS_TDPBUUD: return "tdpbuud";
    case ND_INS_TEST: return "test";
    case ND_INS_TILELOADD: return "tileloadd";
    case ND_INS_TILELOADDT1: return "tileloaddt1";
    case ND_INS_TILERELEASE: return "tilerelease";
    case ND_INS_TILESTORED: return "tilestored";
    case ND_INS_TILEZERO: return "tilezero";
    case ND_INS_TLBSYNC: return "tlbsync";
    case ND_INS_TPAUSE: return "tpause";
    case ND_INS_TZCNT: return "tzcnt";
    case ND_INS_TZMSK: return "tzmsk";
    case ND_INS_UCOMISD: return "ucomisd";
    case ND_INS_UCOMISS: return "ucomiss";
    case ND_INS_UD0: return "ud0";
    case ND_INS_UD1: return "ud1";
    case ND_INS_UD2: return "ud2";
    case ND_INS_UMONITOR: return "umonitor";
    case ND_INS_UMWAIT: return "umwait";
    case ND_INS_UNPCKHPD: return "unpckhpd";
    case ND_INS_UNPCKHPS: return "unpckhps";
    case ND_INS_UNPCKLPD: return "unpcklpd";
    case ND_INS_UNPCKLPS: return "unpcklps";
    case ND_INS_V4FMADDPS: return "v4fmaddps";
    case ND_INS_V4FMADDSS: return "v4fmaddss";
    case ND_INS_V4FNMADDPS: return "v4fnmaddps";
    case ND_INS_V4FNMADDSS: return "v4fnmaddss";
    case ND_INS_VADDPD: return "vaddpd";
    case ND_INS_VADDPS: return "vaddps";
    case ND_INS_VADDSD: return "vaddsd";
    case ND_INS_VADDSS: return "vaddss";
    case ND_INS_VADDSUBPD: return "vaddsubpd";
    case ND_INS_VADDSUBPS: return "vaddsubps";
    case ND_INS_VAESDEC: return "vaesdec";
    case ND_INS_VAESDECLAST: return "vaesdeclast";
    case ND_INS_VAESENC: return "vaesenc";
    case ND_INS_VAESENCLAST: return "vaesenclast";
    case ND_INS_VAESIMC: return "vaesimc";
    case ND_INS_VAESKEYGENASSIST: return "vaeskeygenassist";
    case ND_INS_VALIGND: return "valignd";
    case ND_INS_VALIGNQ: return "valignq";
    case ND_INS_VANDNPD: return "vandnpd";
    case ND_INS_VANDNPS: return "vandnps";
    case ND_INS_VANDPD: return "vandpd";
    case ND_INS_VANDPS: return "vandps";
    case ND_INS_VBLENDMPD: return "vblendmpd";
    case ND_INS_VBLENDMPS: return "vblendmps";
    case ND_INS_VBLENDPD: return "vblendpd";
    case ND_INS_VBLENDPS: return "vblendps";
    case ND_INS_VBLENDVPD: return "vblendvpd";
    case ND_INS_VBLENDVPS: return "vblendvps";
    case ND_INS_VBROADCASTF128: return "vbroadcastf128";
    case ND_INS_VBROADCASTF32X2: return "vbroadcastf32x2";
    case ND_INS_VBROADCASTF32X4: return "vbroadcastf32x4";
    case ND_INS_VBROADCASTF32X8: return "vbroadcastf32x8";
    case ND_INS_VBROADCASTF64X2: return "vbroadcastf64x2";
    case ND_INS_VBROADCASTF64X4: return "vbroadcastf64x4";
    case ND_INS_VBROADCASTI128: return "vbroadcasti128";
    case ND_INS_VBROADCASTI32X2: return "vbroadcasti32x2";
    case ND_INS_VBROADCASTI32X4: return "vbroadcasti32x4";
    case ND_INS_VBROADCASTI32X8: return "vbroadcasti32x8";
    case ND_INS_VBROADCASTI64X2: return "vbroadcasti64x2";
    case ND_INS_VBROADCASTI64X4: return "vbroadcasti64x4";
    case ND_INS_VBROADCASTSD: return "vbroadcastsd";
    case ND_INS_VBROADCASTSS: return "vbroadcastss";
    case ND_INS_VCMPPD: return "vcmppd";
    case ND_INS_VCMPPS: return "vcmpps";
    case ND_INS_VCMPSD: return "vcmpsd";
    case ND_INS_VCMPSS: return "vcmpss";
    case ND_INS_VCOMISD: return "vcomisd";
    case ND_INS_VCOMISS: return "vcomiss";
    case ND_INS_VCOMPRESSPD: return "vcompresspd";
    case ND_INS_VCOMPRESSPS: return "vcompressps";
    case ND_INS_VCVTDQ2PD: return "vcvtdq2pd";
    case ND_INS_VCVTDQ2PS: return "vcvtdq2ps";
    case ND_INS_VCVTNE2PS2BF16: return "vcvtne2ps2bf16";
    case ND_INS_VCVTNEPS2BF16: return "vcvtneps2bf16";
    case ND_INS_VCVTPD2DQ: return "vcvtpd2dq";
    case ND_INS_VCVTPD2PS: return "vcvtpd2ps";
    case ND_INS_VCVTPD2QQ: return "vcvtpd2qq";
    case ND_INS_VCVTPD2UDQ: return "vcvtpd2udq";
    case ND_INS_VCVTPD2UQQ: return "vcvtpd2uqq";
    case ND_INS_VCVTPH2PS: return "vcvtph2ps";
    case ND_INS_VCVTPS2DQ: return "vcvtps2dq";
    case ND_INS_VCVTPS2PD: return "vcvtps2pd";
    case ND_INS_VCVTPS2PH: return "vcvtps2ph";
    case ND_INS_VCVTPS2QQ: return "vcvtps2qq";
    case ND_INS_VCVTPS2UDQ: return "vcvtps2udq";
    case ND_INS_VCVTPS2UQQ: return "vcvtps2uqq";
    case ND_INS_VCVTQQ2PD: return "vcvtqq2pd";
    case ND_INS_VCVTQQ2PS: return "vcvtqq2ps";
    case ND_INS_VCVTSD2SI: return "vcvtsd2si";
    case ND_INS_VCVTSD2SS: return "vcvtsd2ss";
    case ND_INS_VCVTSD2USI: return "vcvtsd2usi";
    case ND_INS_VCVTSI2SD: return "vcvtsi2sd";
    case ND_INS_VCVTSI2SS: return "vcvtsi2ss";
    case ND_INS_VCVTSS2SD: return "vcvtss2sd";
    case ND_INS_VCVTSS2SI: return "vcvtss2si";
    case ND_INS_VCVTSS2USI: return "vcvtss2usi";
    case ND_INS_VCVTTPD2DQ: return "vcvttpd2dq";
    case ND_INS_VCVTTPD2QQ: return "vcvttpd2qq";
    case ND_INS_VCVTTPD2UDQ: return "vcvttpd2udq";
    case ND_INS_VCVTTPD2UQQ: return "vcvttpd2uqq";
    case ND_INS_VCVTTPS2DQ: return "vcvttps2dq";
    case ND_INS_VCVTTPS2QQ: return "vcvttps2qq";
    case ND_INS_VCVTTPS2UDQ: return "vcvttps2udq";
    case ND_INS_VCVTTPS2UQQ: return "vcvttps2uqq";
    case ND_INS_VCVTTSD2SI: return "vcvttsd2si";
    case ND_INS_VCVTTSD2USI: return "vcvttsd2usi";
    case ND_INS_VCVTTSS2SI: return "vcvttss2si";
    case ND_INS_VCVTTSS2USI: return "vcvttss2usi";
    case ND_INS_VCVTUDQ2PD: return "vcvtudq2pd";
    case ND_INS_VCVTUDQ2PS: return "vcvtudq2ps";
    case ND_INS_VCVTUQQ2PD: return "vcvtuqq2pd";
    case ND_INS_VCVTUQQ2PS: return "vcvtuqq2ps";
    case ND_INS_VCVTUSI2SD: return "vcvtusi2sd";
    case ND_INS_VCVTUSI2SS: return "vcvtusi2ss";
    case ND_INS_VDBPSADBW: return "vdbpsadbw";
    case ND_INS_VDIVPD: return "vdivpd";
    case ND_INS_VDIVPS: return "vdivps";
    case ND_INS_VDIVSD: return "vdivsd";
    case ND_INS_VDIVSS: return "vdivss";
    case ND_INS_VDPBF16PS: return "vdpbf16ps";
    case ND_INS_VDPPD: return "vdppd";
    case ND_INS_VDPPS: return "vdpps";
    case ND_INS_VERR: return "verr";
    case ND_INS_VERW: return "verw";
    case ND_INS_VEXP2PD: return "vexp2pd";
    case ND_INS_VEXP2PS: return "vexp2ps";
    case ND_INS_VEXPANDPD: return "vexpandpd";
    case ND_INS_VEXPANDPS: return "vexpandps";
    case ND_INS_VEXTRACTF128: return "vextractf128";
    case ND_INS_VEXTRACTF32X4: return "vextractf32x4";
    case ND_INS_VEXTRACTF32X8: return "vextractf32x8";
    case ND_INS_VEXTRACTF64X2: return "vextractf64x2";
    case ND_INS_VEXTRACTF64X4: return "vextractf64x4";
    case ND_INS_VEXTRACTI128: return "vextracti128";
    case ND_INS_VEXTRACTI32X4: return "vextracti32x4";
    case ND_INS_VEXTRACTI32X8: return "vextracti32x8";
    case ND_INS_VEXTRACTI64X2: return "vextracti64x2";
    case ND_INS_VEXTRACTI64X4: return "vextracti64x4";
    case ND_INS_VEXTRACTPS: return "vextractps";
    case ND_INS_VFIXUPIMMPD: return "vfixupimmpd";
    case ND_INS_VFIXUPIMMPS: return "vfixupimmps";
    case ND_INS_VFIXUPIMMSD: return "vfixupimmsd";
    case ND_INS_VFIXUPIMMSS: return "vfixupimmss";
    case ND_INS_VFMADD132PD: return "vfmadd132pd";
    case ND_INS_VFMADD132PS: return "vfmadd132ps";
    case ND_INS_VFMADD132SD: return "vfmadd132sd";
    case ND_INS_VFMADD132SS: return "vfmadd132ss";
    case ND_INS_VFMADD213PD: return "vfmadd213pd";
    case ND_INS_VFMADD213PS: return "vfmadd213ps";
    case ND_INS_VFMADD213SD: return "vfmadd213sd";
    case ND_INS_VFMADD213SS: return "vfmadd213ss";
    case ND_INS_VFMADD231PD: return "vfmadd231pd";
    case ND_INS_VFMADD231PS: return "vfmadd231ps";
    case ND_INS_VFMADD231SD: return "vfmadd231sd";
    case ND_INS_VFMADD231SS: return "vfmadd231ss";
    case ND_INS_VFMADDPD: return "vfmaddpd";
    case ND_INS_VFMADDPS: return "vfmaddps";
    case ND_INS_VFMADDSD: return "vfmaddsd";
    case ND_INS_VFMADDSS: return "vfmaddss";
    case ND_INS_VFMADDSUB132PD: return "vfmaddsub132pd";
    case ND_INS_VFMADDSUB132PS: return "vfmaddsub132ps";
    case ND_INS_VFMADDSUB213PD: return "vfmaddsub213pd";
    case ND_INS_VFMADDSUB213PS: return "vfmaddsub213ps";
    case ND_INS_VFMADDSUB231PD: return "vfmaddsub231pd";
    case ND_INS_VFMADDSUB231PS: return "vfmaddsub231ps";
    case ND_INS_VFMADDSUBPD: return "vfmaddsubpd";
    case ND_INS_VFMADDSUBPS: return "vfmaddsubps";
    case ND_INS_VFMSUB132PD: return "vfmsub132pd";
    case ND_INS_VFMSUB132PS: return "vfmsub132ps";
    case ND_INS_VFMSUB132SD: return "vfmsub132sd";
    case ND_INS_VFMSUB132SS: return "vfmsub132ss";
    case ND_INS_VFMSUB213PD: return "vfmsub213pd";
    case ND_INS_VFMSUB213PS: return "vfmsub213ps";
    case ND_INS_VFMSUB213SD: return "vfmsub213sd";
    case ND_INS_VFMSUB213SS: return "vfmsub213ss";
    case ND_INS_VFMSUB231PD: return "vfmsub231pd";
    case ND_INS_VFMSUB231PS: return "vfmsub231ps";
    case ND_INS_VFMSUB231SD: return "vfmsub231sd";
    case ND_INS_VFMSUB231SS: return "vfmsub231ss";
    case ND_INS_VFMSUBADD132PD: return "vfmsubadd132pd";
    case ND_INS_VFMSUBADD132PS: return "vfmsubadd132ps";
    case ND_INS_VFMSUBADD213PD: return "vfmsubadd213pd";
    case ND_INS_VFMSUBADD213PS: return "vfmsubadd213ps";
    case ND_INS_VFMSUBADD231PD: return "vfmsubadd231pd";
    case ND_INS_VFMSUBADD231PS: return "vfmsubadd231ps";
    case ND_INS_VFMSUBADDPD: return "vfmsubaddpd";
    case ND_INS_VFMSUBADDPS: return "vfmsubaddps";
    case ND_INS_VFMSUBPD: return "vfmsubpd";
    case ND_INS_VFMSUBPS: return "vfmsubps";
    case ND_INS_VFMSUBSD: return "vfmsubsd";
    case ND_INS_VFMSUBSS: return "vfmsubss";
    case ND_INS_VFNMADD132PD: return "vfnmadd132pd";
    case ND_INS_VFNMADD132PS: return "vfnmadd132ps";
    case ND_INS_VFNMADD132SD: return "vfnmadd132sd";
    case ND_INS_VFNMADD132SS: return "vfnmadd132ss";
    case ND_INS_VFNMADD213PD: return "vfnmadd213pd";
    case ND_INS_VFNMADD213PS: return "vfnmadd213ps";
    case ND_INS_VFNMADD213SD: return "vfnmadd213sd";
    case ND_INS_VFNMADD213SS: return "vfnmadd213ss";
    case ND_INS_VFNMADD231PD: return "vfnmadd231pd";
    case ND_INS_VFNMADD231PS: return "vfnmadd231ps";
    case ND_INS_VFNMADD231SD: return "vfnmadd231sd";
    case ND_INS_VFNMADD231SS: return "vfnmadd231ss";
    case ND_INS_VFNMADDPD: return "vfnmaddpd";
    case ND_INS_VFNMADDPS: return "vfnmaddps";
    case ND_INS_VFNMADDSD: return "vfnmaddsd";
    case ND_INS_VFNMADDSS: return "vfnmaddss";
    case ND_INS_VFNMSUB132PD: return "vfnmsub132pd";
    case ND_INS_VFNMSUB132PS: return "vfnmsub132ps";
    case ND_INS_VFNMSUB132SD: return "vfnmsub132sd";
    case ND_INS_VFNMSUB132SS: return "vfnmsub132ss";
    case ND_INS_VFNMSUB213PD: return "vfnmsub213pd";
    case ND_INS_VFNMSUB213PS: return "vfnmsub213ps";
    case ND_INS_VFNMSUB213SD: return "vfnmsub213sd";
    case ND_INS_VFNMSUB213SS: return "vfnmsub213ss";
    case ND_INS_VFNMSUB231PD: return "vfnmsub231pd";
    case ND_INS_VFNMSUB231PS: return "vfnmsub231ps";
    case ND_INS_VFNMSUB231SD: return "vfnmsub231sd";
    case ND_INS_VFNMSUB231SS: return "vfnmsub231ss";
    case ND_INS_VFNMSUBPD: return "vfnmsubpd";
    case ND_INS_VFNMSUBPS: return "vfnmsubps";
    case ND_INS_VFNMSUBSD: return "vfnmsubsd";
    case ND_INS_VFNMSUBSS: return "vfnmsubss";
    case ND_INS_VFPCLASSPD: return "vfpclasspd";
    case ND_INS_VFPCLASSPS: return "vfpclassps";
    case ND_INS_VFPCLASSSD: return "vfpclasssd";
    case ND_INS_VFPCLASSSS: return "vfpclassss";
    case ND_INS_VFRCZPD: return "vfrczpd";
    case ND_INS_VFRCZPS: return "vfrczps";
    case ND_INS_VFRCZSD: return "vfrczsd";
    case ND_INS_VFRCZSS: return "vfrczss";
    case ND_INS_VGATHERDPD: return "vgatherdpd";
    case ND_INS_VGATHERDPS: return "vgatherdps";
    case ND_INS_VGATHERPF0DPD: return "vgatherpf0dpd";
    case ND_INS_VGATHERPF0DPS: return "vgatherpf0dps";
    case ND_INS_VGATHERPF0QPD: return "vgatherpf0qpd";
    case ND_INS_VGATHERPF0QPS: return "vgatherpf0qps";
    case ND_INS_VGATHERPF1DPD: return "vgatherpf1dpd";
    case ND_INS_VGATHERPF1DPS: return "vgatherpf1dps";
    case ND_INS_VGATHERPF1QPD: return "vgatherpf1qpd";
    case ND_INS_VGATHERPF1QPS: return "vgatherpf1qps";
    case ND_INS_VGATHERQPD: return "vgatherqpd";
    case ND_INS_VGATHERQPS: return "vgatherqps";
    case ND_INS_VGETEXPPD: return "vgetexppd";
    case ND_INS_VGETEXPPS: return "vgetexpps";
    case ND_INS_VGETEXPSD: return "vgetexpsd";
    case ND_INS_VGETEXPSS: return "vgetexpss";
    case ND_INS_VGETMANTPD: return "vgetmantpd";
    case ND_INS_VGETMANTPS: return "vgetmantps";
    case ND_INS_VGETMANTSD: return "vgetmantsd";
    case ND_INS_VGETMANTSS: return "vgetmantss";
    case ND_INS_VGF2P8AFFINEINVQB: return "vgf2p8affineinvqb";
    case ND_INS_VGF2P8AFFINEQB: return "vgf2p8affineqb";
    case ND_INS_VGF2P8MULB: return "vgf2p8mulb";
    case ND_INS_VHADDPD: return "vhaddpd";
    case ND_INS_VHADDPS: return "vhaddps";
    case ND_INS_VHSUBPD: return "vhsubpd";
    case ND_INS_VHSUBPS: return "vhsubps";
    case ND_INS_VINSERTF128: return "vinsertf128";
    case ND_INS_VINSERTF32X4: return "vinsertf32x4";
    case ND_INS_VINSERTF32X8: return "vinsertf32x8";
    case ND_INS_VINSERTF64X2: return "vinsertf64x2";
    case ND_INS_VINSERTF64X4: return "vinsertf64x4";
    case ND_INS_VINSERTI128: return "vinserti128";
    case ND_INS_VINSERTI32X4: return "vinserti32x4";
    case ND_INS_VINSERTI32X8: return "vinserti32x8";
    case ND_INS_VINSERTI64X2: return "vinserti64x2";
    case ND_INS_VINSERTI64X4: return "vinserti64x4";
    case ND_INS_VINSERTPS: return "vinsertps";
    case ND_INS_VLDDQU: return "vlddqu";
    case ND_INS_VLDMXCSR: return "vldmxcsr";
    case ND_INS_VMASKMOVDQU: return "vmaskmovdqu";
    case ND_INS_VMASKMOVPD: return "vmaskmovpd";
    case ND_INS_VMASKMOVPS: return "vmaskmovps";
    case ND_INS_VMAXPD: return "vmaxpd";
    case ND_INS_VMAXPS: return "vmaxps";
    case ND_INS_VMAXSD: return "vmaxsd";
    case ND_INS_VMAXSS: return "vmaxss";
    case ND_INS_VMCALL: return "vmcall";
    case ND_INS_VMCLEAR: return "vmclear";
    case ND_INS_VMFUNC: return "vmfunc";
    case ND_INS_VMGEXIT: return "vmgexit";
    case ND_INS_VMINPD: return "vminpd";
    case ND_INS_VMINPS: return "vminps";
    case ND_INS_VMINSD: return "vminsd";
    case ND_INS_VMINSS: return "vminss";
    case ND_INS_VMLAUNCH: return "vmlaunch";
    case ND_INS_VMLOAD: return "vmload";
    case ND_INS_VMMCALL: return "vmmcall";
    case ND_INS_VMOVAPD: return "vmovapd";
    case ND_INS_VMOVAPS: return "vmovaps";
    case ND_INS_VMOVD: return "vmovd";
    case ND_INS_VMOVDDUP: return "vmovddup";
    case ND_INS_VMOVDQA: return "vmovdqa";
    case ND_INS_VMOVDQA32: return "vmovdqa32";
    case ND_INS_VMOVDQA64: return "vmovdqa64";
    case ND_INS_VMOVDQU: return "vmovdqu";
    case ND_INS_VMOVDQU16: return "vmovdqu16";
    case ND_INS_VMOVDQU32: return "vmovdqu32";
    case ND_INS_VMOVDQU64: return "vmovdqu64";
    case ND_INS_VMOVDQU8: return "vmovdqu8";
    case ND_INS_VMOVHLPS: return "vmovhlps";
    case ND_INS_VMOVHPD: return "vmovhpd";
    case ND_INS_VMOVHPS: return "vmovhps";
    case ND_INS_VMOVLHPS: return "vmovlhps";
    case ND_INS_VMOVLPD: return "vmovlpd";
    case ND_INS_VMOVLPS: return "vmovlps";
    case ND_INS_VMOVMSKPD: return "vmovmskpd";
    case ND_INS_VMOVMSKPS: return "vmovmskps";
    case ND_INS_VMOVNTDQ: return "vmovntdq";
    case ND_INS_VMOVNTDQA: return "vmovntdqa";
    case ND_INS_VMOVNTPD: return "vmovntpd";
    case ND_INS_VMOVNTPS: return "vmovntps";
    case ND_INS_VMOVQ: return "vmovq";
    case ND_INS_VMOVSD: return "vmovsd";
    case ND_INS_VMOVSHDUP: return "vmovshdup";
    case ND_INS_VMOVSLDUP: return "vmovsldup";
    case ND_INS_VMOVSS: return "vmovss";
    case ND_INS_VMOVUPD: return "vmovupd";
    case ND_INS_VMOVUPS: return "vmovups";
    case ND_INS_VMPSADBW: return "vmpsadbw";
    case ND_INS_VMPTRLD: return "vmptrld";
    case ND_INS_VMPTRST: return "vmptrst";
    case ND_INS_VMREAD: return "vmread";
    case ND_INS_VMRESUME: return "vmresume";
    case ND_INS_VMRUN: return "vmrun";
    case ND_INS_VMSAVE: return "vmsave";
    case ND_INS_VMULPD: return "vmulpd";
    case ND_INS_VMULPS: return "vmulps";
    case ND_INS_VMULSD: return "vmulsd";
    case ND_INS_VMULSS: return "vmulss";
    case ND_INS_VMWRITE: return "vmwrite";
    case ND_INS_VMXOFF: return "vmxoff";
    case ND_INS_VMXON: return "vmxon";
    case ND_INS_VORPD: return "vorpd";
    case ND_INS_VORPS: return "vorps";
    case ND_INS_VP2INTERSECTD: return "vp2intersectd";
    case ND_INS_VP2INTERSECTQ: return "vp2intersectq";
    case ND_INS_VP4DPWSSD: return "vp4dpwssd";
    case ND_INS_VP4DPWSSDS: return "vp4dpwssds";
    case ND_INS_VPABSB: return "vpabsb";
    case ND_INS_VPABSD: return "vpabsd";
    case ND_INS_VPABSQ: return "vpabsq";
    case ND_INS_VPABSW: return "vpabsw";
    case ND_INS_VPACKSSDW: return "vpackssdw";
    case ND_INS_VPACKSSWB: return "vpacksswb";
    case ND_INS_VPACKUSDW: return "vpackusdw";
    case ND_INS_VPACKUSWB: return "vpackuswb";
    case ND_INS_VPADDB: return "vpaddb";
    case ND_INS_VPADDD: return "vpaddd";
    case ND_INS_VPADDQ: return "vpaddq";
    case ND_INS_VPADDSB: return "vpaddsb";
    case ND_INS_VPADDSW: return "vpaddsw";
    case ND_INS_VPADDUSB: return "vpaddusb";
    case ND_INS_VPADDUSW: return "vpaddusw";
    case ND_INS_VPADDW: return "vpaddw";
    case ND_INS_VPALIGNR: return "vpalignr";
    case ND_INS_VPAND: return "vpand";
    case ND_INS_VPANDD: return "vpandd";
    case ND_INS_VPANDN: return "vpandn";
    case ND_INS_VPANDND: return "vpandnd";
    case ND_INS_VPANDNQ: return "vpandnq";
    case ND_INS_VPANDQ: return "vpandq";
    case ND_INS_VPAVGB: return "vpavgb";
    case ND_INS_VPAVGW: return "vpavgw";
    case ND_INS_VPBLENDD: return "vpblendd";
    case ND_INS_VPBLENDMB: return "vpblendmb";
    case ND_INS_VPBLENDMD: return "vpblendmd";
    case ND_INS_VPBLENDMQ: return "vpblendmq";
    case ND_INS_VPBLENDMW: return "vpblendmw";
    case ND_INS_VPBLENDVB: return "vpblendvb";
    case ND_INS_VPBLENDW: return "vpblendw";
    case ND_INS_VPBROADCASTB: return "vpbroadcastb";
    case ND_INS_VPBROADCASTD: return "vpbroadcastd";
    case ND_INS_VPBROADCASTMB2Q: return "vpbroadcastmb2q";
    case ND_INS_VPBROADCASTMW2D: return "vpbroadcastmw2d";
    case ND_INS_VPBROADCASTQ: return "vpbroadcastq";
    case ND_INS_VPBROADCASTW: return "vpbroadcastw";
    case ND_INS_VPCLMULQDQ: return "vpclmulqdq";
    case ND_INS_VPCMOV: return "vpcmov";
    case ND_INS_VPCMPB: return "vpcmpb";
    case ND_INS_VPCMPD: return "vpcmpd";
    case ND_INS_VPCMPEQB: return "vpcmpeqb";
    case ND_INS_VPCMPEQD: return "vpcmpeqd";
    case ND_INS_VPCMPEQQ: return "vpcmpeqq";
    case ND_INS_VPCMPEQW: return "vpcmpeqw";
    case ND_INS_VPCMPESTRI: return "vpcmpestri";
    case ND_INS_VPCMPESTRM: return "vpcmpestrm";
    case ND_INS_VPCMPGTB: return "vpcmpgtb";
    case ND_INS_VPCMPGTD: return "vpcmpgtd";
    case ND_INS_VPCMPGTQ: return "vpcmpgtq";
    case ND_INS_VPCMPGTW: return "vpcmpgtw";
    case ND_INS_VPCMPISTRI: return "vpcmpistri";
    case ND_INS_VPCMPISTRM: return "vpcmpistrm";
    case ND_INS_VPCMPQ: return "vpcmpq";
    case ND_INS_VPCMPUB: return "vpcmpub";
    case ND_INS_VPCMPUD: return "vpcmpud";
    case ND_INS_VPCMPUQ: return "vpcmpuq";
    case ND_INS_VPCMPUW: return "vpcmpuw";
    case ND_INS_VPCMPW: return "vpcmpw";
    case ND_INS_VPCOMB: return "vpcomb";
    case ND_INS_VPCOMD: return "vpcomd";
    case ND_INS_VPCOMPRESSB: return "vpcompressb";
    case ND_INS_VPCOMPRESSD: return "vpcompressd";
    case ND_INS_VPCOMPRESSQ: return "vpcompressq";
    case ND_INS_VPCOMPRESSW: return "vpcompressw";
    case ND_INS_VPCOMQ: return "vpcomq";
    case ND_INS_VPCOMUB: return "vpcomub";
    case ND_INS_VPCOMUD: return "vpcomud";
    case ND_INS_VPCOMUQ: return "vpcomuq";
    case ND_INS_VPCOMUW: return "vpcomuw";
    case ND_INS_VPCOMW: return "vpcomw";
    case ND_INS_VPCONFLICTD: return "vpconflictd";
    case ND_INS_VPCONFLICTQ: return "vpconflictq";
    case ND_INS_VPDPBUSD: return "vpdpbusd";
    case ND_INS_VPDPBUSDS: return "vpdpbusds";
    case ND_INS_VPDPWSSD: return "vpdpwssd";
    case ND_INS_VPDPWSSDS: return "vpdpwssds";
    case ND_INS_VPERM2F128: return "vperm2f128";
    case ND_INS_VPERM2I128: return "vperm2i128";
    case ND_INS_VPERMB: return "vpermb";
    case ND_INS_VPERMD: return "vpermd";
    case ND_INS_VPERMI2B: return "vpermi2b";
    case ND_INS_VPERMI2D: return "vpermi2d";
    case ND_INS_VPERMI2PD: return "vpermi2pd";
    case ND_INS_VPERMI2PS: return "vpermi2ps";
    case ND_INS_VPERMI2Q: return "vpermi2q";
    case ND_INS_VPERMI2W: return "vpermi2w";
    case ND_INS_VPERMIL2PD: return "vpermil2pd";
    case ND_INS_VPERMIL2PS: return "vpermil2ps";
    case ND_INS_VPERMILPD: return "vpermilpd";
    case ND_INS_VPERMILPS: return "vpermilps";
    case ND_INS_VPERMPD: return "vpermpd";
    case ND_INS_VPERMPS: return "vpermps";
    case ND_INS_VPERMQ: return "vpermq";
    case ND_INS_VPERMT2B: return "vpermt2b";
    case ND_INS_VPERMT2D: return "vpermt2d";
    case ND_INS_VPERMT2PD: return "vpermt2pd";
    case ND_INS_VPERMT2PS: return "vpermt2ps";
    case ND_INS_VPERMT2Q: return "vpermt2q";
    case ND_INS_VPERMT2W: return "vpermt2w";
    case ND_INS_VPERMW: return "vpermw";
    case ND_INS_VPEXPANDB: return "vpexpandb";
    case ND_INS_VPEXPANDD: return "vpexpandd";
    case ND_INS_VPEXPANDQ: return "vpexpandq";
    case ND_INS_VPEXPANDW: return "vpexpandw";
    case ND_INS_VPEXTRB: return "vpextrb";
    case ND_INS_VPEXTRD: return "vpextrd";
    case ND_INS_VPEXTRQ: return "vpextrq";
    case ND_INS_VPEXTRW: return "vpextrw";
    case ND_INS_VPGATHERDD: return "vpgatherdd";
    case ND_INS_VPGATHERDQ: return "vpgatherdq";
    case ND_INS_VPGATHERQD: return "vpgatherqd";
    case ND_INS_VPGATHERQQ: return "vpgatherqq";
    case ND_INS_VPHADDBD: return "vphaddbd";
    case ND_INS_VPHADDBQ: return "vphaddbq";
    case ND_INS_VPHADDBW: return "vphaddbw";
    case ND_INS_VPHADDD: return "vphaddd";
    case ND_INS_VPHADDDQ: return "vphadddq";
    case ND_INS_VPHADDSW: return "vphaddsw";
    case ND_INS_VPHADDUBD: return "vphaddubd";
    case ND_INS_VPHADDUBQ: return "vphaddubq";
    case ND_INS_VPHADDUBW: return "vphaddubw";
    case ND_INS_VPHADDUDQ: return "vphaddudq";
    case ND_INS_VPHADDUWD: return "vphadduwd";
    case ND_INS_VPHADDUWQ: return "vphadduwq";
    case ND_INS_VPHADDW: return "vphaddw";
    case ND_INS_VPHADDWD: return "vphaddwd";
    case ND_INS_VPHADDWQ: return "vphaddwq";
    case ND_INS_VPHMINPOSUW: return "vphminposuw";
    case ND_INS_VPHSUBBW: return "vphsubbw";
    case ND_INS_VPHSUBD: return "vphsubd";
    case ND_INS_VPHSUBDQ: return "vphsubdq";
    case ND_INS_VPHSUBSW: return "vphsubsw";
    case ND_INS_VPHSUBW: return "vphsubw";
    case ND_INS_VPHSUBWD: return "vphsubwd";
    case ND_INS_VPINSRB: return "vpinsrb";
    case ND_INS_VPINSRD: return "vpinsrd";
    case ND_INS_VPINSRQ: return "vpinsrq";
    case ND_INS_VPINSRW: return "vpinsrw";
    case ND_INS_VPLZCNTD: return "vplzcntd";
    case ND_INS_VPLZCNTQ: return "vplzcntq";
    case ND_INS_VPMACSDD: return "vpmacsdd";
    case ND_INS_VPMACSDQH: return "vpmacsdqh";
    case ND_INS_VPMACSDQL: return "vpmacsdql";
    case ND_INS_VPMACSSDD: return "vpmacssdd";
    case ND_INS_VPMACSSDQH: return "vpmacssdqh";
    case ND_INS_VPMACSSDQL: return "vpmacssdql";
    case ND_INS_VPMACSSWD: return "vpmacsswd";
    case ND_INS_VPMACSSWW: return "vpmacssww";
    case ND_INS_VPMACSWD: return "vpmacswd";
    case ND_INS_VPMACSWW: return "vpmacsww";
    case ND_INS_VPMADCSSWD: return "vpmadcsswd";
    case ND_INS_VPMADCSWD: return "vpmadcswd";
    case ND_INS_VPMADD52HUQ: return "vpmadd52huq";
    case ND_INS_VPMADD52LUQ: return "vpmadd52luq";
    case ND_INS_VPMADDUBSW: return "vpmaddubsw";
    case ND_INS_VPMADDWD: return "vpmaddwd";
    case ND_INS_VPMASKMOVD: return "vpmaskmovd";
    case ND_INS_VPMASKMOVQ: return "vpmaskmovq";
    case ND_INS_VPMAXSB: return "vpmaxsb";
    case ND_INS_VPMAXSD: return "vpmaxsd";
    case ND_INS_VPMAXSQ: return "vpmaxsq";
    case ND_INS_VPMAXSW: return "vpmaxsw";
    case ND_INS_VPMAXUB: return "vpmaxub";
    case ND_INS_VPMAXUD: return "vpmaxud";
    case ND_INS_VPMAXUQ: return "vpmaxuq";
    case ND_INS_VPMAXUW: return "vpmaxuw";
    case ND_INS_VPMINSB: return "vpminsb";
    case ND_INS_VPMINSD: return "vpminsd";
    case ND_INS_VPMINSQ: return "vpminsq";
    case ND_INS_VPMINSW: return "vpminsw";
    case ND_INS_VPMINUB: return "vpminub";
    case ND_INS_VPMINUD: return "vpminud";
    case ND_INS_VPMINUQ: return "vpminuq";
    case ND_INS_VPMINUW: return "vpminuw";
    case ND_INS_VPMOVB2M: return "vpmovb2m";
    case ND_INS_VPMOVD2M: return "vpmovd2m";
    case ND_INS_VPMOVDB: return "vpmovdb";
    case ND_INS_VPMOVDW: return "vpmovdw";
    case ND_INS_VPMOVM2B: return "vpmovm2b";
    case ND_INS_VPMOVM2D: return "vpmovm2d";
    case ND_INS_VPMOVM2Q: return "vpmovm2q";
    case ND_INS_VPMOVM2W: return "vpmovm2w";
    case ND_INS_VPMOVMSKB: return "vpmovmskb";
    case ND_INS_VPMOVQ2M: return "vpmovq2m";
    case ND_INS_VPMOVQB: return "vpmovqb";
    case ND_INS_VPMOVQD: return "vpmovqd";
    case ND_INS_VPMOVQW: return "vpmovqw";
    case ND_INS_VPMOVSDB: return "vpmovsdb";
    case ND_INS_VPMOVSDW: return "vpmovsdw";
    case ND_INS_VPMOVSQB: return "vpmovsqb";
    case ND_INS_VPMOVSQD: return "vpmovsqd";
    case ND_INS_VPMOVSQW: return "vpmovsqw";
    case ND_INS_VPMOVSWB: return "vpmovswb";
    case ND_INS_VPMOVSXBD: return "vpmovsxbd";
    case ND_INS_VPMOVSXBQ: return "vpmovsxbq";
    case ND_INS_VPMOVSXBW: return "vpmovsxbw";
    case ND_INS_VPMOVSXDQ: return "vpmovsxdq";
    case ND_INS_VPMOVSXWD: return "vpmovsxwd";
    case ND_INS_VPMOVSXWQ: return "vpmovsxwq";
    case ND_INS_VPMOVUSDB: return "vpmovusdb";
    case ND_INS_VPMOVUSDW: return "vpmovusdw";
    case ND_INS_VPMOVUSQB: return "vpmovusqb";
    case ND_INS_VPMOVUSQD: return "vpmovusqd";
    case ND_INS_VPMOVUSQW: return "vpmovusqw";
    case ND_INS_VPMOVUSWB: return "vpmovuswb";
    case ND_INS_VPMOVW2M: return "vpmovw2m";
    case ND_INS_VPMOVWB: return "vpmovwb";
    case ND_INS_VPMOVZXBD: return "vpmovzxbd";
    case ND_INS_VPMOVZXBQ: return "vpmovzxbq";
    case ND_INS_VPMOVZXBW: return "vpmovzxbw";
    case ND_INS_VPMOVZXDQ: return "vpmovzxdq";
    case ND_INS_VPMOVZXWD: return "vpmovzxwd";
    case ND_INS_VPMOVZXWQ: return "vpmovzxwq";
    case ND_INS_VPMULDQ: return "vpmuldq";
    case ND_INS_VPMULHRSW: return "vpmulhrsw";
    case ND_INS_VPMULHUW: return "vpmulhuw";
    case ND_INS_VPMULHW: return "vpmulhw";
    case ND_INS_VPMULLD: return "vpmulld";
    case ND_INS_VPMULLQ: return "vpmullq";
    case ND_INS_VPMULLW: return "vpmullw";
    case ND_INS_VPMULTISHIFTQB: return "vpmultishiftqb";
    case ND_INS_VPMULUDQ: return "vpmuludq";
    case ND_INS_VPOPCNTB: return "vpopcntb";
    case ND_INS_VPOPCNTD: return "vpopcntd";
    case ND_INS_VPOPCNTQ: return "vpopcntq";
    case ND_INS_VPOPCNTW: return "vpopcntw";
    case ND_INS_VPOR: return "vpor";
    case ND_INS_VPORD: return "vpord";
    case ND_INS_VPORQ: return "vporq";
    case ND_INS_VPPERM: return "vpperm";
    case ND_INS_VPROLD: return "vprold";
    case ND_INS_VPROLQ: return "vprolq";
    case ND_INS_VPROLVD: return "vprolvd";
    case ND_INS_VPROLVQ: return "vprolvq";
    case ND_INS_VPRORD: return "vprord";
    case ND_INS_VPRORQ: return "vprorq";
    case ND_INS_VPRORVD: return "vprorvd";
    case ND_INS_VPRORVQ: return "vprorvq";
    case ND_INS_VPROTB: return "vprotb";
    case ND_INS_VPROTD: return "vprotd";
    case ND_INS_VPROTQ: return "vprotq";
    case ND_INS_VPROTW: return "vprotw";
    case ND_INS_VPSADBW: return "vpsadbw";
    case ND_INS_VPSCATTERDD: return "vpscatterdd";
    case ND_INS_VPSCATTERDQ: return "vpscatterdq";
    case ND_INS_VPSCATTERQD: return "vpscatterqd";
    case ND_INS_VPSCATTERQQ: return "vpscatterqq";
    case ND_INS_VPSHAB: return "vpshab";
    case ND_INS_VPSHAD: return "vpshad";
    case ND_INS_VPSHAQ: return "vpshaq";
    case ND_INS_VPSHAW: return "vpshaw";
    case ND_INS_VPSHLB: return "vpshlb";
    case ND_INS_VPSHLD: return "vpshld";
    case ND_INS_VPSHLDD: return "vpshldd";
    case ND_INS_VPSHLDQ: return "vpshldq";
    case ND_INS_VPSHLDVD: return "vpshldvd";
    case ND_INS_VPSHLDVQ: return "vpshldvq";
    case ND_INS_VPSHLDVW: return "vpshldvw";
    case ND_INS_VPSHLDW: return "vpshldw";
    case ND_INS_VPSHLQ: return "vpshlq";
    case ND_INS_VPSHLW: return "vpshlw";
    case ND_INS_VPSHRDD: return "vpshrdd";
    case ND_INS_VPSHRDQ: return "vpshrdq";
    case ND_INS_VPSHRDVD: return "vpshrdvd";
    case ND_INS_VPSHRDVQ: return "vpshrdvq";
    case ND_INS_VPSHRDVW: return "vpshrdvw";
    case ND_INS_VPSHRDW: return "vpshrdw";
    case ND_INS_VPSHUFB: return "vpshufb";
    case ND_INS_VPSHUFBITQMB: return "vpshufbitqmb";
    case ND_INS_VPSHUFD: return "vpshufd";
    case ND_INS_VPSHUFHW: return "vpshufhw";
    case ND_INS_VPSHUFLW: return "vpshuflw";
    case ND_INS_VPSIGNB: return "vpsignb";
    case ND_INS_VPSIGND: return "vpsignd";
    case ND_INS_VPSIGNW: return "vpsignw";
    case ND_INS_VPSLLD: return "vpslld";
    case ND_INS_VPSLLDQ: return "vpslldq";
    case ND_INS_VPSLLQ: return "vpsllq";
    case ND_INS_VPSLLVD: return "vpsllvd";
    case ND_INS_VPSLLVQ: return "vpsllvq";
    case ND_INS_VPSLLVW: return "vpsllvw";
    case ND_INS_VPSLLW: return "vpsllw";
    case ND_INS_VPSRAD: return "vpsrad";
    case ND_INS_VPSRAQ: return "vpsraq";
    case ND_INS_VPSRAVD: return "vpsravd";
    case ND_INS_VPSRAVQ: return "vpsravq";
    case ND_INS_VPSRAVW: return "vpsravw";
    case ND_INS_VPSRAW: return "vpsraw";
    case ND_INS_VPSRLD: return "vpsrld";
    case ND_INS_VPSRLDQ: return "vpsrldq";
    case ND_INS_VPSRLQ: return "vpsrlq";
    case ND_INS_VPSRLVD: return "vpsrlvd";
    case ND_INS_VPSRLVQ: return "vpsrlvq";
    case ND_INS_VPSRLVW: return "vpsrlvw";
    case ND_INS_VPSRLW: return "vpsrlw";
    case ND_INS_VPSUBB: return "vpsubb";
    case ND_INS_VPSUBD: return "vpsubd";
    case ND_INS_VPSUBQ: return "vpsubq";
    case ND_INS_VPSUBSB: return "vpsubsb";
    case ND_INS_VPSUBSW: return "vpsubsw";
    case ND_INS_VPSUBUSB: return "vpsubusb";
    case ND_INS_VPSUBUSW: return "vpsubusw";
    case ND_INS_VPSUBW: return "vpsubw";
    case ND_INS_VPTERNLOGD: return "vpternlogd";
    case ND_INS_VPTERNLOGQ: return "vpternlogq";
    case ND_INS_VPTEST: return "vptest";
    case ND_INS_VPTESTMB: return "vptestmb";
    case ND_INS_VPTESTMD: return "vptestmd";
    case ND_INS_VPTESTMQ: return "vptestmq";
    case ND_INS_VPTESTMW: return "vptestmw";
    case ND_INS_VPTESTNMB: return "vptestnmb";
    case ND_INS_VPTESTNMD: return "vptestnmd";
    case ND_INS_VPTESTNMQ: return "vptestnmq";
    case ND_INS_VPTESTNMW: return "vptestnmw";
    case ND_INS_VPUNPCKHBW: return "vpunpckhbw";
    case ND_INS_VPUNPCKHDQ: return "vpunpckhdq";
    case ND_INS_VPUNPCKHQDQ: return "vpunpckhqdq";
    case ND_INS_VPUNPCKHWD: return "vpunpckhwd";
    case ND_INS_VPUNPCKLBW: return "vpunpcklbw";
    case ND_INS_VPUNPCKLDQ: return "vpunpckldq";
    case ND_INS_VPUNPCKLQDQ: return "vpunpcklqdq";
    case ND_INS_VPUNPCKLWD: return "vpunpcklwd";
    case ND_INS_VPXOR: return "vpxor";
    case ND_INS_VPXORD: return "vpxord";
    case ND_INS_VPXORQ: return "vpxorq";
    case ND_INS_VRANGEPD: return "vrangepd";
    case ND_INS_VRANGEPS: return "vrangeps";
    case ND_INS_VRANGESD: return "vrangesd";
    case ND_INS_VRANGESS: return "vrangess";
    case ND_INS_VRCP14PD: return "vrcp14pd";
    case ND_INS_VRCP14PS: return "vrcp14ps";
    case ND_INS_VRCP14SD: return "vrcp14sd";
    case ND_INS_VRCP14SS: return "vrcp14ss";
    case ND_INS_VRCP28PD: return "vrcp28pd";
    case ND_INS_VRCP28PS: return "vrcp28ps";
    case ND_INS_VRCP28SD: return "vrcp28sd";
    case ND_INS_VRCP28SS: return "vrcp28ss";
    case ND_INS_VRCPPS: return "vrcpps";
    case ND_INS_VRCPSS: return "vrcpss";
    case ND_INS_VREDUCEPD: return "vreducepd";
    case ND_INS_VREDUCEPS: return "vreduceps";
    case ND_INS_VREDUCESD: return "vreducesd";
    case ND_INS_VREDUCESS: return "vreducess";
    case ND_INS_VRNDSCALEPD: return "vrndscalepd";
    case ND_INS_VRNDSCALEPS: return "vrndscaleps";
    case ND_INS_VRNDSCALESD: return "vrndscalesd";
    case ND_INS_VRNDSCALESS: return "vrndscaless";
    case ND_INS_VROUNDPD: return "vroundpd";
    case ND_INS_VROUNDPS: return "vroundps";
    case ND_INS_VROUNDSD: return "vroundsd";
    case ND_INS_VROUNDSS: return "vroundss";
    case ND_INS_VRSQRT14PD: return "vrsqrt14pd";
    case ND_INS_VRSQRT14PS: return "vrsqrt14ps";
    case ND_INS_VRSQRT14SD: return "vrsqrt14sd";
    case ND_INS_VRSQRT14SS: return "vrsqrt14ss";
    case ND_INS_VRSQRT28PD: return "vrsqrt28pd";
    case ND_INS_VRSQRT28PS: return "vrsqrt28ps";
    case ND_INS_VRSQRT28SD: return "vrsqrt28sd";
    case ND_INS_VRSQRT28SS: return "vrsqrt28ss";
    case ND_INS_VRSQRTPS: return "vrsqrtps";
    case ND_INS_VRSQRTSS: return "vrsqrtss";
    case ND_INS_VSCALEFPD: return "vscalefpd";
    case ND_INS_VSCALEFPS: return "vscalefps";
    case ND_INS_VSCALEFSD: return "vscalefsd";
    case ND_INS_VSCALEFSS: return "vscalefss";
    case ND_INS_VSCATTERDPD: return "vscatterdpd";
    case ND_INS_VSCATTERDPS: return "vscatterdps";
    case ND_INS_VSCATTERPF0DPD: return "vscatterpf0dpd";
    case ND_INS_VSCATTERPF0DPS: return "vscatterpf0dps";
    case ND_INS_VSCATTERPF0QPD: return "vscatterpf0qpd";
    case ND_INS_VSCATTERPF0QPS: return "vscatterpf0qps";
    case ND_INS_VSCATTERPF1DPD: return "vscatterpf1dpd";
    case ND_INS_VSCATTERPF1DPS: return "vscatterpf1dps";
    case ND_INS_VSCATTERPF1QPD: return "vscatterpf1qpd";
    case ND_INS_VSCATTERPF1QPS: return "vscatterpf1qps";
    case ND_INS_VSCATTERQPD: return "vscatterqpd";
    case ND_INS_VSCATTERQPS: return "vscatterqps";
    case ND_INS_VSHUFF32X4: return "vshuff32x4";
    case ND_INS_VSHUFF64X2: return "vshuff64x2";
    case ND_INS_VSHUFI32X4: return "vshufi32x4";
    case ND_INS_VSHUFI64X2: return "vshufi64x2";
    case ND_INS_VSHUFPD: return "vshufpd";
    case ND_INS_VSHUFPS: return "vshufps";
    case ND_INS_VSQRTPD: return "vsqrtpd";
    case ND_INS_VSQRTPS: return "vsqrtps";
    case ND_INS_VSQRTSD: return "vsqrtsd";
    case ND_INS_VSQRTSS: return "vsqrtss";
    case ND_INS_VSTMXCSR: return "vstmxcsr";
    case ND_INS_VSUBPD: return "vsubpd";
    case ND_INS_VSUBPS: return "vsubps";
    case ND_INS_VSUBSD: return "vsubsd";
    case ND_INS_VSUBSS: return "vsubss";
    case ND_INS_VTESTPD: return "vtestpd";
    case ND_INS_VTESTPS: return "vtestps";
    case ND_INS_VUCOMISD: return "vucomisd";
    case ND_INS_VUCOMISS: return "vucomiss";
    case ND_INS_VUNPCKHPD: return "vunpckhpd";
    case ND_INS_VUNPCKHPS: return "vunpckhps";
    case ND_INS_VUNPCKLPD: return "vunpcklpd";
    case ND_INS_VUNPCKLPS: return "vunpcklps";
    case ND_INS_VXORPD: return "vxorpd";
    case ND_INS_VXORPS: return "vxorps";
    case ND_INS_VZEROALL: return "vzeroall";
    case ND_INS_VZEROUPPER: return "vzeroupper";
    case ND_INS_WAIT: return "wait";
    case ND_INS_WBINVD: return "wbinvd";
    case ND_INS_WBNOINVD: return "wbnoinvd";
    case ND_INS_WRFSBASE: return "wrfsbase";
    case ND_INS_WRGSBASE: return "wrgsbase";
    case ND_INS_WRMSR: return "wrmsr";
    case ND_INS_WRPKRU: return "wrpkru";
    case ND_INS_WRSHR: return "wrshr";
    case ND_INS_WRSS: return "wrss";
    case ND_INS_WRUSS: return "wruss";
    case ND_INS_XABORT: return "xabort";
    case ND_INS_XADD: return "xadd";
    case ND_INS_XBEGIN: return "xbegin";
    case ND_INS_XCHG: return "xchg";
    case ND_INS_XCRYPTCBC: return "xcryptcbc";
    case ND_INS_XCRYPTCFB: return "xcryptcfb";
    case ND_INS_XCRYPTCTR: return "xcryptctr";
    case ND_INS_XCRYPTECB: return "xcryptecb";
    case ND_INS_XCRYPTOFB: return "xcryptofb";
    case ND_INS_XEND: return "xend";
    case ND_INS_XGETBV: return "xgetbv";
    case ND_INS_XLATB: return "xlatb";
    case ND_INS_XOR: return "xor";
    case ND_INS_XORPD: return "xorpd";
    case ND_INS_XORPS: return "xorps";
    case ND_INS_XRESLDTRK: return "xresldtrik";
    case ND_INS_XRSTOR: return "xrstor";
    case ND_INS_XRSTORS: return "xrstors";
    case ND_INS_XSAVE: return "xsave";
    case ND_INS_XSAVEC: return "xsavec";
    case ND_INS_XSAVEOPT: return "xsaveopt";
    case ND_INS_XSAVES: return "xsaves";
    case ND_INS_XSETBV: return "xsetbv";
    case ND_INS_XSHA1: return "xsha1";
    case ND_INS_XSHA256: return "xsha256";
    case ND_INS_XSUSLDTRK: return "xsusldtrk";
    case ND_INS_XSTORE: return "xstore";
    case ND_INS_XTEST: return "xtest";
    case ND_INS_HRESET: return "hreset";
    case ND_INS_CLUI: return "clui";
    case ND_INS_STUI: return "stui";
    case ND_INS_TESTUI: return "testui";
    case ND_INS_UIRET: return "uiret";
    case ND_INS_SENDUIPI: return "senduipi";
    case ND_INS_AADD: return "aadd";
    case ND_INS_AAND: return "aand";
    case ND_INS_AOR: return "aor";
    case ND_INS_AXOR: return "axor";
    case ND_INS_CMPBEXADD: return "cmpbexadd";
    case ND_INS_CMPCXADD: return "cmpcxadd";
    case ND_INS_CMPLEXADD: return "cmplexadd";
    case ND_INS_CMPLXADD: return "cmplxadd";
    case ND_INS_CMPNBEXADD: return "cmpnbexadd";
    case ND_INS_CMPNCXADD: return "cmpncxadd";
    case ND_INS_CMPNLEXADD: return "cmpnlexadd";
    case ND_INS_CMPNLXADD: return "cmpnlxadd";
    case ND_INS_CMPNOXADD: return "cmpnoxadd";
    case ND_INS_CMPNPXADD: return "cmpnpxadd";
    case ND_INS_CMPNSXADD: return "cmpnsxadd";
    case ND_INS_CMPNZXADD: return "cmpnzxadd";
    case ND_INS_CMPOXADD: return  "cmpoxadd";
    case ND_INS_CMPPXADD: return "cmppxadd";
    case ND_INS_CMPSXADD: return "cmpsxadd";
    case ND_INS_CMPZXADD: return "cmpzxadd";
    case ND_INS_PREFETCHIT0: return "prefetchit0";
    case ND_INS_PREFETCHIT1: return "prefetchit1";
    case ND_INS_RDMSRLIST: return "rdmsrlist";
    case ND_INS_TDPFP16PS: return "tdpfp16ps";
    case ND_INS_VBCSTNEBF162PS: return "vbcstnebf162ps";
    case ND_INS_VBCSTNESH2PS: return "vbcstnesh2ps";
    case ND_INS_VCVTNEEBF162PS: return "vcvtneebf162ps";
    case ND_INS_VCVTNEEPH2PS: return "vcvtneeph2ps";
    case ND_INS_VCVTNEOBF162PS: return "vcvtneobf162ps";
    case ND_INS_VCVTNEOPH2PS: return "vcvtneoph2ps";
    case ND_INS_VPDPBSSD:  return "vpdpbssd";
    case ND_INS_VPDPBSSDS: return "vpdpbssds";
    case ND_INS_VPDPBSUD:  return "vpdpbsud";
    case ND_INS_VPDPBSUDS: return "vpdpbsuds";
    case ND_INS_VPDPBUUD:  return "vpdpbuud";
    case ND_INS_VPDPBUUDS: return "vpdpbuuds";
    case ND_INS_WRMSRLIST: return "wrmsrlist";
    case ND_INS_WRMSRNS: return "wrmsrns";
    case ND_INS_RMPQUERY: return "rmpquery";
    case ND_INS_TCMMRLFP16PS: return "tcmmrlfp16ps";
    case ND_INS_TCMMIMFP16PS: return "tcmmimfp16ps";
    default: return "unhandled!";
    }

    return "<unknown>";
}


std::string ins_cat_to_str(ND_INS_CATEGORY category)
{
    switch (category) {
    case ND_CAT_INVALID: return "invalid";
    case ND_CAT_3DNOW: return "3dnow";
    case ND_CAT_AES: return "aes";
    case ND_CAT_AESKL: return "aeskl";
    case ND_CAT_AMX: return "amx";
    case ND_CAT_ARITH: return "arith";
    case ND_CAT_AVX: return "avx";
    case ND_CAT_AVX2: return "avx2";
    case ND_CAT_AVX2GATHER: return "avx2gather";
    case ND_CAT_AVX512: return "avx512";
    case ND_CAT_AVX512BF16: return "avx512bf16";
    case ND_CAT_AVX512VBMI: return "avx512vbmi";
    case ND_CAT_AVX512VP2INTERSECT: return "avx512vp2intersect";
    case ND_CAT_AVX512FP16: return "avx512fp16";
    case ND_CAT_AVXVNNI: return "avxvnni";
    case ND_CAT_BITBYTE: return "bitbyte";
    case ND_CAT_BLEND: return "blend";
    case ND_CAT_BMI1: return "bmi1";
    case ND_CAT_BMI2: return "bmi2";
    case ND_CAT_BROADCAST: return "broadcast";
    case ND_CAT_CALL: return "call";
    case ND_CAT_CET: return "cet";
    case ND_CAT_CLDEMOTE: return "cldemote";
    case ND_CAT_CMOV: return "cmov";
    case ND_CAT_COMPRESS: return "compress";
    case ND_CAT_COND_BR: return "cond_br";
    case ND_CAT_CONFLICT: return "conflict";
    case ND_CAT_CONVERT: return "convert";
    case ND_CAT_DATAXFER: return "dataxfer";
    case ND_CAT_DECIMAL: return "decimal";
    case ND_CAT_ENQCMD: return "enqcmd";
    case ND_CAT_EXPAND: return "expand";
    case ND_CAT_FLAGOP: return "flagop";
    case ND_CAT_FMA4: return "fma4";
    case ND_CAT_GATHER: return "gather";
    case ND_CAT_GFNI: return "gfni";
    case ND_CAT_HRESET: return "hreset";
    case ND_CAT_I386: return "i386";
    case ND_CAT_IFMA: return "ifma";
    case ND_CAT_INTERRUPT: return "interrupt";
    case ND_CAT_IO: return "io";
    case ND_CAT_IOSTRINGOP: return "iostringop";
    case ND_CAT_KL: return "kl";
    case ND_CAT_KMASK: return "kmask";
    case ND_CAT_KNL: return "knl";
    case ND_CAT_LKGS: return "lkgs";
    case ND_CAT_LOGIC: return "logic";
    case ND_CAT_LOGICAL: return "logical";
    case ND_CAT_LOGICAL_FP: return "logical_fp";
    case ND_CAT_LWP: return "lwp";
    case ND_CAT_LZCNT: return "lzcnt";
    case ND_CAT_MISC: return "misc";
    case ND_CAT_MMX: return "mmx";
    case ND_CAT_MOVDIR64B: return "movdir64b";
    case ND_CAT_MOVDIRI: return "movdiri";
    case ND_CAT_MPX: return "mpx";
    case ND_CAT_NOP: return "nop";
    case ND_CAT_PADLOCK: return "padlock";
    case ND_CAT_PCLMULQDQ: return "pclmulqdq";
    case ND_CAT_PCONFIG: return "pconfig";
    case ND_CAT_POP: return "pop";
    case ND_CAT_PREFETCH: return "prefetch";
    case ND_CAT_PTWRITE: return "ptwrite";
    case ND_CAT_PUSH: return "push";
    case ND_CAT_RDPID: return "rdpid";
    case ND_CAT_RDRAND: return "rdrand";
    case ND_CAT_RDSEED: return "rdseed";
    case ND_CAT_RDWRFSGS: return "rdwrfsgs";
    case ND_CAT_RET: return "ret";
    case ND_CAT_ROTATE: return "rotate";
    case ND_CAT_SCATTER: return "scatter";
    case ND_CAT_SEGOP: return "segop";
    case ND_CAT_SEMAPHORE: return "semaphore";
    case ND_CAT_SGX: return "sgx";
    case ND_CAT_SHA: return "sha";
    case ND_CAT_SHIFT: return "shift";
    case ND_CAT_SMAP: return "smap";
    case ND_CAT_SSE: return "sse";
    case ND_CAT_SSE2: return "sse2";
    case ND_CAT_STRINGOP: return "stringop";
    case ND_CAT_STTNI: return "sttni";
    case ND_CAT_SYSCALL: return "syscall";
    case ND_CAT_SYSRET: return "sysret";
    case ND_CAT_SYSTEM: return "system";
    case ND_CAT_TDX: return "tdx";
    case ND_CAT_UD: return "ud";
    case ND_CAT_UINTR: return "uintr";
    case ND_CAT_UNCOND_BR: return "uncond_br";
    case ND_CAT_UNKNOWN: return "unknown";
    case ND_CAT_VAES: return "vaes";
    case ND_CAT_VFMA: return "vfma";
    case ND_CAT_VFMAPS: return "vfmaps";
    case ND_CAT_VNNI: return "vnni";
    case ND_CAT_VNNIW: return "vnniw";
    case ND_CAT_VPCLMULQDQ: return "vpclmulqdq";
    case ND_CAT_VPOPCNT: return "vpopcnt";
    case ND_CAT_VTX: return "vtx";
    case ND_CAT_WAITPKG: return "waitpkg";
    case ND_CAT_WBNOINVD: return "wbnoinvd";
    case ND_CAT_WIDE_KL: return "wide_kl";
    case ND_CAT_WIDENOP: return "widenop";
    case ND_CAT_X87_ALU: return "x87_alu";
    case ND_CAT_XOP: return "xop";
    case ND_CAT_XSAVE: return "xsave";
    case ND_CAT_AVXIFMA: return "avxifma";
    case ND_CAT_AVXVNNIINT8: return "avxvnniint8";
    case ND_CAT_AVXNECONVERT: return "avxneconvert";
    case ND_CAT_CMPCCXADD: return "cmpccxass";
    case ND_CAT_RAOINT: return "rao-int";
    }

    return "<unknown>";
}


std::string ins_set_to_str(ND_INS_SET ins_set)
{
    switch (ins_set) {
    case ND_SET_INVALID: return "invalid";
    case ND_SET_3DNOW: return "3dnow";
    case ND_SET_ADX: return "adx";
    case ND_SET_AES: return "aes";
    case ND_SET_AMD: return "amd";
    case ND_SET_AMXBF16: return "amxbf16";
    case ND_SET_AMXINT8: return "amxint8";
    case ND_SET_AMXTILE: return "amxtile";
    case ND_SET_AMXCOMPLEX: return "amxcomplex";
    case ND_SET_AVX: return "avx";
    case ND_SET_AVX2: return "avx2";
    case ND_SET_AVX2GATHER: return "avx2gather";
    case ND_SET_AVX5124FMAPS: return "avx5124fmaps";
    case ND_SET_AVX5124VNNIW: return "avx5124vnniw";
    case ND_SET_AVX512BF16: return "avx512bf16";
    case ND_SET_AVX512BITALG: return "avx512bitalg";
    case ND_SET_AVX512BW: return "avx512bw";
    case ND_SET_AVX512CD: return "avx512cd";
    case ND_SET_AVX512DQ: return "avx512dq";
    case ND_SET_AVX512ER: return "avx512er";
    case ND_SET_AVX512F: return "avx512f";
    case ND_SET_AVX512IFMA: return "avx512ifma";
    case ND_SET_AVX512PF: return "avx512pf";
    case ND_SET_AVX512VBMI: return "avx512vbmi";
    case ND_SET_AVX512VBMI2: return "avx512vbmi2";
    case ND_SET_AVX512VNNI: return "avx512vnni";
    case ND_SET_AVX512VP2INTERSECT: return "avx512vp2intersect";
    case ND_SET_AVX512VPOPCNTDQ: return "avx512vpopcntdq";
    case ND_SET_AVX512FP16: return "avx512fp16";
    case ND_SET_AVXVNNI: return "avxvnni";
    case ND_SET_BMI1: return "bmi1";
    case ND_SET_BMI2: return "bmi2";
    case ND_SET_CET_SS: return "cet_ss";
    case ND_SET_CET_IBT: return "cet_ibt";
    case ND_SET_CLDEMOTE: return "cldemote";
    case ND_SET_CLFSH: return "clfsh";
    case ND_SET_CLFSHOPT: return "clfshopt";
    case ND_SET_CLWB: return "clwb";
    case ND_SET_CLZERO: return "clzero";
    case ND_SET_CMPXCHG16B: return "cmpxchg16b";
    case ND_SET_CYRIX: return "cyrix";
    case ND_SET_CYRIX_SMM: return "cyrix_smm";
    case ND_SET_ENQCMD: return "enqcmd";
    case ND_SET_F16C: return "f16c";
    case ND_SET_FMA: return "fma";
    case ND_SET_FMA4: return "fma4";
    case ND_SET_FRED: return "fred";
    case ND_SET_FXSAVE: return "fxsave";
    case ND_SET_GFNI: return "gfni";
    case ND_SET_HRESET: return "hreset";
    case ND_SET_I186: return "i186";
    case ND_SET_INVLPGB: return "invlpgb";
    case ND_SET_I286PROT: return "i286prot";
    case ND_SET_I286REAL: return "i286real";
    case ND_SET_I386: return "i386";
    case ND_SET_I486: return "i486";
    case ND_SET_I486REAL: return "i486real";
    case ND_SET_I64: return "i64";
    case ND_SET_I86: return "i86";
    case ND_SET_INVPCID: return "invpcid";
    case ND_SET_KL: return "kl";
    case ND_SET_LKGS: return "lkgs";
    case ND_SET_LONGMODE: return "longmode";
    case ND_SET_LWP: return "lwp";
    case ND_SET_LZCNT: return "lzcnt";
    case ND_SET_MCOMMIT: return "mcommit";
    case ND_SET_MMX: return "mmx";
    case ND_SET_MOVBE: return "movbe";
    case ND_SET_MOVDIR64B: return "movdir64b";
    case ND_SET_MOVDIRI: return "movdiri";
    case ND_SET_MPX: return "mpx";
    case ND_SET_MWAITT: return "mwaitt";
    case ND_SET_PAUSE: return "pause";
    case ND_SET_PCLMULQDQ: return "pclmulqdq";
    case ND_SET_PCONFIG: return "pconfig";
    case ND_SET_PENTIUMREAL: return "pentiumreal";
    case ND_SET_PKU: return "pku";
    case ND_SET_POPCNT: return "popcnt";
    case ND_SET_PPRO: return "ppro";
    case ND_SET_PREFETCH_NOP: return "prefetch_nop";
    case ND_SET_PTWRITE: return "ptwrite";
    case ND_SET_RDPID: return "rdpid";
    case ND_SET_RDPMC: return "rdpmc";
    case ND_SET_RDPRU: return "rdpru";
    case ND_SET_RDRAND: return "rdrand";
    case ND_SET_RDSEED: return "rdseed";
    case ND_SET_RDTSCP: return "rdtscp";
    case ND_SET_RDWRFSGS: return "rdwrfsgs";
    case ND_SET_SERIALIZE: return "serialize";
    case ND_SET_SGX: return "sgx";
    case ND_SET_SHA: return "sha";
    case ND_SET_SMAP: return "smap";
    case ND_SET_SMX: return "smx";
    case ND_SET_SNP: return "snp";
    case ND_SET_SSE: return "sse";
    case ND_SET_SSE2: return "sse2";
    case ND_SET_SSE3: return "sse3";
    case ND_SET_SSE4: return "sse4";
    case ND_SET_SSE42: return "sse42";
    case ND_SET_SSE4A: return "sse4a";
    case ND_SET_SSSE3: return "ssse3";
    case ND_SET_SVM: return "svm";
    case ND_SET_TBM: return "tbm";
    case ND_SET_TDX: return "tdx";
    case ND_SET_TSX: return "tsx";
    case ND_SET_TSXLDTRK: return "tsxldtrk";
    case ND_SET_UD: return "ud";
    case ND_SET_UINTR: return "uintr";
    case ND_SET_UNKNOWN: return "unknown";
    case ND_SET_VAES: return "vaes";
    case ND_SET_VPCLMULQDQ: return "vpclmulqdq";
    case ND_SET_VTX: return "vtx";
    case ND_SET_WAITPKG: return "waitpkg";
    case ND_SET_WBNOINVD: return "wbnoinvd";
    case ND_SET_X87: return "x87";
    case ND_SET_XOP: return "xop";
    case ND_SET_XSAVE: return "xsave";
    case ND_SET_XSAVEC: return "xsavec";
    case ND_SET_XSAVES: return "xsaves";
    case ND_SET_AMXFP16: return "AMX-FP16";
    case ND_SET_AVXIFMA: return "avxifma";
    case ND_SET_AVXNECONVERT: return "avxneconvert";
    case ND_SET_AVXVNNIINT8: return "avxvnniint8";
    case ND_SET_CMPCCXADD: return "cmpccxadd";
    case ND_SET_MSRLIST: return "msrlist";
    case ND_SET_PREFETCHITI: return "prefetchiti";
    case ND_SET_RAOINT: return "raoint";
    case ND_SET_WRMSRNS: return "wrmsrns";
    }

    return "<unknown>";
}


std::string reg_to_str(const int reg, const ND_REG_TYPE type)
{
    switch (type) {
    case ND_REG_NOT_PRESENT:
        return "not_preset";

    case ND_REG_GPR:
        switch (reg) {
        case NDR_RAX: return "rax";
        case NDR_RCX: return "rcx";
        case NDR_RDX: return "rdx";
        case NDR_RBX: return "rbx";
        case NDR_RSP: return "rsp";
        case NDR_RBP: return "rbp";
        case NDR_RSI: return "rsi";
        case NDR_RDI: return "rdi";
        case NDR_R8: return "r8";
        case NDR_R9: return "r9";
        case NDR_R10: return "r10";
        case NDR_R11: return "r11";
        case NDR_R12: return "r12";
        case NDR_R13: return "r13";
        case NDR_R14: return "r14";
        case NDR_R15: return "r15";
        }

        return "<u>";

    case ND_REG_SEG:
        switch (reg) {
        case NDR_ES: return "es";
        case NDR_CS: return "cs";
        case NDR_SS: return "ss";
        case NDR_DS: return "ds";
        case NDR_FS: return "fs";
        case NDR_GS: return "gs";
        case NDR_INV6: return "inv6";
        case NDR_INV7: return "inv7";
        }

        return "<u>";

    case ND_REG_FPU:
        return "fpu";
    case ND_REG_MMX:
        return "mmx";
    case ND_REG_SSE:
        return "sse";
    case ND_REG_CR:
        return "cr";
    case ND_REG_DR:
        return "dr";
    case ND_REG_TR:
        return "tr";
    case ND_REG_BND:
        return "bnd";
    case ND_REG_MSK:
        return "msk";
    case ND_REG_TILE:
        return "tile";
    case ND_REG_MSR:
        return "msr";
    case ND_REG_XCR:
        return "xcr";
    case ND_REG_SYS:
        return "sys";
    case ND_REG_X87:
        return "x87";
    case ND_REG_MXCSR:
        return "mxcsr";
    case ND_REG_PKRU:
        return "pkru";
    case ND_REG_SSP:
        return "ssp";
    case ND_REG_FLG:
        return "flg";
    case ND_REG_RIP:
        return "rip";
    case ND_REG_UIF:
        return "uif";
    }

    return "<u>";
}


std::string reg_type_to_str(const ND_REG_TYPE type)
{
    switch (type) {
    case ND_REG_NOT_PRESENT:
        return "present";
    case ND_REG_GPR:
        return "gpr";
    case ND_REG_SEG:
        return "seg";
    case ND_REG_FPU:
        return "fpu";
    case ND_REG_MMX:
        return "mmx";
    case ND_REG_SSE:
        return "sse";
    case ND_REG_CR:
        return "cr";
    case ND_REG_DR:
        return "dr";
    case ND_REG_TR:
        return "tr";
    case ND_REG_BND:
        return "bnd";
    case ND_REG_MSK:
        return "msk";
    case ND_REG_TILE:
        return "tile";
    case ND_REG_MSR:
        return "msr";
    case ND_REG_XCR:
        return "xcr";
    case ND_REG_SYS:
        return "sys";
    case ND_REG_X87:
        return "x87";
    case ND_REG_MXCSR:
        return "mxcsr";
    case ND_REG_PKRU:
        return "pkru";
    case ND_REG_SSP:
        return "ssp";
    case ND_REG_FLG:
        return "flg";
    case ND_REG_RIP:
        return "rip";
    case ND_REG_UIF:
        return "uif";
    }

    return "<unknown>";
}
