EXPECTED = {'ITS-Container': {'extensibility-implied': False,
                   'imports': {},
                   'object-classes': {},
                   'object-sets': {},
                   'tags': 'AUTOMATIC',
                   'types': {'AccelerationConfidence': {'named-numbers': {'outOfRange': 101,
                                                                          'pointOneMeterPerSecSquared': 1,
                                                                          'unavailable': 102},
                                                        'restricted-to': [(0,
                                                                           102)],
                                                        'type': 'INTEGER'},
                             'AccelerationControl': {'named-bits': [('brakePedalEngaged',
                                                                     '0'),
                                                                    ('gasPedalEngaged',
                                                                     '1'),
                                                                    ('emergencyBrakeEngaged',
                                                                     '2'),
                                                                    ('collisionWarningEngaged',
                                                                     '3'),
                                                                    ('accEngaged',
                                                                     '4'),
                                                                    ('cruiseControlEngaged',
                                                                     '5'),
                                                                    ('speedLimiterEngaged',
                                                                     '6')],
                                                     'size': [7],
                                                     'type': 'BIT STRING'},
                             'AccidentSubCauseCode': {'named-numbers': {'accidentInvolvingBus': 4,
                                                                        'accidentInvolvingHazardousMaterials': 5,
                                                                        'accidentInvolvingLorry': 3,
                                                                        'accidentOnOppositeLane': 6,
                                                                        'assistanceRequested': 8,
                                                                        'heavyAccident': 2,
                                                                        'multiVehicleAccident': 1,
                                                                        'unavailable': 0,
                                                                        'unsecuredAccident': 7},
                                                      'restricted-to': [(0,
                                                                         255)],
                                                      'type': 'INTEGER'},
                             'ActionID': {'members': [{'name': 'originatingStationID',
                                                       'type': 'StationID'},
                                                      {'name': 'sequenceNumber',
                                                       'type': 'SequenceNumber'}],
                                          'type': 'SEQUENCE'},
                             'AdverseWeatherCondition-AdhesionSubCauseCode': {'named-numbers': {'blackIceOnRoad': 6,
                                                                                                'fuelOnRoad': 2,
                                                                                                'heavyFrostOnRoad': 1,
                                                                                                'iceOnRoad': 5,
                                                                                                'instantBlackIce': 9,
                                                                                                'looseChippings': 8,
                                                                                                'mudOnRoad': 3,
                                                                                                'oilOnRoad': 7,
                                                                                                'roadsSalted': 10,
                                                                                                'snowOnRoad': 4,
                                                                                                'unavailable': 0},
                                                                              'restricted-to': [(0,
                                                                                                 255)],
                                                                              'type': 'INTEGER'},
                             'AdverseWeatherCondition-ExtremeWeatherConditionSubCauseCode': {'named-numbers': {'blizzard': 6,
                                                                                                               'damagingHail': 2,
                                                                                                               'hurricane': 3,
                                                                                                               'strongWinds': 1,
                                                                                                               'thunderstorm': 4,
                                                                                                               'tornado': 5,
                                                                                                               'unavailable': 0},
                                                                                             'restricted-to': [(0,
                                                                                                                255)],
                                                                                             'type': 'INTEGER'},
                             'AdverseWeatherCondition-PrecipitationSubCauseCode': {'named-numbers': {'heavyRain': 1,
                                                                                                     'heavySnowfall': 2,
                                                                                                     'softHail': 3,
                                                                                                     'unavailable': 0},
                                                                                   'restricted-to': [(0,
                                                                                                      255)],
                                                                                   'type': 'INTEGER'},
                             'AdverseWeatherCondition-VisibilitySubCauseCode': {'named-numbers': {'fog': 1,
                                                                                                  'heavyHail': 5,
                                                                                                  'heavyRain': 4,
                                                                                                  'heavySnowfall': 3,
                                                                                                  'lowSunGlare': 6,
                                                                                                  'sandstorms': 7,
                                                                                                  'smoke': 2,
                                                                                                  'swarmsOfInsects': 8,
                                                                                                  'unavailable': 0},
                                                                                'restricted-to': [(0,
                                                                                                   255)],
                                                                                'type': 'INTEGER'},
                             'Altitude': {'members': [{'name': 'altitudeValue',
                                                       'type': 'AltitudeValue'},
                                                      {'name': 'altitudeConfidence',
                                                       'type': 'AltitudeConfidence'}],
                                          'type': 'SEQUENCE'},
                             'AltitudeConfidence': {'type': 'ENUMERATED',
                                                    'values': [('alt-000-01',
                                                                0),
                                                               ('alt-000-02',
                                                                1),
                                                               ('alt-000-05',
                                                                2),
                                                               ('alt-000-10',
                                                                3),
                                                               ('alt-000-20',
                                                                4),
                                                               ('alt-000-50',
                                                                5),
                                                               ('alt-001-00',
                                                                6),
                                                               ('alt-002-00',
                                                                7),
                                                               ('alt-005-00',
                                                                8),
                                                               ('alt-010-00',
                                                                9),
                                                               ('alt-020-00',
                                                                10),
                                                               ('alt-050-00',
                                                                11),
                                                               ('alt-100-00',
                                                                12),
                                                               ('alt-200-00',
                                                                13),
                                                               ('outOfRange',
                                                                14),
                                                               ('unavailable',
                                                                15)]},
                             'AltitudeValue': {'named-numbers': {'oneCentimeter': 1,
                                                                 'referenceEllipsoidSurface': 0,
                                                                 'unavailable': 800001},
                                               'restricted-to': [(-100000,
                                                                  800001)],
                                               'type': 'INTEGER'},
                             'CauseCode': {'members': [{'name': 'causeCode',
                                                        'type': 'CauseCodeType'},
                                                       {'name': 'subCauseCode',
                                                        'type': 'SubCauseCodeType'}],
                                           'type': 'SEQUENCE'},
                             'CauseCodeType': {'named-numbers': {'accident': 2,
                                                                 'adverseWeatherCondition-Adhesion': 6,
                                                                 'adverseWeatherCondition-ExtremeWeatherCondition': 17,
                                                                 'adverseWeatherCondition-Precipitation': 19,
                                                                 'adverseWeatherCondition-Visibility': 18,
                                                                 'collisionRisk': 97,
                                                                 'dangerousEndOfQueue': 27,
                                                                 'dangerousSituation': 99,
                                                                 'emergencyVehicleApproaching': 95,
                                                                 'hazardousLocation-AnimalOnTheRoad': 11,
                                                                 'hazardousLocation-DangerousCurve': 96,
                                                                 'hazardousLocation-ObstacleOnTheRoad': 10,
                                                                 'hazardousLocation-SurfaceCondition': 9,
                                                                 'humanPresenceOnTheRoad': 12,
                                                                 'humanProblem': 93,
                                                                 'postCrash': 92,
                                                                 'rescueAndRecoveryWorkInProgress': 15,
                                                                 'reserved': 0,
                                                                 'roadworks': 3,
                                                                 'signalViolation': 98,
                                                                 'slowVehicle': 26,
                                                                 'stationaryVehicle': 94,
                                                                 'trafficCondition': 1,
                                                                 'vehicleBreakdown': 91,
                                                                 'wrongWayDriving': 14},
                                               'restricted-to': [(0, 255)],
                                               'type': 'INTEGER'},
                             'CenDsrcTollingZone': {'members': [{'name': 'protectedZoneLatitude',
                                                                 'type': 'Latitude'},
                                                                {'name': 'protectedZoneLongitude',
                                                                 'type': 'Longitude'},
                                                                {'name': 'cenDsrcTollingZoneID',
                                                                 'optional': True,
                                                                 'type': 'CenDsrcTollingZoneID'}],
                                                    'type': 'SEQUENCE'},
                             'CenDsrcTollingZoneID': {'type': 'ProtectedZoneID'},
                             'ClosedLanes': {'members': [{'name': 'hardShoulderStatus',
                                                          'optional': True,
                                                          'type': 'HardShoulderStatus'},
                                                         {'name': 'drivingLaneStatus',
                                                          'type': 'DrivingLaneStatus'},
                                                         None],
                                             'type': 'SEQUENCE'},
                             'CollisionRiskSubCauseCode': {'named-numbers': {'crossingCollisionRisk': 2,
                                                                             'lateralCollisionRisk': 3,
                                                                             'longitudinalCollisionRisk': 1,
                                                                             'unavailable': 0,
                                                                             'vulnerableRoadUser': 4},
                                                           'restricted-to': [(0,
                                                                              255)],
                                                           'type': 'INTEGER'},
                             'Curvature': {'members': [{'name': 'curvatureValue',
                                                        'type': 'CurvatureValue'},
                                                       {'name': 'curvatureConfidence',
                                                        'type': 'CurvatureConfidence'}],
                                           'type': 'SEQUENCE'},
                             'CurvatureCalculationMode': {'type': 'ENUMERATED',
                                                          'values': [('yawRateUsed',
                                                                      0),
                                                                     ('yawRateNotUsed',
                                                                      1),
                                                                     ('unavailable',
                                                                      2),
                                                                     None]},
                             'CurvatureConfidence': {'type': 'ENUMERATED',
                                                     'values': [('onePerMeter-0-00002',
                                                                 0),
                                                                ('onePerMeter-0-0001',
                                                                 1),
                                                                ('onePerMeter-0-0005',
                                                                 2),
                                                                ('onePerMeter-0-002',
                                                                 3),
                                                                ('onePerMeter-0-01',
                                                                 4),
                                                                ('onePerMeter-0-1',
                                                                 5),
                                                                ('outOfRange',
                                                                 6),
                                                                ('unavailable',
                                                                 7)]},
                             'CurvatureValue': {'named-numbers': {'reciprocalOf1MeterRadiusToLeft': 30000,
                                                                  'reciprocalOf1MeterRadiusToRight': -30000,
                                                                  'straight': 0,
                                                                  'unavailable': 30001},
                                                'restricted-to': [(-30000,
                                                                   30001)],
                                                'type': 'INTEGER'},
                             'DangerousEndOfQueueSubCauseCode': {'named-numbers': {'queueAroundBend': 3,
                                                                                   'queueInTunnel': 4,
                                                                                   'queueOverHill': 2,
                                                                                   'suddenEndOfQueue': 1,
                                                                                   'unavailable': 0},
                                                                 'restricted-to': [(0,
                                                                                    255)],
                                                                 'type': 'INTEGER'},
                             'DangerousGoodsBasic': {'type': 'ENUMERATED',
                                                     'values': [('explosives1',
                                                                 0),
                                                                ('explosives2',
                                                                 1),
                                                                ('explosives3',
                                                                 2),
                                                                ('explosives4',
                                                                 3),
                                                                ('explosives5',
                                                                 4),
                                                                ('explosives6',
                                                                 5),
                                                                ('flammableGases',
                                                                 6),
                                                                ('nonFlammableGases',
                                                                 7),
                                                                ('toxicGases',
                                                                 8),
                                                                ('flammableLiquids',
                                                                 9),
                                                                ('flammableSolids',
                                                                 10),
                                                                ('substancesLiableToSpontaneousCombustion',
                                                                 11),
                                                                ('substancesEmittingFlammableGasesUponContactWithWater',
                                                                 12),
                                                                ('oxidizingSubstances',
                                                                 13),
                                                                ('organicPeroxides',
                                                                 14),
                                                                ('toxicSubstances',
                                                                 15),
                                                                ('infectiousSubstances',
                                                                 16),
                                                                ('radioactiveMaterial',
                                                                 17),
                                                                ('corrosiveSubstances',
                                                                 18),
                                                                ('miscellaneousDangerousSubstances',
                                                                 19)]},
                             'DangerousGoodsExtended': {'members': [{'name': 'dangerousGoodsType',
                                                                     'type': 'DangerousGoodsBasic'},
                                                                    {'name': 'unNumber',
                                                                     'restricted-to': [(0,
                                                                                        9999)],
                                                                     'type': 'INTEGER'},
                                                                    {'name': 'elevatedTemperature',
                                                                     'type': 'BOOLEAN'},
                                                                    {'name': 'tunnelsRestricted',
                                                                     'type': 'BOOLEAN'},
                                                                    {'name': 'limitedQuantity',
                                                                     'type': 'BOOLEAN'},
                                                                    {'name': 'emergencyActionCode',
                                                                     'optional': True,
                                                                     'size': [(1,
                                                                               24)],
                                                                     'type': 'IA5String'},
                                                                    {'name': 'phoneNumber',
                                                                     'optional': True,
                                                                     'size': [(1,
                                                                               24)],
                                                                     'type': 'IA5String'},
                                                                    {'name': 'companyName',
                                                                     'optional': True,
                                                                     'size': [(1,
                                                                               24)],
                                                                     'type': 'UTF8String'}],
                                                        'type': 'SEQUENCE'},
                             'DangerousSituationSubCauseCode': {'named-numbers': {'absEngaged': 4,
                                                                                  'aebEngaged': 5,
                                                                                  'brakeWarningEngaged': 6,
                                                                                  'collisionRiskWarningEngaged': 7,
                                                                                  'emergencyElectronicBrakeEngaged': 1,
                                                                                  'espEngaged': 3,
                                                                                  'preCrashSystemEngaged': 2,
                                                                                  'unavailable': 0},
                                                                'restricted-to': [(0,
                                                                                   255)],
                                                                'type': 'INTEGER'},
                             'DeltaAltitude': {'named-numbers': {'oneCentimeterDown': -1,
                                                                 'oneCentimeterUp': 1,
                                                                 'unavailable': 12800},
                                               'restricted-to': [(-12700,
                                                                  12800)],
                                               'type': 'INTEGER'},
                             'DeltaLatitude': {'named-numbers': {'oneMicrodegreeNorth': 10,
                                                                 'oneMicrodegreeSouth': -10,
                                                                 'unavailable': 131072},
                                               'restricted-to': [(-131071,
                                                                  131072)],
                                               'type': 'INTEGER'},
                             'DeltaLongitude': {'named-numbers': {'oneMicrodegreeEast': 10,
                                                                  'oneMicrodegreeWest': -10,
                                                                  'unavailable': 131072},
                                                'restricted-to': [(-131071,
                                                                   131072)],
                                                'type': 'INTEGER'},
                             'DeltaReferencePosition': {'members': [{'name': 'deltaLatitude',
                                                                     'type': 'DeltaLatitude'},
                                                                    {'name': 'deltaLongitude',
                                                                     'type': 'DeltaLongitude'},
                                                                    {'name': 'deltaAltitude',
                                                                     'type': 'DeltaAltitude'}],
                                                        'type': 'SEQUENCE'},
                             'DriveDirection': {'type': 'ENUMERATED',
                                                'values': [('forward', 0),
                                                           ('backward', 1),
                                                           ('unavailable', 2)]},
                             'DrivingLaneStatus': {'named-bits': [('outermostLaneClosed',
                                                                   '1'),
                                                                  ('secondLaneFromOutsideClosed',
                                                                   '2')],
                                                   'size': [(1, 14)],
                                                   'type': 'BIT STRING'},
                             'EmbarkationStatus': {'type': 'BOOLEAN'},
                             'EmergencyPriority': {'named-bits': [('requestForRightOfWay',
                                                                   '0'),
                                                                  ('requestForFreeCrossingAtATrafficLight',
                                                                   '1')],
                                                   'size': [2],
                                                   'type': 'BIT STRING'},
                             'EmergencyVehicleApproachingSubCauseCode': {'named-numbers': {'emergencyVehicleApproaching': 1,
                                                                                           'prioritizedVehicleApproaching': 2,
                                                                                           'unavailable': 0},
                                                                         'restricted-to': [(0,
                                                                                            255)],
                                                                         'type': 'INTEGER'},
                             'EnergyStorageType': {'named-bits': [('hydrogenStorage',
                                                                   '0'),
                                                                  ('electricEnergyStorage',
                                                                   '1'),
                                                                  ('liquidPropaneGas',
                                                                   '2'),
                                                                  ('compressedNaturalGas',
                                                                   '3'),
                                                                  ('diesel',
                                                                   '4'),
                                                                  ('gasoline',
                                                                   '5'),
                                                                  ('ammonia',
                                                                   '6')],
                                                   'size': [7],
                                                   'type': 'BIT STRING'},
                             'EventHistory': {'element': {'type': 'EventPoint'},
                                              'size': [(1, 23)],
                                              'type': 'SEQUENCE OF'},
                             'EventPoint': {'members': [{'name': 'eventPosition',
                                                         'type': 'DeltaReferencePosition'},
                                                        {'name': 'eventDeltaTime',
                                                         'optional': True,
                                                         'type': 'PathDeltaTime'},
                                                        {'name': 'informationQuality',
                                                         'type': 'InformationQuality'}],
                                            'type': 'SEQUENCE'},
                             'ExteriorLights': {'named-bits': [('lowBeamHeadlightsOn',
                                                                '0'),
                                                               ('highBeamHeadlightsOn',
                                                                '1'),
                                                               ('leftTurnSignalOn',
                                                                '2'),
                                                               ('rightTurnSignalOn',
                                                                '3'),
                                                               ('daytimeRunningLightsOn',
                                                                '4'),
                                                               ('reverseLightOn',
                                                                '5'),
                                                               ('fogLightOn',
                                                                '6'),
                                                               ('parkingLightsOn',
                                                                '7')],
                                                'size': [8],
                                                'type': 'BIT STRING'},
                             'HardShoulderStatus': {'type': 'ENUMERATED',
                                                    'values': [('availableForStopping',
                                                                0),
                                                               ('closed', 1),
                                                               ('availableForDriving',
                                                                2)]},
                             'HazardousLocation-AnimalOnTheRoadSubCauseCode': {'named-numbers': {'herdOfAnimals': 2,
                                                                                                 'largeAnimals': 4,
                                                                                                 'smallAnimals': 3,
                                                                                                 'unavailable': 0,
                                                                                                 'wildAnimals': 1},
                                                                               'restricted-to': [(0,
                                                                                                  255)],
                                                                               'type': 'INTEGER'},
                             'HazardousLocation-DangerousCurveSubCauseCode': {'named-numbers': {'dangerousLeftTurnCurve': 1,
                                                                                                'dangerousRightTurnCurve': 2,
                                                                                                'multipleCurvesStartingWithLeftTurn': 4,
                                                                                                'multipleCurvesStartingWithRightTurn': 5,
                                                                                                'multipleCurvesStartingWithUnknownTurningDirection': 3,
                                                                                                'unavailable': 0},
                                                                              'restricted-to': [(0,
                                                                                                 255)],
                                                                              'type': 'INTEGER'},
                             'HazardousLocation-ObstacleOnTheRoadSubCauseCode': {'named-numbers': {'bigObjects': 4,
                                                                                                   'fallenTrees': 5,
                                                                                                   'hubCaps': 6,
                                                                                                   'partsOfTyres': 3,
                                                                                                   'partsOfVehicles': 2,
                                                                                                   'shedLoad': 1,
                                                                                                   'unavailable': 0,
                                                                                                   'waitingVehicles': 7},
                                                                                 'restricted-to': [(0,
                                                                                                    255)],
                                                                                 'type': 'INTEGER'},
                             'HazardousLocation-SurfaceConditionSubCauseCode': {'named-numbers': {'burstPipe': 7,
                                                                                                  'earthquakeDamage': 2,
                                                                                                  'fallingIce': 9,
                                                                                                  'rockfalls': 1,
                                                                                                  'sewerCollapse': 3,
                                                                                                  'snowDrifts': 5,
                                                                                                  'stormDamage': 6,
                                                                                                  'subsidence': 4,
                                                                                                  'unavailable': 0,
                                                                                                  'volcanoEruption': 8},
                                                                                'restricted-to': [(0,
                                                                                                   255)],
                                                                                'type': 'INTEGER'},
                             'Heading': {'members': [{'name': 'headingValue',
                                                      'type': 'HeadingValue'},
                                                     {'name': 'headingConfidence',
                                                      'type': 'HeadingConfidence'}],
                                         'type': 'SEQUENCE'},
                             'HeadingConfidence': {'named-numbers': {'equalOrWithinOneDegree': 10,
                                                                     'equalOrWithinZeroPointOneDegree': 1,
                                                                     'outOfRange': 126,
                                                                     'unavailable': 127},
                                                   'restricted-to': [(1, 127)],
                                                   'type': 'INTEGER'},
                             'HeadingValue': {'named-numbers': {'unavailable': 3601,
                                                                'wgs84East': 900,
                                                                'wgs84North': 0,
                                                                'wgs84South': 1800,
                                                                'wgs84West': 2700},
                                              'restricted-to': [(0, 3601)],
                                              'type': 'INTEGER'},
                             'HeightLonCarr': {'named-numbers': {'oneCentimeter': 1,
                                                                 'unavailable': 100},
                                               'restricted-to': [(1, 100)],
                                               'type': 'INTEGER'},
                             'HumanPresenceOnTheRoadSubCauseCode': {'named-numbers': {'childrenOnRoadway': 1,
                                                                                      'cyclistOnRoadway': 2,
                                                                                      'motorcyclistOnRoadway': 3,
                                                                                      'unavailable': 0},
                                                                    'restricted-to': [(0,
                                                                                       255)],
                                                                    'type': 'INTEGER'},
                             'HumanProblemSubCauseCode': {'named-numbers': {'glycemiaProblem': 1,
                                                                            'heartProblem': 2,
                                                                            'unavailable': 0},
                                                          'restricted-to': [(0,
                                                                             255)],
                                                          'type': 'INTEGER'},
                             'InformationQuality': {'named-numbers': {'highest': 7,
                                                                      'lowest': 1,
                                                                      'unavailable': 0},
                                                    'restricted-to': [(0, 7)],
                                                    'type': 'INTEGER'},
                             'ItineraryPath': {'element': {'type': 'ReferencePosition'},
                                               'size': [(1, 40)],
                                               'type': 'SEQUENCE OF'},
                             'ItsPduHeader': {'members': [{'name': 'protocolVersion',
                                                           'named-numbers': {'currentVersion': 1},
                                                           'restricted-to': [(0,
                                                                              255)],
                                                           'type': 'INTEGER'},
                                                          {'name': 'messageID',
                                                           'named-numbers': {'cam': 2,
                                                                             'denm': 1,
                                                                             'ev-rsr': 7,
                                                                             'ivi': 6,
                                                                             'map': 5,
                                                                             'poi': 3,
                                                                             'spat': 4},
                                                           'restricted-to': [(0,
                                                                              255)],
                                                           'type': 'INTEGER'},
                                                          {'name': 'stationID',
                                                           'type': 'StationID'}],
                                              'type': 'SEQUENCE'},
                             'LanePosition': {'named-numbers': {'hardShoulder': 0,
                                                                'offTheRoad': -1,
                                                                'outermostDrivingLane': 1,
                                                                'secondLaneFromOutside': 2},
                                              'restricted-to': [(-1, 14)],
                                              'type': 'INTEGER'},
                             'LateralAcceleration': {'members': [{'name': 'lateralAccelerationValue',
                                                                  'type': 'LateralAccelerationValue'},
                                                                 {'name': 'lateralAccelerationConfidence',
                                                                  'type': 'AccelerationConfidence'}],
                                                     'type': 'SEQUENCE'},
                             'LateralAccelerationValue': {'named-numbers': {'pointOneMeterPerSecSquaredToLeft': 1,
                                                                            'pointOneMeterPerSecSquaredToRight': -1,
                                                                            'unavailable': 161},
                                                          'restricted-to': [(-160,
                                                                             161)],
                                                          'type': 'INTEGER'},
                             'Latitude': {'named-numbers': {'oneMicrodegreeNorth': 10,
                                                            'oneMicrodegreeSouth': -10,
                                                            'unavailable': 900000001},
                                          'restricted-to': [(-900000000,
                                                             900000001)],
                                          'type': 'INTEGER'},
                             'LightBarSirenInUse': {'named-bits': [('lightBarActivated',
                                                                    '0'),
                                                                   ('sirenActivated',
                                                                    '1')],
                                                    'size': [2],
                                                    'type': 'BIT STRING'},
                             'Longitude': {'named-numbers': {'oneMicrodegreeEast': 10,
                                                             'oneMicrodegreeWest': -10,
                                                             'unavailable': 1800000001},
                                           'restricted-to': [(-1800000000,
                                                              1800000001)],
                                           'type': 'INTEGER'},
                             'LongitudinalAcceleration': {'members': [{'name': 'longitudinalAccelerationValue',
                                                                       'type': 'LongitudinalAccelerationValue'},
                                                                      {'name': 'longitudinalAccelerationConfidence',
                                                                       'type': 'AccelerationConfidence'}],
                                                          'type': 'SEQUENCE'},
                             'LongitudinalAccelerationValue': {'named-numbers': {'pointOneMeterPerSecSquaredBackward': -1,
                                                                                 'pointOneMeterPerSecSquaredForward': 1,
                                                                                 'unavailable': 161},
                                                               'restricted-to': [(-160,
                                                                                  161)],
                                                               'type': 'INTEGER'},
                             'NumberOfOccupants': {'named-numbers': {'oneOccupant': 1,
                                                                     'unavailable': 127},
                                                   'restricted-to': [(0, 127)],
                                                   'type': 'INTEGER'},
                             'PathDeltaTime': {'named-numbers': {'tenMilliSecondsInPast': 1},
                                               'restricted-to': [(1, 65535),
                                                                 None],
                                               'type': 'INTEGER'},
                             'PathHistory': {'element': {'type': 'PathPoint'},
                                             'size': [(0, 40)],
                                             'type': 'SEQUENCE OF'},
                             'PathPoint': {'members': [{'name': 'pathPosition',
                                                        'type': 'DeltaReferencePosition'},
                                                       {'name': 'pathDeltaTime',
                                                        'optional': True,
                                                        'type': 'PathDeltaTime'}],
                                           'type': 'SEQUENCE'},
                             'PerformanceClass': {'named-numbers': {'performanceClassA': 1,
                                                                    'performanceClassB': 2,
                                                                    'unavailable': 0},
                                                  'restricted-to': [(0, 7)],
                                                  'type': 'INTEGER'},
                             'PosCentMass': {'named-numbers': {'tenCentimeters': 1,
                                                               'unavailable': 63},
                                             'restricted-to': [(1, 63)],
                                             'type': 'INTEGER'},
                             'PosConfidenceEllipse': {'members': [{'name': 'semiMajorConfidence',
                                                                   'type': 'SemiAxisLength'},
                                                                  {'name': 'semiMinorConfidence',
                                                                   'type': 'SemiAxisLength'},
                                                                  {'name': 'semiMajorOrientation',
                                                                   'type': 'HeadingValue'}],
                                                      'type': 'SEQUENCE'},
                             'PosFrontAx': {'named-numbers': {'tenCentimeters': 1,
                                                              'unavailable': 20},
                                            'restricted-to': [(1, 20)],
                                            'type': 'INTEGER'},
                             'PosLonCarr': {'named-numbers': {'oneCentimeter': 1,
                                                              'unavailable': 127},
                                            'restricted-to': [(1, 127)],
                                            'type': 'INTEGER'},
                             'PosPillar': {'named-numbers': {'tenCentimeters': 1,
                                                             'unavailable': 30},
                                           'restricted-to': [(1, 30)],
                                           'type': 'INTEGER'},
                             'PositionOfOccupants': {'named-bits': [('row1LeftOccupied',
                                                                     '0'),
                                                                    ('row1RightOccupied',
                                                                     '1'),
                                                                    ('row1MidOccupied',
                                                                     '2'),
                                                                    ('row1NotDetectable',
                                                                     '3'),
                                                                    ('row1NotPresent',
                                                                     '4'),
                                                                    ('row2LeftOccupied',
                                                                     '5'),
                                                                    ('row2RightOccupied',
                                                                     '6'),
                                                                    ('row2MidOccupied',
                                                                     '7'),
                                                                    ('row2NotDetectable',
                                                                     '8'),
                                                                    ('row2NotPresent',
                                                                     '9'),
                                                                    ('row3LeftOccupied',
                                                                     '10'),
                                                                    ('row3RightOccupied',
                                                                     '11'),
                                                                    ('row3MidOccupied',
                                                                     '12'),
                                                                    ('row3NotDetectable',
                                                                     '13'),
                                                                    ('row3NotPresent',
                                                                     '14'),
                                                                    ('row4LeftOccupied',
                                                                     '15'),
                                                                    ('row4RightOccupied',
                                                                     '16'),
                                                                    ('row4MidOccupied',
                                                                     '17'),
                                                                    ('row4NotDetectable',
                                                                     '18'),
                                                                    ('row4NotPresent',
                                                                     '19')],
                                                     'size': [20],
                                                     'type': 'BIT STRING'},
                             'PositionOfPillars': {'element': {'type': 'PosPillar'},
                                                   'size': [(1, 3), None],
                                                   'type': 'SEQUENCE OF'},
                             'PositioningSolutionType': {'type': 'ENUMERATED',
                                                         'values': [('noPositioningSolution',
                                                                     0),
                                                                    ('sGNSS',
                                                                     1),
                                                                    ('dGNSS',
                                                                     2),
                                                                    ('sGNSSplusDR',
                                                                     3),
                                                                    ('dGNSSplusDR',
                                                                     4),
                                                                    ('dR', 5),
                                                                    None]},
                             'PostCrashSubCauseCode': {'named-numbers': {'accidentWithECallAutomaticallyTriggered': 3,
                                                                         'accidentWithECallManuallyTriggered': 2,
                                                                         'accidentWithECallTriggeredWithoutAccessToCellularNetwork': 4,
                                                                         'accidentWithoutECallTriggered': 1,
                                                                         'unavailable': 0},
                                                       'restricted-to': [(0,
                                                                          255)],
                                                       'type': 'INTEGER'},
                             'ProtectedCommunicationZone': {'members': [{'name': 'protectedZoneType',
                                                                         'type': 'ProtectedZoneType'},
                                                                        {'name': 'expiryTime',
                                                                         'optional': True,
                                                                         'type': 'TimestampIts'},
                                                                        {'name': 'protectedZoneLatitude',
                                                                         'type': 'Latitude'},
                                                                        {'name': 'protectedZoneLongitude',
                                                                         'type': 'Longitude'},
                                                                        {'name': 'protectedZoneRadius',
                                                                         'optional': True,
                                                                         'type': 'ProtectedZoneRadius'},
                                                                        {'name': 'protectedZoneID',
                                                                         'optional': True,
                                                                         'type': 'ProtectedZoneID'}],
                                                            'type': 'SEQUENCE'},
                             'ProtectedCommunicationZonesRSU': {'element': {'type': 'ProtectedCommunicationZone'},
                                                                'size': [(1,
                                                                          16)],
                                                                'type': 'SEQUENCE '
                                                                        'OF'},
                             'ProtectedZoneID': {'restricted-to': [(0,
                                                                    134217727)],
                                                 'type': 'INTEGER'},
                             'ProtectedZoneRadius': {'named-numbers': {'oneMeter': 1},
                                                     'restricted-to': [(1, 255),
                                                                       None],
                                                     'type': 'INTEGER'},
                             'ProtectedZoneType': {'type': 'ENUMERATED',
                                                   'values': [('cenDsrcTolling',
                                                               0),
                                                              None]},
                             'PtActivation': {'members': [{'name': 'ptActivationType',
                                                           'type': 'PtActivationType'},
                                                          {'name': 'ptActivationData',
                                                           'type': 'PtActivationData'}],
                                              'type': 'SEQUENCE'},
                             'PtActivationData': {'size': [(1, 20)],
                                                  'type': 'OCTET STRING'},
                             'PtActivationType': {'named-numbers': {'r09-16CodingType': 1,
                                                                    'undefinedCodingType': 0,
                                                                    'vdv-50149CodingType': 2},
                                                  'restricted-to': [(0, 255)],
                                                  'type': 'INTEGER'},
                             'ReferencePosition': {'members': [{'name': 'latitude',
                                                                'type': 'Latitude'},
                                                               {'name': 'longitude',
                                                                'type': 'Longitude'},
                                                               {'name': 'positionConfidenceEllipse',
                                                                'type': 'PosConfidenceEllipse'},
                                                               {'name': 'altitude',
                                                                'type': 'Altitude'}],
                                                   'type': 'SEQUENCE'},
                             'RelevanceDistance': {'type': 'ENUMERATED',
                                                   'values': [('lessThan50m',
                                                               0),
                                                              ('lessThan100m',
                                                               1),
                                                              ('lessThan200m',
                                                               2),
                                                              ('lessThan500m',
                                                               3),
                                                              ('lessThan1000m',
                                                               4),
                                                              ('lessThan5km',
                                                               5),
                                                              ('lessThan10km',
                                                               6),
                                                              ('over10km', 7)]},
                             'RelevanceTrafficDirection': {'type': 'ENUMERATED',
                                                           'values': [('allTrafficDirections',
                                                                       0),
                                                                      ('upstreamTraffic',
                                                                       1),
                                                                      ('downstreamTraffic',
                                                                       2),
                                                                      ('oppositeTraffic',
                                                                       3)]},
                             'RequestResponseIndication': {'type': 'ENUMERATED',
                                                           'values': [('request',
                                                                       0),
                                                                      ('response',
                                                                       1)]},
                             'RescueAndRecoveryWorkInProgressSubCauseCode': {'named-numbers': {'childAbductionInProgress': 5,
                                                                                               'emergencyVehicles': 1,
                                                                                               'medicalEmergencyOngoing': 4,
                                                                                               'policeActivityOngoing': 3,
                                                                                               'rescueHelicopterLanding': 2,
                                                                                               'unavailable': 0},
                                                                             'restricted-to': [(0,
                                                                                                255)],
                                                                             'type': 'INTEGER'},
                             'RestrictedTypes': {'element': {'type': 'StationType'},
                                                 'size': [(1, 3), None],
                                                 'type': 'SEQUENCE OF'},
                             'RoadType': {'type': 'ENUMERATED',
                                          'values': [('urban-NoStructuralSeparationToOppositeLanes',
                                                      0),
                                                     ('urban-WithStructuralSeparationToOppositeLanes',
                                                      1),
                                                     ('nonUrban-NoStructuralSeparationToOppositeLanes',
                                                      2),
                                                     ('nonUrban-WithStructuralSeparationToOppositeLanes',
                                                      3)]},
                             'RoadworksSubCauseCode': {'named-numbers': {'majorRoadworks': 1,
                                                                         'roadMarkingWork': 2,
                                                                         'shortTermStationaryRoadworks': 4,
                                                                         'slowMovingRoadMaintenance': 3,
                                                                         'streetCleaning': 5,
                                                                         'unavailable': 0,
                                                                         'winterService': 6},
                                                       'restricted-to': [(0,
                                                                          255)],
                                                       'type': 'INTEGER'},
                             'SemiAxisLength': {'named-numbers': {'oneCentimeter': 1,
                                                                  'outOfRange': 4094,
                                                                  'unavailable': 4095},
                                                'restricted-to': [(0, 4095)],
                                                'type': 'INTEGER'},
                             'SequenceNumber': {'restricted-to': [(0, 65535)],
                                                'type': 'INTEGER'},
                             'SignalViolationSubCauseCode': {'named-numbers': {'stopSignViolation': 1,
                                                                               'trafficLightViolation': 2,
                                                                               'turningRegulationViolation': 3,
                                                                               'unavailable': 0},
                                                             'restricted-to': [(0,
                                                                                255)],
                                                             'type': 'INTEGER'},
                             'SlowVehicleSubCauseCode': {'named-numbers': {'abnormalLoad': 3,
                                                                           'abnormalWideLoad': 4,
                                                                           'convoy': 5,
                                                                           'deicing': 7,
                                                                           'maintenanceVehicle': 1,
                                                                           'saltingVehicles': 8,
                                                                           'snowplough': 6,
                                                                           'unavailable': 0,
                                                                           'vehiclesSlowingToLookAtAccident': 2},
                                                         'restricted-to': [(0,
                                                                            255)],
                                                         'type': 'INTEGER'},
                             'SpecialTransportType': {'named-bits': [('heavyLoad',
                                                                      '0'),
                                                                     ('excessWidth',
                                                                      '1'),
                                                                     ('excessLength',
                                                                      '2'),
                                                                     ('excessHeight',
                                                                      '3')],
                                                      'size': [4],
                                                      'type': 'BIT STRING'},
                             'Speed': {'members': [{'name': 'speedValue',
                                                    'type': 'SpeedValue'},
                                                   {'name': 'speedConfidence',
                                                    'type': 'SpeedConfidence'}],
                                       'type': 'SEQUENCE'},
                             'SpeedConfidence': {'named-numbers': {'equalOrWithinOneCentimeterPerSec': 1,
                                                                   'equalOrWithinOneMeterPerSec': 100,
                                                                   'outOfRange': 126,
                                                                   'unavailable': 127},
                                                 'restricted-to': [(1, 127)],
                                                 'type': 'INTEGER'},
                             'SpeedLimit': {'named-numbers': {'oneKmPerHour': 1},
                                            'restricted-to': [(1, 255)],
                                            'type': 'INTEGER'},
                             'SpeedValue': {'named-numbers': {'oneCentimeterPerSec': 1,
                                                              'standstill': 0,
                                                              'unavailable': 16383},
                                            'restricted-to': [(0, 16383)],
                                            'type': 'INTEGER'},
                             'StationID': {'restricted-to': [(0, 4294967295)],
                                           'type': 'INTEGER'},
                             'StationType': {'named-numbers': {'bus': 6,
                                                               'cyclist': 2,
                                                               'heavyTruck': 8,
                                                               'lightTruck': 7,
                                                               'moped': 3,
                                                               'motorcycle': 4,
                                                               'passengerCar': 5,
                                                               'pedestrian': 1,
                                                               'roadSideUnit': 15,
                                                               'specialVehicles': 10,
                                                               'trailer': 9,
                                                               'tram': 11,
                                                               'unknown': 0},
                                             'restricted-to': [(0, 255)],
                                             'type': 'INTEGER'},
                             'StationarySince': {'type': 'ENUMERATED',
                                                 'values': [('lessThan1Minute',
                                                             0),
                                                            ('lessThan2Minutes',
                                                             1),
                                                            ('lessThan15Minutes',
                                                             2),
                                                            ('equalOrGreater15Minutes',
                                                             3)]},
                             'StationaryVehicleSubCauseCode': {'named-numbers': {'carryingDangerousGoods': 5,
                                                                                 'humanProblem': 1,
                                                                                 'postCrash': 3,
                                                                                 'publicTransportStop': 4,
                                                                                 'unavailable': 0,
                                                                                 'vehicleBreakdown': 2},
                                                               'restricted-to': [(0,
                                                                                  255)],
                                                               'type': 'INTEGER'},
                             'SteeringWheelAngle': {'members': [{'name': 'steeringWheelAngleValue',
                                                                 'type': 'SteeringWheelAngleValue'},
                                                                {'name': 'steeringWheelAngleConfidence',
                                                                 'type': 'SteeringWheelAngleConfidence'}],
                                                    'type': 'SEQUENCE'},
                             'SteeringWheelAngleConfidence': {'named-numbers': {'equalOrWithinOnePointFiveDegree': 1,
                                                                                'outOfRange': 126,
                                                                                'unavailable': 127},
                                                              'restricted-to': [(1,
                                                                                 127)],
                                                              'type': 'INTEGER'},
                             'SteeringWheelAngleValue': {'named-numbers': {'onePointFiveDegreesToLeft': 1,
                                                                           'onePointFiveDegreesToRight': -1,
                                                                           'straight': 0,
                                                                           'unavailable': 512},
                                                         'restricted-to': [(-511,
                                                                            512)],
                                                         'type': 'INTEGER'},
                             'SubCauseCodeType': {'restricted-to': [(0, 255)],
                                                  'type': 'INTEGER'},
                             'Temperature': {'named-numbers': {'equalOrGreaterThan67Deg': 67,
                                                               'equalOrSmallerThanMinus60Deg': -60,
                                                               'oneDegreeCelsius': 1},
                                             'restricted-to': [(-60, 67)],
                                             'type': 'INTEGER'},
                             'TimestampIts': {'named-numbers': {'oneMillisecAfterUTCStartOf2004': 1,
                                                                'utcStartOf2004': 0},
                                              'restricted-to': [(0,
                                                                 4398046511103)],
                                              'type': 'INTEGER'},
                             'Traces': {'element': {'type': 'PathHistory'},
                                        'size': [(1, 7)],
                                        'type': 'SEQUENCE OF'},
                             'TrafficConditionSubCauseCode': {'named-numbers': {'increasedVolumeOfTraffic': 1,
                                                                                'trafficJamDecreasing': 7,
                                                                                'trafficJamIncreasing': 3,
                                                                                'trafficJamSlightlyDecreasing': 6,
                                                                                'trafficJamSlowlyIncreasing': 2,
                                                                                'trafficJamStronglyDecreasing': 8,
                                                                                'trafficJamStronglyIncreasing': 4,
                                                                                'trafficStationary': 5,
                                                                                'unavailable': 0},
                                                              'restricted-to': [(0,
                                                                                 255)],
                                                              'type': 'INTEGER'},
                             'TrafficRule': {'type': 'ENUMERATED',
                                             'values': [('noPassing', 0),
                                                        ('noPassingForTrucks',
                                                         1),
                                                        ('passToRight', 2),
                                                        ('passToLeft', 3),
                                                        None]},
                             'TransmissionInterval': {'named-numbers': {'oneMilliSecond': 1,
                                                                        'tenSeconds': 10000},
                                                      'restricted-to': [(1,
                                                                         10000)],
                                                      'type': 'INTEGER'},
                             'TurningRadius': {'named-numbers': {'point4Meters': 1,
                                                                 'unavailable': 255},
                                               'restricted-to': [(1, 255)],
                                               'type': 'INTEGER'},
                             'VDS': {'size': [6], 'type': 'IA5String'},
                             'ValidityDuration': {'named-numbers': {'oneSecondAfterDetection': 1,
                                                                    'timeOfDetection': 0},
                                                  'restricted-to': [(0, 86400)],
                                                  'type': 'INTEGER'},
                             'VehicleBreakdownSubCauseCode': {'named-numbers': {'brakingSystemProblem': 6,
                                                                                'engineCoolingProblem': 5,
                                                                                'engineProblem': 3,
                                                                                'lackOfBatteryPower': 2,
                                                                                'lackOfFuel': 1,
                                                                                'steeringProblem': 7,
                                                                                'transmissionProblem': 4,
                                                                                'tyrePuncture': 8,
                                                                                'unavailable': 0},
                                                              'restricted-to': [(0,
                                                                                 255)],
                                                              'type': 'INTEGER'},
                             'VehicleIdentification': {'members': [{'name': 'wMInumber',
                                                                    'optional': True,
                                                                    'type': 'WMInumber'},
                                                                   {'name': 'vDS',
                                                                    'optional': True,
                                                                    'type': 'VDS'},
                                                                   None],
                                                       'type': 'SEQUENCE'},
                             'VehicleLength': {'members': [{'name': 'vehicleLengthValue',
                                                            'type': 'VehicleLengthValue'},
                                                           {'name': 'vehicleLengthConfidenceIndication',
                                                            'type': 'VehicleLengthConfidenceIndication'}],
                                               'type': 'SEQUENCE'},
                             'VehicleLengthConfidenceIndication': {'type': 'ENUMERATED',
                                                                   'values': [('noTrailerPresent',
                                                                               0),
                                                                              ('trailerPresentWithKnownLength',
                                                                               1),
                                                                              ('trailerPresentWithUnknownLength',
                                                                               2),
                                                                              ('trailerPresenceIsUnknown',
                                                                               3),
                                                                              ('unavailable',
                                                                               4)]},
                             'VehicleLengthValue': {'named-numbers': {'outOfRange': 1022,
                                                                      'tenCentimeters': 1,
                                                                      'unavailable': 1023},
                                                    'restricted-to': [(1,
                                                                       1023)],
                                                    'type': 'INTEGER'},
                             'VehicleMass': {'named-numbers': {'hundredKg': 1,
                                                               'unavailable': 1024},
                                             'restricted-to': [(1, 1024)],
                                             'type': 'INTEGER'},
                             'VehicleRole': {'type': 'ENUMERATED',
                                             'values': [('default', 0),
                                                        ('publicTransport', 1),
                                                        ('specialTransport', 2),
                                                        ('dangerousGoods', 3),
                                                        ('roadWork', 4),
                                                        ('rescue', 5),
                                                        ('emergency', 6),
                                                        ('safetyCar', 7),
                                                        ('agriculture', 8),
                                                        ('commercial', 9),
                                                        ('military', 10),
                                                        ('roadOperator', 11),
                                                        ('taxi', 12),
                                                        ('reserved1', 13),
                                                        ('reserved2', 14),
                                                        ('reserved3', 15)]},
                             'VehicleWidth': {'named-numbers': {'outOfRange': 61,
                                                                'tenCentimeters': 1,
                                                                'unavailable': 62},
                                              'restricted-to': [(1, 62)],
                                              'type': 'INTEGER'},
                             'VerticalAcceleration': {'members': [{'name': 'verticalAccelerationValue',
                                                                   'type': 'VerticalAccelerationValue'},
                                                                  {'name': 'verticalAccelerationConfidence',
                                                                   'type': 'AccelerationConfidence'}],
                                                      'type': 'SEQUENCE'},
                             'VerticalAccelerationValue': {'named-numbers': {'pointOneMeterPerSecSquaredDown': -1,
                                                                             'pointOneMeterPerSecSquaredUp': 1,
                                                                             'unavailable': 161},
                                                           'restricted-to': [(-160,
                                                                              161)],
                                                           'type': 'INTEGER'},
                             'WMInumber': {'size': [(1, 3)],
                                           'type': 'IA5String'},
                             'WheelBaseVehicle': {'named-numbers': {'tenCentimeters': 1,
                                                                    'unavailable': 127},
                                                  'restricted-to': [(1, 127)],
                                                  'type': 'INTEGER'},
                             'WrongWayDrivingSubCauseCode': {'named-numbers': {'unavailable': 0,
                                                                               'wrongDirection': 2,
                                                                               'wrongLane': 1},
                                                             'restricted-to': [(0,
                                                                                255)],
                                                             'type': 'INTEGER'},
                             'YawRate': {'members': [{'name': 'yawRateValue',
                                                      'type': 'YawRateValue'},
                                                     {'name': 'yawRateConfidence',
                                                      'type': 'YawRateConfidence'}],
                                         'type': 'SEQUENCE'},
                             'YawRateConfidence': {'type': 'ENUMERATED',
                                                   'values': [('degSec-000-01',
                                                               0),
                                                              ('degSec-000-05',
                                                               1),
                                                              ('degSec-000-10',
                                                               2),
                                                              ('degSec-001-00',
                                                               3),
                                                              ('degSec-005-00',
                                                               4),
                                                              ('degSec-010-00',
                                                               5),
                                                              ('degSec-100-00',
                                                               6),
                                                              ('outOfRange', 7),
                                                              ('unavailable',
                                                               8)]},
                             'YawRateValue': {'named-numbers': {'degSec-000-01ToLeft': 1,
                                                                'degSec-000-01ToRight': -1,
                                                                'straight': 0,
                                                                'unavailable': 32767},
                                              'restricted-to': [(-32766,
                                                                 32767)],
                                              'type': 'INTEGER'}},
                   'values': {}}}