#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Syberia: The World Before
# send your bug reports to contact@dotslashplay.it
###

script_version=20241208.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='syberia-the-world-before'
GAME_NAME='Syberia: The World Before'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

GAME_ID_PROLOGUE="${GAME_ID}-prologue"
GAME_NAME_PROLOGUE="$GAME_NAME - Prologue"

ARCHIVE_BASE_DEMO_0_NAME='setup_syberia_the_world_before_demo_1.2.1.40425_(64bit)_(56894).exe'
ARCHIVE_BASE_DEMO_0_MD5='eaa885fbdf3bd94188420dbffd7469ec'
ARCHIVE_BASE_DEMO_0_TYPE='innosetup'
ARCHIVE_BASE_DEMO_0_PART1_NAME='setup_syberia_the_world_before_demo_1.2.1.40425_(64bit)_(56894)-1.bin'
ARCHIVE_BASE_DEMO_0_PART1_MD5='cbf1ab7ffd1781e5b4ac1c81d5878827'
ARCHIVE_BASE_DEMO_0_PART2_NAME='setup_syberia_the_world_before_demo_1.2.1.40425_(64bit)_(56894)-2.bin'
ARCHIVE_BASE_DEMO_0_PART2_MD5='8dcfad00a0bd9a1f317c9802f2392ac8'
ARCHIVE_BASE_DEMO_0_SIZE='6754521'
ARCHIVE_BASE_DEMO_0_VERSION='1.2.1.40425-gog56894'
ARCHIVE_BASE_DEMO_0_URL='https://www.gog.com/game/syberia_the_world_before_demo'

ARCHIVE_BASE_PROLOGUE_0_NAME='setup_syberia_the_world_before_prologue_1.0_(43455).exe'
ARCHIVE_BASE_PROLOGUE_0_MD5='22bd7e18e7cd06ddfbe94d262cef6cd9'
ARCHIVE_BASE_PROLOGUE_0_TYPE='innosetup'
ARCHIVE_BASE_PROLOGUE_0_PART1_NAME='setup_syberia_the_world_before_prologue_1.0_(43455)-1.bin'
ARCHIVE_BASE_PROLOGUE_0_PART1_MD5='153581ebbcce0a4608c7b700e9f1093c'
ARCHIVE_BASE_PROLOGUE_0_SIZE='3400000'
ARCHIVE_BASE_PROLOGUE_0_VERSION='1.0-gog43455'

UNITY3D_NAME='syberiatwb'
UNITY3D_NAME_PROLOGUE='syberiatwbp'

CONTENT_PATH_DEFAULT='.'

WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/SyberiaTWB'
WINE_PERSISTENT_DIRECTORIES_PROLOGUE='
users/${USER}/AppData/Roaming/SyberiaTWBP'

USER_PERSISTENT_FILES="
${UNITY3D_NAME}_data/streamingassets/config.bin"
USER_PERSISTENT_FILES_PROLOGUE="
${UNITY3D_NAME_PROLOGUE}_data/streamingassets/config.bin"

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_ID_PROLOGUE="${GAME_ID_PROLOGUE}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
