/*
 This file is part of TALER
 (C) 2016 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
System.register([], function (exports_1, context_1) {
    "use strict";
    var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments)).next());
        });
    };
    var __moduleName = context_1 && context_1.id;
    /**
     * Interface to the wallet through WebExtension messaging.
     * @author Florian Dold
     */
    function getReserveCreationInfo(baseUrl, amount) {
        let m = { type: "reserve-creation-info", detail: { baseUrl, amount } };
        return new Promise((resolve, reject) => {
            chrome.runtime.sendMessage(m, (resp) => {
                if (resp.error) {
                    console.error("error response", resp);
                    let e = Error("call to reserve-creation-info failed");
                    e.errorResponse = resp;
                    reject(e);
                    return;
                }
                resolve(resp);
            });
        });
    }
    exports_1("getReserveCreationInfo", getReserveCreationInfo);
    function callBackend(type, detail) {
        return __awaiter(this, void 0, void 0, function* () {
            return new Promise((resolve, reject) => {
                chrome.runtime.sendMessage({ type, detail }, (resp) => {
                    resolve(resp);
                });
            });
        });
    }
    exports_1("callBackend", callBackend);
    function getExchanges() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield callBackend("get-exchanges");
        });
    }
    exports_1("getExchanges", getExchanges);
    function getReserves(exchangeBaseUrl) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield callBackend("get-reserves", { exchangeBaseUrl });
        });
    }
    exports_1("getReserves", getReserves);
    function getCoins(exchangeBaseUrl) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield callBackend("get-coins", { exchangeBaseUrl });
        });
    }
    exports_1("getCoins", getCoins);
    function getPreCoins(exchangeBaseUrl) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield callBackend("get-precoins", { exchangeBaseUrl });
        });
    }
    exports_1("getPreCoins", getPreCoins);
    function getDenoms(exchangeBaseUrl) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield callBackend("get-denoms", { exchangeBaseUrl });
        });
    }
    exports_1("getDenoms", getDenoms);
    function refresh(coinPub) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield callBackend("refresh-coin", { coinPub });
        });
    }
    exports_1("refresh", refresh);
    return {
        setters: [],
        execute: function () {/*
             This file is part of TALER
             (C) 2016 GNUnet e.V.
            
             TALER is free software; you can redistribute it and/or modify it under the
             terms of the GNU General Public License as published by the Free Software
             Foundation; either version 3, or (at your option) any later version.
            
             TALER is distributed in the hope that it will be useful, but WITHOUT ANY
             WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
             A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
            
             You should have received a copy of the GNU General Public License along with
             TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
             */
        }
    };
});
//# sourceMappingURL=wxApi.js.map