System.register(["testlib/talertest", "./types", "./wallet"], function (exports_1, context_1) {
    "use strict";
    var __moduleName = context_1 && context_1.id;
    var talertest_1, types_1, wallet;
    return {
        setters: [
            function (talertest_1_1) {
                talertest_1 = talertest_1_1;
            },
            function (types_1_1) {
                types_1 = types_1_1;
            },
            function (wallet_1) {
                wallet = wallet_1;
            }
        ],
        execute: function () {
            talertest_1.test("coin selection 1", (t) => {
                let cds = [];
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 5, "EUR"),
                    },
                });
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 0, "EUR"),
                    },
                });
                let res = wallet.selectCoins(cds, types_1.mkAmount(2, 0, "EUR"), types_1.mkAmount(0, 5, "EUR"));
                if (!res) {
                    t.fail();
                    return;
                }
                t.assert(res.length == 2);
                t.pass();
            });
            talertest_1.test("coin selection 2", (t) => {
                let cds = [];
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 5, "EUR"),
                    },
                });
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 0, "EUR"),
                    },
                });
                // Merchant covers the fee, this one shouldn't be used
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 0, "EUR"),
                    },
                });
                let res = wallet.selectCoins(cds, types_1.mkAmount(2, 0, "EUR"), types_1.mkAmount(0, 5, "EUR"));
                if (!res) {
                    t.fail();
                    return;
                }
                t.assert(res.length == 2);
                t.pass();
            });
            talertest_1.test("coin selection 2", (t) => {
                let cds = [];
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 5, "EUR"),
                    },
                });
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 0, "EUR"),
                    },
                });
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 0, "EUR"),
                    },
                });
                let res = wallet.selectCoins(cds, types_1.mkAmount(2, 0, "EUR"), types_1.mkAmount(0, 2, "EUR"));
                if (!res) {
                    t.fail();
                    return;
                }
                t.assert(res.length == 2);
                t.pass();
            });
            talertest_1.test("coin selection 3", (t) => {
                let cds = [];
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 5, "EUR"),
                    },
                });
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 0, "EUR"),
                    },
                });
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 5, "EUR"),
                    },
                });
                let res = wallet.selectCoins(cds, types_1.mkAmount(2, 0, "EUR"), types_1.mkAmount(0, 2, "EUR"));
                if (!res) {
                    t.fail();
                    return;
                }
                t.assert(res.length == 3);
                t.pass();
            });
            talertest_1.test("coin selection 3", (t) => {
                let cds = [];
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 5, "EUR"),
                    },
                });
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 0, "EUR"),
                    },
                });
                cds.push({
                    coin: {
                        currentAmount: types_1.mkAmount(1, 0, "EUR"),
                    },
                    denom: {
                        value: types_1.mkAmount(1, 0, "EUR"),
                        fee_deposit: types_1.mkAmount(0, 5, "EUR"),
                    },
                });
                let res = wallet.selectCoins(cds, types_1.mkAmount(4, 0, "EUR"), types_1.mkAmount(0, 2, "EUR"));
                t.assert(!res);
                t.pass();
            });
        }
    };
});
//# sourceMappingURL=wallet-test.js.map