/*
 This file is part of TALER
 (C) 2015 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
System.register(["./checkable"], function (exports_1, context_1) {
    "use strict";
    var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
        var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
        if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
        else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
        return c > 3 && r && Object.defineProperty(target, key, r), r;
    };
    var __moduleName = context_1 && context_1.id;
    function denominationRecordFromKeys(exchangeBaseUrl, denomIn) {
        let d = {
            denomPub: denomIn.denom_pub,
            exchangeBaseUrl: exchangeBaseUrl,
            feeDeposit: denomIn.fee_deposit,
            masterSig: denomIn.master_sig,
            feeRefund: denomIn.fee_refund,
            feeRefresh: denomIn.fee_refresh,
            feeWithdraw: denomIn.fee_withdraw,
            stampExpireDeposit: denomIn.stamp_expire_deposit,
            stampExpireLegal: denomIn.stamp_expire_legal,
            stampExpireWithdraw: denomIn.stamp_expire_withdraw,
            stampStart: denomIn.stamp_start,
            status: DenominationStatus.Unverified,
            isOffered: true,
            value: denomIn.value,
        };
        return d;
    }
    exports_1("denominationRecordFromKeys", denominationRecordFromKeys);
    /**
     * For terseness.
     */
    function mkAmount(value, fraction, currency) {
        return { value, fraction, currency };
    }
    exports_1("mkAmount", mkAmount);
    var checkable_1, AmountJson, CreateReserveResponse, DenominationStatus, DenominationRecord, Denomination, ExchangeHandle, Contract, Amounts;
    return {
        setters: [
            function (checkable_1_1) {
                checkable_1 = checkable_1_1;
            }
        ],
        execute: function () {/*
             This file is part of TALER
             (C) 2015 GNUnet e.V.
            
             TALER is free software; you can redistribute it and/or modify it under the
             terms of the GNU General Public License as published by the Free Software
             Foundation; either version 3, or (at your option) any later version.
            
             TALER is distributed in the hope that it will be useful, but WITHOUT ANY
             WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
             A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
            
             You should have received a copy of the GNU General Public License along with
             TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
             */
            AmountJson = class AmountJson {
            };
            __decorate([
                checkable_1.Checkable.Number
            ], AmountJson.prototype, "value", void 0);
            __decorate([
                checkable_1.Checkable.Number
            ], AmountJson.prototype, "fraction", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], AmountJson.prototype, "currency", void 0);
            AmountJson = __decorate([
                checkable_1.Checkable.Class
            ], AmountJson);
            exports_1("AmountJson", AmountJson);
            CreateReserveResponse = class CreateReserveResponse {
            };
            __decorate([
                checkable_1.Checkable.String
            ], CreateReserveResponse.prototype, "exchange", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], CreateReserveResponse.prototype, "reservePub", void 0);
            CreateReserveResponse = __decorate([
                checkable_1.Checkable.Class
            ], CreateReserveResponse);
            exports_1("CreateReserveResponse", CreateReserveResponse);
            (function (DenominationStatus) {
                DenominationStatus[DenominationStatus["Unverified"] = 0] = "Unverified";
                DenominationStatus[DenominationStatus["VerifiedGood"] = 1] = "VerifiedGood";
                DenominationStatus[DenominationStatus["VerifiedBad"] = 2] = "VerifiedBad";
            })(DenominationStatus || (DenominationStatus = {}));
            exports_1("DenominationStatus", DenominationStatus);
            DenominationRecord = class DenominationRecord {
            };
            __decorate([
                checkable_1.Checkable.Value(AmountJson)
            ], DenominationRecord.prototype, "value", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], DenominationRecord.prototype, "denomPub", void 0);
            __decorate([
                checkable_1.Checkable.Value(AmountJson)
            ], DenominationRecord.prototype, "feeWithdraw", void 0);
            __decorate([
                checkable_1.Checkable.Value(AmountJson)
            ], DenominationRecord.prototype, "feeDeposit", void 0);
            __decorate([
                checkable_1.Checkable.Value(AmountJson)
            ], DenominationRecord.prototype, "feeRefresh", void 0);
            __decorate([
                checkable_1.Checkable.Value(AmountJson)
            ], DenominationRecord.prototype, "feeRefund", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], DenominationRecord.prototype, "stampStart", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], DenominationRecord.prototype, "stampExpireWithdraw", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], DenominationRecord.prototype, "stampExpireLegal", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], DenominationRecord.prototype, "stampExpireDeposit", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], DenominationRecord.prototype, "masterSig", void 0);
            __decorate([
                checkable_1.Checkable.Number
            ], DenominationRecord.prototype, "status", void 0);
            __decorate([
                checkable_1.Checkable.Boolean
            ], DenominationRecord.prototype, "isOffered", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], DenominationRecord.prototype, "exchangeBaseUrl", void 0);
            exports_1("DenominationRecord", DenominationRecord);
            Denomination = class Denomination {
            };
            __decorate([
                checkable_1.Checkable.Value(AmountJson)
            ], Denomination.prototype, "value", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], Denomination.prototype, "denom_pub", void 0);
            __decorate([
                checkable_1.Checkable.Value(AmountJson)
            ], Denomination.prototype, "fee_withdraw", void 0);
            __decorate([
                checkable_1.Checkable.Value(AmountJson)
            ], Denomination.prototype, "fee_deposit", void 0);
            __decorate([
                checkable_1.Checkable.Value(AmountJson)
            ], Denomination.prototype, "fee_refresh", void 0);
            __decorate([
                checkable_1.Checkable.Value(AmountJson)
            ], Denomination.prototype, "fee_refund", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], Denomination.prototype, "stamp_start", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], Denomination.prototype, "stamp_expire_withdraw", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], Denomination.prototype, "stamp_expire_legal", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], Denomination.prototype, "stamp_expire_deposit", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], Denomination.prototype, "master_sig", void 0);
            Denomination = __decorate([
                checkable_1.Checkable.Class
            ], Denomination);
            exports_1("Denomination", Denomination);
            ExchangeHandle = class ExchangeHandle {
            };
            __decorate([
                checkable_1.Checkable.String
            ], ExchangeHandle.prototype, "master_pub", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], ExchangeHandle.prototype, "url", void 0);
            ExchangeHandle = __decorate([
                checkable_1.Checkable.Class
            ], ExchangeHandle);
            exports_1("ExchangeHandle", ExchangeHandle);
            Contract = class Contract {
                validate() {
                    if (this.exchanges.length == 0) {
                        throw Error("no exchanges in contract");
                    }
                }
            };
            __decorate([
                checkable_1.Checkable.String
            ], Contract.prototype, "H_wire", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], Contract.prototype, "summary", void 0);
            __decorate([
                checkable_1.Checkable.Value(AmountJson)
            ], Contract.prototype, "amount", void 0);
            __decorate([
                checkable_1.Checkable.List(checkable_1.Checkable.AnyObject)
            ], Contract.prototype, "auditors", void 0);
            __decorate([
                checkable_1.Checkable.Optional(checkable_1.Checkable.String)
            ], Contract.prototype, "expiry", void 0);
            __decorate([
                checkable_1.Checkable.Optional(checkable_1.Checkable.String)
            ], Contract.prototype, "pay_deadline", void 0);
            __decorate([
                checkable_1.Checkable.Any
            ], Contract.prototype, "locations", void 0);
            __decorate([
                checkable_1.Checkable.Value(AmountJson)
            ], Contract.prototype, "max_fee", void 0);
            __decorate([
                checkable_1.Checkable.Any
            ], Contract.prototype, "merchant", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], Contract.prototype, "merchant_pub", void 0);
            __decorate([
                checkable_1.Checkable.List(checkable_1.Checkable.Value(ExchangeHandle))
            ], Contract.prototype, "exchanges", void 0);
            __decorate([
                checkable_1.Checkable.List(checkable_1.Checkable.AnyObject)
            ], Contract.prototype, "products", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], Contract.prototype, "refund_deadline", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], Contract.prototype, "timestamp", void 0);
            __decorate([
                checkable_1.Checkable.Number
            ], Contract.prototype, "transaction_id", void 0);
            __decorate([
                checkable_1.Checkable.String
            ], Contract.prototype, "fulfillment_url", void 0);
            __decorate([
                checkable_1.Checkable.Optional(checkable_1.Checkable.String)
            ], Contract.prototype, "repurchase_correlation_id", void 0);
            __decorate([
                checkable_1.Checkable.Optional(checkable_1.Checkable.String)
            ], Contract.prototype, "receiver", void 0);
            __decorate([
                checkable_1.Checkable.Optional(checkable_1.Checkable.String)
            ], Contract.prototype, "instance", void 0);
            Contract = __decorate([
                checkable_1.Checkable.ClassWithValidator
            ], Contract);
            exports_1("Contract", Contract);
            (function (Amounts) {
                Amounts.fractionalBase = 1e8;
                function getMaxAmount(currency) {
                    return {
                        currency,
                        value: Number.MAX_SAFE_INTEGER,
                        fraction: Math.pow(2, 32),
                    };
                }
                Amounts.getMaxAmount = getMaxAmount;
                function getZero(currency) {
                    return {
                        currency,
                        value: 0,
                        fraction: 0,
                    };
                }
                Amounts.getZero = getZero;
                function add(first, ...rest) {
                    let currency = first.currency;
                    let value = first.value + Math.floor(first.fraction / Amounts.fractionalBase);
                    if (value > Number.MAX_SAFE_INTEGER) {
                        return { amount: getMaxAmount(currency), saturated: true };
                    }
                    let fraction = first.fraction % Amounts.fractionalBase;
                    for (let x of rest) {
                        if (x.currency !== currency) {
                            throw Error(`Mismatched currency: ${x.currency} and ${currency}`);
                        }
                        value = value + x.value + Math.floor((fraction + x.fraction) / Amounts.fractionalBase);
                        fraction = (fraction + x.fraction) % Amounts.fractionalBase;
                        if (value > Number.MAX_SAFE_INTEGER) {
                            return { amount: getMaxAmount(currency), saturated: true };
                        }
                    }
                    return { amount: { currency, value, fraction }, saturated: false };
                }
                Amounts.add = add;
                function sub(a, ...rest) {
                    let currency = a.currency;
                    let value = a.value;
                    let fraction = a.fraction;
                    for (let b of rest) {
                        if (b.currency !== currency) {
                            throw Error(`Mismatched currency: ${b.currency} and ${currency}`);
                        }
                        if (fraction < b.fraction) {
                            if (value < 1) {
                                return { amount: { currency, value: 0, fraction: 0 }, saturated: true };
                            }
                            value--;
                            fraction += Amounts.fractionalBase;
                        }
                        console.assert(fraction >= b.fraction);
                        fraction -= b.fraction;
                        if (value < b.value) {
                            return { amount: { currency, value: 0, fraction: 0 }, saturated: true };
                        }
                        value -= b.value;
                    }
                    return { amount: { currency, value, fraction }, saturated: false };
                }
                Amounts.sub = sub;
                function cmp(a, b) {
                    if (a.currency !== b.currency) {
                        throw Error(`Mismatched currency: ${a.currency} and ${b.currency}`);
                    }
                    let av = a.value + Math.floor(a.fraction / Amounts.fractionalBase);
                    let af = a.fraction % Amounts.fractionalBase;
                    let bv = b.value + Math.floor(b.fraction / Amounts.fractionalBase);
                    let bf = b.fraction % Amounts.fractionalBase;
                    switch (true) {
                        case av < bv:
                            return -1;
                        case av > bv:
                            return 1;
                        case af < bf:
                            return -1;
                        case af > bf:
                            return 1;
                        case af == bf:
                            return 0;
                        default:
                            throw Error("assertion failed");
                    }
                }
                Amounts.cmp = cmp;
                function copy(a) {
                    return {
                        value: a.value,
                        fraction: a.fraction,
                        currency: a.currency,
                    };
                }
                Amounts.copy = copy;
                function isNonZero(a) {
                    return a.value > 0 || a.fraction > 0;
                }
                Amounts.isNonZero = isNonZero;
            })(Amounts || (Amounts = {}));
            exports_1("Amounts", Amounts);
        }
    };
});
//# sourceMappingURL=types.js.map