System.register(["testlib/talertest", "./types"], function (exports_1, context_1) {
    "use strict";
    var __moduleName = context_1 && context_1.id;
    var talertest_1, types_1, types, amt;
    return {
        setters: [
            function (talertest_1_1) {
                talertest_1 = talertest_1_1;
            },
            function (types_1_1) {
                types_1 = types_1_1;
                types = types_1_1;
            }
        ],
        execute: function () {
            amt = (value, fraction, currency) => ({ value, fraction, currency });
            talertest_1.test("amount addition (simple)", (t) => {
                let a1 = amt(1, 0, "EUR");
                let a2 = amt(1, 0, "EUR");
                let a3 = amt(2, 0, "EUR");
                t.assert(0 == types.Amounts.cmp(types_1.Amounts.add(a1, a2).amount, a3));
                t.pass();
            });
            talertest_1.test("amount addition (saturation)", (t) => {
                let a1 = amt(1, 0, "EUR");
                let res = types_1.Amounts.add(types_1.Amounts.getMaxAmount("EUR"), a1);
                t.assert(res.saturated);
                t.pass();
            });
            talertest_1.test("amount subtraction (simple)", (t) => {
                let a1 = amt(2, 5, "EUR");
                let a2 = amt(1, 0, "EUR");
                let a3 = amt(1, 5, "EUR");
                t.assert(0 == types.Amounts.cmp(types_1.Amounts.sub(a1, a2).amount, a3));
                t.pass();
            });
            talertest_1.test("amount subtraction (saturation)", (t) => {
                let a1 = amt(0, 0, "EUR");
                let a2 = amt(1, 0, "EUR");
                let res = types_1.Amounts.sub(a1, a2);
                t.assert(res.saturated);
                res = types_1.Amounts.sub(a1, a1);
                t.assert(!res.saturated);
                t.pass();
            });
            talertest_1.test("contract validation", (t) => {
                let c = {
                    H_wire: "123",
                    summary: "hello",
                    amount: amt(1, 2, "EUR"),
                    auditors: [],
                    pay_deadline: "Date(12346)",
                    max_fee: amt(1, 2, "EUR"),
                    merchant_pub: "12345",
                    exchanges: [{ master_pub: "foo", url: "foo" }],
                    products: [],
                    refund_deadline: "Date(12345)",
                    timestamp: "Date(12345)",
                    transaction_id: 1234,
                    fulfillment_url: "foo",
                    repurchase_correlation_id: "blabla",
                };
                types.Contract.checked(c);
                let c1 = JSON.parse(JSON.stringify(c));
                c1.exchanges = [];
                try {
                    types.Contract.checked(c1);
                }
                catch (e) {
                    t.pass();
                    return;
                }
                t.fail();
            });
        }
    };
});
//# sourceMappingURL=types-test.js.map