/*
 This file is part of TALER
 (C) 2016 INRIA

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
System.register(["./types"], function (exports_1, context_1) {
    "use strict";
    var __moduleName = context_1 && context_1.id;
    function prettyAmount(amount) {
        let v = amount.value + amount.fraction / types_1.Amounts.fractionalBase;
        return `${v} ${amount.currency}`;
    }
    exports_1("prettyAmount", prettyAmount);
    function renderContract(contract) {
        let merchantName = React.createElement("strong", null, contract.merchant.name);
        let amount = React.createElement("strong", null, prettyAmount(contract.amount));
        return (React.createElement("div", null,
            React.createElement("p", null,
                "The merchant ",
                merchantName,
                "wants to enter a contract over ",
                amount,
                " ",
                "with you."),
            React.createElement("p", null, i18n `You are about to purchase:`),
            React.createElement("ul", null, contract.products.map((p, i) => (React.createElement("li", { key: i }, `${p.description}: ${prettyAmount(p.price)}`))))));
    }
    exports_1("renderContract", renderContract);
    function abbrev(s, n = 5) {
        let sAbbrev = s;
        if (s.length > n) {
            sAbbrev = s.slice(0, n) + "..";
        }
        return (React.createElement("span", { className: "abbrev", title: s }, sAbbrev));
    }
    exports_1("abbrev", abbrev);
    var types_1;
    return {
        setters: [
            function (types_1_1) {
                types_1 = types_1_1;
            }
        ],
        execute: function () {/*
             This file is part of TALER
             (C) 2016 INRIA
            
             TALER is free software; you can redistribute it and/or modify it under the
             terms of the GNU General Public License as published by the Free Software
             Foundation; either version 3, or (at your option) any later version.
            
             TALER is distributed in the hope that it will be useful, but WITHOUT ANY
             WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
             A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
            
             You should have received a copy of the GNU General Public License along with
             TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
             */
        }
    };
});
//# sourceMappingURL=renderHtml.js.map