/*
 This file is part of TALER
 (C) 2016 Inria

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
System.register(["src/components", "src/wxApi", "src/renderHtml", "src/helpers"], function (exports_1, context_1) {
    "use strict";
    var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments)).next());
        });
    };
    var __moduleName = context_1 && context_1.id;
    function main() {
        ReactDOM.render(React.createElement(ExchangesList, null), document.getElementById("container"));
    }
    exports_1("main", main);
    var components_1, wxApi_1, renderHtml_1, helpers_1, ReserveView, Toggle, RefreshDialog, CoinView, PreCoinView, CoinList, PreCoinList, ExpanderText, DenominationList, ReserveList, ExchangeView, ExchangesList;
    return {
        setters: [
            function (components_1_1) {
                components_1 = components_1_1;
            },
            function (wxApi_1_1) {
                wxApi_1 = wxApi_1_1;
            },
            function (renderHtml_1_1) {
                renderHtml_1 = renderHtml_1_1;
            },
            function (helpers_1_1) {
                helpers_1 = helpers_1_1;
            }
        ],
        execute: function () {/*
             This file is part of TALER
             (C) 2016 Inria
            
             TALER is free software; you can redistribute it and/or modify it under the
             terms of the GNU General Public License as published by the Free Software
             Foundation; either version 3, or (at your option) any later version.
            
             TALER is distributed in the hope that it will be useful, but WITHOUT ANY
             WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
             A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
            
             You should have received a copy of the GNU General Public License along with
             TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
             */
            ReserveView = class ReserveView extends React.Component {
                render() {
                    let r = this.props.reserve;
                    return (React.createElement("div", { className: "tree-item" },
                        React.createElement("ul", null,
                            React.createElement("li", null,
                                "Key: ",
                                r.reserve_pub),
                            React.createElement("li", null,
                                "Created: ",
                                (new Date(r.created * 1000).toString())),
                            React.createElement("li", null,
                                "Current: ",
                                r.current_amount ? renderHtml_1.prettyAmount(r.current_amount) : "null"),
                            React.createElement("li", null,
                                "Requested: ",
                                renderHtml_1.prettyAmount(r.requested_amount)),
                            React.createElement("li", null,
                                "Confirmed: ",
                                r.confirmed))));
                }
            };
            Toggle = class Toggle extends components_1.ImplicitStateComponent {
                renderButton() {
                    let show = () => {
                        this.props.expanded(true);
                        this.setState({});
                    };
                    let hide = () => {
                        this.props.expanded(false);
                        this.setState({});
                    };
                    if (this.props.expanded()) {
                        return React.createElement("button", { onClick: hide }, "hide");
                    }
                    return React.createElement("button", { onClick: show }, "show");
                }
                render() {
                    return (React.createElement("div", { style: { display: "inline" } },
                        this.renderButton(),
                        this.props.expanded() ? this.props.children : []));
                }
            };
            RefreshDialog = class RefreshDialog extends components_1.ImplicitStateComponent {
                constructor() {
                    super(...arguments);
                    this.refreshRequested = this.makeState(false);
                }
                render() {
                    if (!this.refreshRequested()) {
                        return (React.createElement("div", { style: { display: "inline" } },
                            React.createElement("button", { onClick: () => this.refreshRequested(true) }, "refresh")));
                    }
                    return (React.createElement("div", null,
                        "Refresh amount: ",
                        React.createElement("input", { type: "text", size: 10 }),
                        React.createElement("button", { onClick: () => wxApi_1.refresh(this.props.coin.coinPub) }, "ok"),
                        React.createElement("button", { onClick: () => this.refreshRequested(false) }, "cancel")));
                }
            };
            CoinView = class CoinView extends React.Component {
                render() {
                    let c = this.props.coin;
                    return (React.createElement("div", { className: "tree-item" },
                        React.createElement("ul", null,
                            React.createElement("li", null,
                                "Key: ",
                                c.coinPub),
                            React.createElement("li", null,
                                "Current amount: ",
                                renderHtml_1.prettyAmount(c.currentAmount)),
                            React.createElement("li", null,
                                "Denomination: ",
                                React.createElement(ExpanderText, { text: c.denomPub })),
                            React.createElement("li", null,
                                "Suspended: ",
                                (c.suspended || false).toString()),
                            React.createElement("li", null,
                                "Dirty: ",
                                (c.dirty || false).toString()),
                            React.createElement("li", null,
                                "Transaction Pending: ",
                                (c.transactionPending || false).toString()),
                            React.createElement("li", null,
                                React.createElement(RefreshDialog, { coin: c })))));
                }
            };
            PreCoinView = class PreCoinView extends React.Component {
                render() {
                    let c = this.props.precoin;
                    return (React.createElement("div", { className: "tree-item" },
                        React.createElement("ul", null,
                            React.createElement("li", null,
                                "Key: ",
                                c.coinPub))));
                }
            };
            CoinList = class CoinList extends components_1.ImplicitStateComponent {
                constructor(props) {
                    super(props);
                    this.coins = this.makeState(null);
                    this.expanded = this.makeState(false);
                    this.update(props);
                }
                update(props) {
                    return __awaiter(this, void 0, void 0, function* () {
                        let coins = yield wxApi_1.getCoins(props.exchangeBaseUrl);
                        this.coins(coins);
                    });
                }
                componentWillReceiveProps(newProps) {
                    this.update(newProps);
                }
                render() {
                    if (!this.coins()) {
                        return React.createElement("div", null, "...");
                    }
                    return (React.createElement("div", { className: "tree-item" },
                        "Coins (",
                        this.coins().length.toString(),
                        ")",
                        " ",
                        React.createElement(Toggle, { expanded: this.expanded }, this.coins().map((c) => React.createElement(CoinView, { coin: c })))));
                }
            };
            PreCoinList = class PreCoinList extends components_1.ImplicitStateComponent {
                constructor(props) {
                    super(props);
                    this.precoins = this.makeState(null);
                    this.expanded = this.makeState(false);
                    this.update();
                }
                update() {
                    return __awaiter(this, void 0, void 0, function* () {
                        let precoins = yield wxApi_1.getPreCoins(this.props.exchangeBaseUrl);
                        this.precoins(precoins);
                    });
                }
                render() {
                    if (!this.precoins()) {
                        return React.createElement("div", null, "...");
                    }
                    return (React.createElement("div", { className: "tree-item" },
                        "Planchets (",
                        this.precoins().length.toString(),
                        ")",
                        " ",
                        React.createElement(Toggle, { expanded: this.expanded }, this.precoins().map((c) => React.createElement(PreCoinView, { precoin: c })))));
                }
            };
            ExpanderText = class ExpanderText extends components_1.ImplicitStateComponent {
                constructor() {
                    super(...arguments);
                    this.expanded = this.makeState(false);
                    this.textArea = undefined;
                }
                componentDidUpdate() {
                    if (this.expanded() && this.textArea) {
                        this.textArea.focus();
                        this.textArea.scrollTop = 0;
                    }
                }
                render() {
                    if (!this.expanded()) {
                        return (React.createElement("span", { onClick: () => { this.expanded(true); } }, (this.props.text.length <= 10)
                            ? this.props.text
                            : (React.createElement("span", null,
                                this.props.text.substring(0, 10),
                                React.createElement("span", { style: { textDecoration: "underline" } }, "...")))));
                    }
                    return (React.createElement("textarea", { readOnly: true, style: { display: "block" }, onBlur: () => this.expanded(false), ref: (e) => this.textArea = e }, this.props.text));
                }
            };
            DenominationList = class DenominationList extends components_1.ImplicitStateComponent {
                constructor(props) {
                    super(props);
                    this.expanded = this.makeState(false);
                    this.denoms = this.makeState(undefined);
                    this.update();
                }
                update() {
                    return __awaiter(this, void 0, void 0, function* () {
                        let d = yield wxApi_1.getDenoms(this.props.exchange.baseUrl);
                        this.denoms(d);
                    });
                }
                renderDenom(d) {
                    return (React.createElement("div", { className: "tree-item" },
                        React.createElement("ul", null,
                            React.createElement("li", null,
                                "Offered: ",
                                d.isOffered ? "yes" : "no"),
                            React.createElement("li", null,
                                "Value: ",
                                renderHtml_1.prettyAmount(d.value)),
                            React.createElement("li", null,
                                "Withdraw fee: ",
                                renderHtml_1.prettyAmount(d.feeWithdraw)),
                            React.createElement("li", null,
                                "Refresh fee: ",
                                renderHtml_1.prettyAmount(d.feeRefresh)),
                            React.createElement("li", null,
                                "Deposit fee: ",
                                renderHtml_1.prettyAmount(d.feeDeposit)),
                            React.createElement("li", null,
                                "Refund fee: ",
                                renderHtml_1.prettyAmount(d.feeRefund)),
                            React.createElement("li", null,
                                "Start: ",
                                helpers_1.getTalerStampDate(d.stampStart).toString()),
                            React.createElement("li", null,
                                "Withdraw expiration: ",
                                helpers_1.getTalerStampDate(d.stampExpireWithdraw).toString()),
                            React.createElement("li", null,
                                "Legal expiration: ",
                                helpers_1.getTalerStampDate(d.stampExpireLegal).toString()),
                            React.createElement("li", null,
                                "Deposit expiration: ",
                                helpers_1.getTalerStampDate(d.stampExpireDeposit).toString()),
                            React.createElement("li", null,
                                "Denom pub: ",
                                React.createElement(ExpanderText, { text: d.denomPub })))));
                }
                render() {
                    let denoms = this.denoms();
                    if (!denoms) {
                        return (React.createElement("div", { className: "tree-item" },
                            "Denominations (...)",
                            " ",
                            React.createElement(Toggle, { expanded: this.expanded }, "...")));
                    }
                    return (React.createElement("div", { className: "tree-item" },
                        "Denominations (",
                        denoms.length.toString(),
                        ")",
                        " ",
                        React.createElement(Toggle, { expanded: this.expanded }, denoms.map((d) => this.renderDenom(d)))));
                }
            };
            ReserveList = class ReserveList extends components_1.ImplicitStateComponent {
                constructor(props) {
                    super(props);
                    this.reserves = this.makeState(null);
                    this.expanded = this.makeState(false);
                    this.update();
                }
                update() {
                    return __awaiter(this, void 0, void 0, function* () {
                        let reserves = yield wxApi_1.getReserves(this.props.exchangeBaseUrl);
                        this.reserves(reserves);
                    });
                }
                render() {
                    if (!this.reserves()) {
                        return React.createElement("div", null, "...");
                    }
                    return (React.createElement("div", { className: "tree-item" },
                        "Reserves (",
                        this.reserves().length.toString(),
                        ")",
                        " ",
                        React.createElement(Toggle, { expanded: this.expanded }, this.reserves().map((r) => React.createElement(ReserveView, { reserve: r })))));
                }
            };
            ExchangeView = class ExchangeView extends React.Component {
                render() {
                    let e = this.props.exchange;
                    return (React.createElement("div", { className: "tree-item" },
                        React.createElement("ul", null,
                            React.createElement("li", null,
                                "Exchange Base Url: ",
                                this.props.exchange.baseUrl),
                            React.createElement("li", null,
                                "Master public key: ",
                                React.createElement(ExpanderText, { text: this.props.exchange.masterPublicKey }))),
                        React.createElement(DenominationList, { exchange: e }),
                        React.createElement(ReserveList, { exchangeBaseUrl: this.props.exchange.baseUrl }),
                        React.createElement(CoinList, { exchangeBaseUrl: this.props.exchange.baseUrl }),
                        React.createElement(PreCoinList, { exchangeBaseUrl: this.props.exchange.baseUrl })));
                }
            };
            ExchangesList = class ExchangesList extends React.Component {
                constructor() {
                    super();
                    let port = chrome.runtime.connect();
                    port.onMessage.addListener((msg) => {
                        if (msg.notify) {
                            console.log("got notified");
                            this.update();
                        }
                    });
                    this.update();
                    this.state = {};
                }
                update() {
                    return __awaiter(this, void 0, void 0, function* () {
                        let exchanges = yield wxApi_1.getExchanges();
                        console.log("exchanges: ", exchanges);
                        this.setState({ exchanges });
                    });
                }
                render() {
                    let exchanges = this.state.exchanges;
                    if (!exchanges) {
                        return React.createElement("span", null, "...");
                    }
                    return (React.createElement("div", { className: "tree-item" },
                        "Exchanges (",
                        exchanges.length.toString(),
                        "):",
                        exchanges.map(e => React.createElement(ExchangeView, { exchange: e }))));
                }
            };
        }
    };
});
//# sourceMappingURL=tree.js.map