/*
 This file is part of TALER
 (C) 2016 Inria

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
System.register(["src/logging"], function (exports_1, context_1) {
    "use strict";
    var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments)).next());
        });
    };
    var __moduleName = context_1 && context_1.id;
    function main() {
        ReactDOM.render(React.createElement(Logs, null), document.getElementById("container"));
    }
    exports_1("main", main);
    var logging_1, LogView, Logs;
    return {
        setters: [
            function (logging_1_1) {
                logging_1 = logging_1_1;
            }
        ],
        execute: function () {/*
             This file is part of TALER
             (C) 2016 Inria
            
             TALER is free software; you can redistribute it and/or modify it under the
             terms of the GNU General Public License as published by the Free Software
             Foundation; either version 3, or (at your option) any later version.
            
             TALER is distributed in the hope that it will be useful, but WITHOUT ANY
             WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
             A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
            
             You should have received a copy of the GNU General Public License along with
             TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
             */
            LogView = class LogView extends React.Component {
                render() {
                    let e = this.props.log;
                    return (React.createElement("div", { className: "tree-item" },
                        React.createElement("ul", null,
                            React.createElement("li", null,
                                "level: ",
                                e.level),
                            React.createElement("li", null,
                                "msg: ",
                                e.msg),
                            React.createElement("li", null,
                                "id: ",
                                e.id || "unknown"),
                            React.createElement("li", null,
                                "file: ",
                                e.source || "(unknown)"),
                            React.createElement("li", null,
                                "line: ",
                                e.line || "(unknown)"),
                            React.createElement("li", null,
                                "col: ",
                                e.col || "(unknown)"),
                            (e.detail ? React.createElement("li", null,
                                " detail: ",
                                React.createElement("pre", null, e.detail)) : []))));
                }
            };
            Logs = class Logs extends React.Component {
                constructor() {
                    super();
                    this.update();
                    this.state = {};
                }
                update() {
                    return __awaiter(this, void 0, void 0, function* () {
                        let logs = yield logging_1.getLogs();
                        this.setState({ logs });
                    });
                }
                render() {
                    let logs = this.state.logs;
                    if (!logs) {
                        return React.createElement("span", null, "...");
                    }
                    return (React.createElement("div", { className: "tree-item" },
                        "Logs:",
                        logs.map(e => React.createElement(LogView, { log: e }))));
                }
            };
        }
    };
});
//# sourceMappingURL=logs.js.map