/*
 This file is part of TALER
 (C) 2015-2016 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
System.register([], function (exports_1, context_1) {
    "use strict";
    var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments)).next());
        });
    };
    var __moduleName = context_1 && context_1.id;
    function main() {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const url = URI(document.location.href);
                const query = URI.parseQuery(url.query());
                const message = query.message || "unknown error";
                ReactDOM.render(React.createElement(ErrorView, { message: message }), document.getElementById("container"));
            }
            catch (e) {
                // TODO: provide more context information, maybe factor it out into a
                // TODO:generic error reporting function or component.
                document.body.innerText = `Fatal error: "${e.message}".`;
                console.error(`got error "${e.message}"`, e);
            }
        });
    }
    exports_1("main", main);
    var ErrorView;
    return {
        setters: [],
        execute: function () {
            ErrorView = class ErrorView extends React.Component {
                render() {
                    return (React.createElement("div", null,
                        "An error occurred: ",
                        this.props.message));
                }
            };
        }
    };
});
//# sourceMappingURL=error.js.map