/*
 This file is part of TALER
 (C) 2015-2016 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
System.register(["src/helpers", "src/types", "src/wxApi", "src/components"], function (exports_1, context_1) {
    "use strict";
    var __assign = (this && this.__assign) || Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments)).next());
        });
    };
    var __moduleName = context_1 && context_1.id;
    function delay(delayMs, value) {
        return new Promise((resolve, reject) => {
            setTimeout(() => resolve(value), delayMs);
        });
    }
    function renderReserveCreationDetails(rci) {
        if (!rci) {
            return React.createElement("p", null, "Details will be displayed when a valid exchange provider URL is entered.");
        }
        let denoms = rci.selectedDenoms;
        let countByPub = {};
        let uniq = [];
        denoms.forEach((x) => {
            let c = countByPub[x.denomPub] || 0;
            if (c == 0) {
                uniq.push(x);
            }
            c += 1;
            countByPub[x.denomPub] = c;
        });
        function row(denom) {
            return (React.createElement("tr", null,
                React.createElement("td", null, countByPub[denom.denomPub] + "x"),
                React.createElement("td", null, helpers_1.amountToPretty(denom.value)),
                React.createElement("td", null, helpers_1.amountToPretty(denom.feeWithdraw)),
                React.createElement("td", null, helpers_1.amountToPretty(denom.feeRefresh)),
                React.createElement("td", null, helpers_1.amountToPretty(denom.feeDeposit))));
        }
        let withdrawFeeStr = helpers_1.amountToPretty(rci.withdrawFee);
        let overheadStr = helpers_1.amountToPretty(rci.overhead);
        return (React.createElement("div", null,
            React.createElement("p", null, i18n `Withdrawal fees: ${withdrawFeeStr}`),
            React.createElement("p", null, i18n `Rounding loss: ${overheadStr}`),
            React.createElement("table", null,
                React.createElement("thead", null,
                    React.createElement("th", null, i18n `# Coins`),
                    React.createElement("th", null, i18n `Value`),
                    React.createElement("th", null, i18n `Withdraw Fee`),
                    React.createElement("th", null, i18n `Refresh Fee`),
                    React.createElement("th", null, i18n `Deposit Fee`)),
                React.createElement("tbody", null, uniq.map(row)))));
    }
    function getSuggestedExchange(currency) {
        // TODO: make this request go to the wallet backend
        // Right now, this is a stub.
        const defaultExchange = {
            "KUDOS": "https://exchange.demo.taler.net",
            "PUDOS": "https://exchange.test.taler.net",
        };
        let exchange = defaultExchange[currency];
        if (!exchange) {
            exchange = "";
        }
        return Promise.resolve(exchange);
    }
    function WithdrawFee(props) {
        if (props.reserveCreationInfo) {
            let { overhead, withdrawFee } = props.reserveCreationInfo;
            let totalCost = types_1.Amounts.add(overhead, withdrawFee).amount;
            return React.createElement("p", null,
                i18n `Withdraw fees:`,
                " ",
                helpers_1.amountToPretty(totalCost));
        }
        return React.createElement("p", null);
    }
    function main() {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const url = URI(document.location.href);
                const query = URI.parseQuery(url.query());
                let amount;
                try {
                    amount = types_1.AmountJson.checked(JSON.parse(query.amount));
                }
                catch (e) {
                    throw Error(i18n `Can't parse amount: ${e.message}`);
                }
                const callback_url = query.callback_url;
                const bank_url = query.bank_url;
                let wt_types;
                try {
                    wt_types = JSON.parse(query.wt_types);
                }
                catch (e) {
                    throw Error(i18n `Can't parse wire_types: ${e.message}`);
                }
                const suggestedExchangeUrl = yield getSuggestedExchange(amount.currency);
                let args = {
                    wt_types,
                    suggestedExchangeUrl,
                    callback_url,
                    amount
                };
                ReactDOM.render(React.createElement(ExchangeSelection, __assign({}, args)), document.getElementById("exchange-selection"));
            }
            catch (e) {
                // TODO: provide more context information, maybe factor it out into a
                // TODO:generic error reporting function or component.
                document.body.innerText = i18n `Fatal error: "${e.message}".`;
                console.error(`got error "${e.message}"`, e);
            }
        });
    }
    exports_1("main", main);
    var helpers_1, types_1, wxApi_1, components_1, EventTrigger, ExchangeSelection;
    return {
        setters: [
            function (helpers_1_1) {
                helpers_1 = helpers_1_1;
            },
            function (types_1_1) {
                types_1 = types_1_1;
            },
            function (wxApi_1_1) {
                wxApi_1 = wxApi_1_1;
            },
            function (components_1_1) {
                components_1 = components_1_1;
            }
        ],
        execute: function () {/*
             This file is part of TALER
             (C) 2015-2016 GNUnet e.V.
            
             TALER is free software; you can redistribute it and/or modify it under the
             terms of the GNU General Public License as published by the Free Software
             Foundation; either version 3, or (at your option) any later version.
            
             TALER is distributed in the hope that it will be useful, but WITHOUT ANY
             WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
             A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
            
             You should have received a copy of the GNU General Public License along with
             TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
             */
            "use strict";
            EventTrigger = class EventTrigger {
                constructor() {
                    this.reset();
                }
                reset() {
                    this.triggerPromise = new Promise((resolve, reject) => {
                        this.triggerResolve = resolve;
                    });
                }
                trigger() {
                    this.triggerResolve(false);
                    this.reset();
                }
                wait(delayMs) {
                    return __awaiter(this, void 0, void 0, function* () {
                        return yield Promise.race([this.triggerPromise, delay(delayMs, true)]);
                    });
                }
            };
            ExchangeSelection = class ExchangeSelection extends components_1.ImplicitStateComponent {
                constructor(props) {
                    super(props);
                    this.statusString = this.makeState(null);
                    this.reserveCreationInfo = this.makeState(null);
                    this.url = this.makeState(null);
                    this.detailCollapsed = this.makeState(true);
                    this.updateEvent = new EventTrigger();
                    this.onUrlChanged(props.suggestedExchangeUrl || null);
                }
                renderAdvanced() {
                    if (this.detailCollapsed() && this.url() !== null && !this.statusString()) {
                        return (React.createElement("button", { className: "linky", onClick: () => this.detailCollapsed(false) }, i18n `view fee structure / select different exchange provider`));
                    }
                    return (React.createElement("div", null,
                        React.createElement("h2", null, "Provider Selection"),
                        React.createElement("label", null, "URL: "),
                        React.createElement("input", { className: "url", type: "text", spellCheck: false, value: this.url(), key: "exchange-url-input", onInput: (e) => this.onUrlChanged(e.target.value) }),
                        React.createElement("br", null),
                        this.renderStatus(),
                        React.createElement("h2", null, i18n `Detailed Fee Structure`),
                        renderReserveCreationDetails(this.reserveCreationInfo())));
                }
                renderFee() {
                    if (!this.reserveCreationInfo()) {
                        return "??";
                    }
                    let rci = this.reserveCreationInfo();
                    let totalCost = types_1.Amounts.add(rci.overhead, rci.withdrawFee).amount;
                    return `${helpers_1.amountToPretty(totalCost)}`;
                }
                renderFeeStatus() {
                    if (this.reserveCreationInfo()) {
                        return (React.createElement(i18n.Translate, { wrap: "p" },
                            "The exchange provider will charge",
                            " ",
                            React.createElement("span", null, this.renderFee()),
                            " ",
                            "in fees."));
                    }
                    if (this.url() && !this.statusString()) {
                        let shortName = URI(this.url()).host();
                        return (React.createElement(i18n.Translate, { wrap: "p" },
                            "Waiting for a response from",
                            " ",
                            React.createElement("em", null, shortName)));
                    }
                    if (this.statusString()) {
                        return (React.createElement("p", null,
                            React.createElement("strong", { style: { color: "red" } }, i18n `A problem occured, see below.`)));
                    }
                    return (React.createElement("p", null, i18n `Information about fees will be available when an exchange provider is selected.`));
                }
                render() {
                    return (React.createElement("div", null,
                        React.createElement(i18n.Translate, { wrap: "p" },
                            "You are about to withdraw ",
                            React.createElement("strong", null, helpers_1.amountToPretty(this.props.amount)),
                            " from your bank account into your wallet."),
                        this.renderFeeStatus(),
                        React.createElement("button", { className: "accept", disabled: this.reserveCreationInfo() == null, onClick: () => this.confirmReserve() }, i18n `Accept fees and withdraw`),
                        React.createElement("br", null),
                        this.renderAdvanced()));
                }
                confirmReserve() {
                    this.confirmReserveImpl(this.reserveCreationInfo(), this.url(), this.props.amount, this.props.callback_url);
                }
                /**
                 * Do an update of the reserve creation info, without any debouncing.
                 */
                forceReserveUpdate() {
                    return __awaiter(this, void 0, void 0, function* () {
                        this.reserveCreationInfo(null);
                        if (!this.url()) {
                            this.statusString(i18n `Error: URL is empty`);
                            this.detailCollapsed(false);
                            return;
                        }
                        this.statusString(null);
                        let parsedUrl = URI(this.url());
                        if (parsedUrl.is("relative")) {
                            this.statusString(i18n `Error: URL may not be relative`);
                            return;
                        }
                        try {
                            let url = helpers_1.canonicalizeBaseUrl(this.url());
                            let r = yield wxApi_1.getReserveCreationInfo(url, this.props.amount);
                            console.log("get exchange info resolved");
                            this.reserveCreationInfo(r);
                            console.dir(r);
                        }
                        catch (e) {
                            console.log("get exchange info rejected");
                            if (e.hasOwnProperty("httpStatus")) {
                                this.statusString(`Error: request failed with status ${e.httpStatus}`);
                                this.detailCollapsed(false);
                            }
                            else if (e.hasOwnProperty("errorResponse")) {
                                let resp = e.errorResponse;
                                this.statusString(`Error: ${resp.error} (${resp.hint})`);
                                this.detailCollapsed(false);
                            }
                        }
                    });
                }
                reset() {
                    this.statusString(null);
                    this.reserveCreationInfo(null);
                }
                confirmReserveImpl(rci, exchange, amount, callback_url) {
                    const d = { exchange: helpers_1.canonicalizeBaseUrl(exchange), amount };
                    const cb = (rawResp) => {
                        if (!rawResp) {
                            throw Error("empty response");
                        }
                        // FIXME: filter out types that bank/exchange don't have in common
                        let wire_details = rci.wireInfo;
                        if (!rawResp.error) {
                            const resp = types_1.CreateReserveResponse.checked(rawResp);
                            let q = {
                                wire_details: JSON.stringify(wire_details),
                                exchange: resp.exchange,
                                reserve_pub: resp.reservePub,
                                amount_value: amount.value,
                                amount_fraction: amount.fraction,
                                amount_currency: amount.currency,
                            };
                            let url = URI(callback_url).addQuery(q);
                            if (!url.is("absolute")) {
                                throw Error("callback url is not absolute");
                            }
                            console.log("going to", url.href());
                            document.location.href = url.href();
                        }
                        else {
                            this.reset();
                            this.statusString(i18n `Oops, something went wrong. The wallet responded with error status (${rawResp.error}).`);
                            this.detailCollapsed(false);
                        }
                    };
                    chrome.runtime.sendMessage({ type: 'create-reserve', detail: d }, cb);
                }
                onUrlChanged(url) {
                    return __awaiter(this, void 0, void 0, function* () {
                        this.reset();
                        this.url(url);
                        if (url == undefined) {
                            return;
                        }
                        this.updateEvent.trigger();
                        let waited = yield this.updateEvent.wait(200);
                        if (waited) {
                            // Run the actual update if nobody else preempted us.
                            this.forceReserveUpdate();
                            this.forceUpdate();
                        }
                    });
                }
                renderStatus() {
                    if (this.statusString()) {
                        return React.createElement("p", null,
                            React.createElement("strong", { style: { color: "red" } }, this.statusString()));
                    }
                    else if (!this.reserveCreationInfo()) {
                        return React.createElement("p", null, i18n `Checking URL, please wait ...`);
                    }
                    return "";
                }
            };
        }
    };
});
//# sourceMappingURL=confirm-create-reserve.js.map