/*
 This file is part of TALER
 (C) 2015 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
System.register(["src/helpers", "src/renderHtml", "src/wxApi"], function (exports_1, context_1) {
    /**
     * Page shown to the user to confirm entering
     * a contract.
     *
     * @author Florian Dold
     */
    "use strict";
    var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments)).next());
        });
    };
    var __moduleName = context_1 && context_1.id;
    function main() {
        let url = URI(document.location.href);
        let query = URI.parseQuery(url.query());
        let offerId = JSON.parse(query.offerId);
        ReactDOM.render(React.createElement(ContractPrompt, { offerId: offerId }), document.getElementById("contract"));
    }
    exports_1("main", main);
    var helpers_1, renderHtml_1, wxApi_1, Details, ContractPrompt;
    return {
        setters: [
            function (helpers_1_1) {
                helpers_1 = helpers_1_1;
            },
            function (renderHtml_1_1) {
                renderHtml_1 = renderHtml_1_1;
            },
            function (wxApi_1_1) {
                wxApi_1 = wxApi_1_1;
            }
        ],
        execute: function () {
            Details = class Details extends React.Component {
                constructor(props) {
                    super(props);
                    console.log("new Details component created");
                    this.state = {
                        collapsed: props.collapsed,
                    };
                    console.log("initial state:", this.state);
                }
                render() {
                    if (this.state.collapsed) {
                        return (React.createElement("div", null,
                            React.createElement("button", { className: "linky", onClick: () => { this.setState({ collapsed: false }); } },
                                React.createElement(i18n.Translate, { wrap: "span" }, "show more details"))));
                    }
                    else {
                        return (React.createElement("div", null,
                            React.createElement("button", { className: "linky", onClick: () => this.setState({ collapsed: true }) }, "show less details"),
                            React.createElement("div", null,
                                i18n `Accepted exchanges:`,
                                React.createElement("ul", null, this.props.contract.exchanges.map(e => React.createElement("li", null, `${e.url}: ${e.master_pub}`))),
                                i18n `Exchanges in the wallet:`,
                                React.createElement("ul", null, (this.props.exchanges || []).map((e) => React.createElement("li", null, `${e.baseUrl}: ${e.masterPublicKey}`))))));
                    }
                }
            };
            ContractPrompt = class ContractPrompt extends React.Component {
                constructor() {
                    super();
                    this.state = {
                        offer: null,
                        error: null,
                        payDisabled: true,
                        exchanges: null
                    };
                }
                componentWillMount() {
                    this.update();
                }
                componentWillUnmount() {
                    // FIXME: abort running ops
                }
                update() {
                    return __awaiter(this, void 0, void 0, function* () {
                        let offer = yield this.getOffer();
                        this.setState({ offer });
                        this.checkPayment();
                        let exchanges = yield wxApi_1.getExchanges();
                        this.setState({ exchanges });
                    });
                }
                getOffer() {
                    return new Promise((resolve, reject) => {
                        let msg = {
                            type: 'get-offer',
                            detail: {
                                offerId: this.props.offerId
                            }
                        };
                        chrome.runtime.sendMessage(msg, (resp) => {
                            resolve(resp);
                        });
                    });
                }
                checkPayment() {
                    let msg = {
                        type: 'check-pay',
                        detail: {
                            offer: this.state.offer
                        }
                    };
                    chrome.runtime.sendMessage(msg, (resp) => {
                        if (resp.error) {
                            console.log("check-pay error", JSON.stringify(resp));
                            switch (resp.error) {
                                case "coins-insufficient":
                                    let msgInsufficient = i18n `You have insufficient funds of the requested currency in your wallet.`;
                                    let msgNoMatch = i18n `You do not have any funds from an exchange that is accepted by this merchant. None of the exchanges accepted by the merchant is known to your wallet.`;
                                    if (this.state.exchanges && this.state.offer) {
                                        let acceptedExchangePubs = this.state.offer.contract.exchanges.map((e) => e.master_pub);
                                        let ex = this.state.exchanges.find((e) => acceptedExchangePubs.indexOf(e.masterPublicKey) >= 0);
                                        if (ex) {
                                            this.state.error = msgInsufficient;
                                        }
                                        else {
                                            this.state.error = msgNoMatch;
                                        }
                                    }
                                    else {
                                        this.state.error = msgInsufficient;
                                    }
                                    break;
                                default:
                                    this.state.error = `Error: ${resp.error}`;
                                    break;
                            }
                            this.state.payDisabled = true;
                        }
                        else {
                            this.state.payDisabled = false;
                            this.state.error = null;
                        }
                        this.setState({});
                        window.setTimeout(() => this.checkPayment(), 500);
                    });
                }
                doPayment() {
                    let d = { offer: this.state.offer };
                    chrome.runtime.sendMessage({ type: 'confirm-pay', detail: d }, (resp) => {
                        if (resp.error) {
                            console.log("confirm-pay error", JSON.stringify(resp));
                            switch (resp.error) {
                                case "coins-insufficient":
                                    this.state.error = "You do not have enough coins of the" +
                                        " requested currency.";
                                    break;
                                default:
                                    this.state.error = `Error: ${resp.error}`;
                                    break;
                            }
                            this.setState({});
                            return;
                        }
                        let c = d.offer.contract;
                        console.log("contract", c);
                        document.location.href = helpers_1.substituteFulfillmentUrl(c.fulfillment_url, this.state.offer);
                    });
                }
                render() {
                    if (!this.state.offer) {
                        return React.createElement("span", null, "...");
                    }
                    let c = this.state.offer.contract;
                    return (React.createElement("div", null,
                        React.createElement("div", null, renderHtml_1.renderContract(c)),
                        React.createElement("button", { onClick: () => this.doPayment(), disabled: this.state.payDisabled, className: "accept" }, "Confirm payment"),
                        React.createElement("div", null, (this.state.error ? React.createElement("p", { className: "errorbox" }, this.state.error) : React.createElement("p", null))),
                        React.createElement(Details, { exchanges: this.state.exchanges, contract: c, collapsed: !this.state.error })));
                }
            };
        }
    };
});
//# sourceMappingURL=confirm-contract.js.map