/*
 This file is part of TALER
 (C) 2016 Inria

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
System.register(["./query"], function (exports_1, context_1) {
    "use strict";
    var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
        return new (P || (P = Promise))(function (resolve, reject) {
            function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
            function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
            function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
            step((generator = generator.apply(thisArg, _arguments)).next());
        });
    };
    var __moduleName = context_1 && context_1.id;
    function makeInfo() {
        return console.info.bind(console, "%o");
    }
    function makeWarn() {
        return console.warn.bind(console, "%o");
    }
    function makeError() {
        return console.error.bind(console, "%o");
    }
    function makeDebug() {
        return console.log.bind(console, "%o");
    }
    function log(msg, level = "info") {
        return __awaiter(this, void 0, void 0, function* () {
            let ci = getCallInfo(2);
            return record(level, msg, undefined, ci.file, ci.line, ci.column);
        });
    }
    exports_1("log", log);
    function getCallInfo(level) {
        // see https://github.com/v8/v8/wiki/Stack-Trace-API
        let stack = Error().stack;
        if (!stack) {
            return unknownFrame;
        }
        let lines = stack.split("\n");
        return parseStackLine(lines[level + 1]);
    }
    /**
     * Adapted from https://github.com/errwischt/stacktrace-parser.
     */
    function parseStackLine(stackLine) {
        const chrome = /^\s*at (?:(?:(?:Anonymous function)?|((?:\[object object\])?\S+(?: \[as \S+\])?)) )?\(?((?:file|http|https):.*?):(\d+)(?::(\d+))?\)?\s*$/i;
        const gecko = /^(?:\s*([^@]*)(?:\((.*?)\))?@)?(\S.*?):(\d+)(?::(\d+))?\s*$/i;
        const node = /^\s*at (?:((?:\[object object\])?\S+(?: \[as \S+\])?) )?\(?(.*?):(\d+)(?::(\d+))?\)?\s*$/i;
        let parts;
        if ((parts = gecko.exec(stackLine))) {
            let f = {
                file: parts[3],
                method: parts[1] || "(unknown)",
                line: +parts[4],
                column: parts[5] ? +parts[5] : undefined,
            };
            return f;
        }
        else if ((parts = chrome.exec(stackLine))) {
            let f = {
                file: parts[2],
                method: parts[1] || "(unknown)",
                line: +parts[3],
                column: parts[4] ? +parts[4] : undefined,
            };
            return f;
        }
        else if ((parts = node.exec(stackLine))) {
            let f = {
                file: parts[2],
                method: parts[1] || "(unknown)",
                line: +parts[3],
                column: parts[4] ? +parts[4] : undefined,
            };
            return f;
        }
        return unknownFrame;
    }
    function getLogs() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!db) {
                db = yield openLoggingDb();
            }
            return yield new query_1.QueryRoot(db).iter(logsStore).toArray();
        });
    }
    exports_1("getLogs", getLogs);
    function recordException(msg, e) {
        return __awaiter(this, void 0, void 0, function* () {
            let stack;
            let frame;
            try {
                stack = e.stack;
                if (stack) {
                    let lines = stack.split("\n");
                    frame = parseStackLine(lines[1]);
                }
            }
            catch (e) {
            }
            if (!frame) {
                frame = unknownFrame;
            }
            return record("error", e.toString(), stack, frame.file, frame.line, frame.column);
        });
    }
    exports_1("recordException", recordException);
    function record(level, msg, detail, source, line, col) {
        return __awaiter(this, void 0, void 0, function* () {
            if (typeof indexedDB === "undefined") {
                return;
            }
            let myBarrier;
            if (barrier) {
                let p = barrier.promise;
                myBarrier = barrier = query_1.openPromise();
                yield p;
            }
            else {
                myBarrier = barrier = query_1.openPromise();
            }
            try {
                if (!db) {
                    db = yield openLoggingDb();
                }
                let count = yield new query_1.QueryRoot(db).count(logsStore);
                if (count > 1000) {
                    yield new query_1.QueryRoot(db).deleteIf(logsStore, (e, i) => (i < 200));
                }
                let entry = {
                    timestamp: new Date().getTime(),
                    level,
                    msg,
                    source,
                    line,
                    col,
                    detail,
                };
                yield new query_1.QueryRoot(db).put(logsStore, entry);
            }
            finally {
                yield Promise.resolve().then(() => myBarrier.resolve());
            }
        });
    }
    exports_1("record", record);
    function openLoggingDb() {
        return new Promise((resolve, reject) => {
            const req = indexedDB.open("taler-logging", loggingDbVersion);
            req.onerror = (e) => {
                reject(e);
            };
            req.onsuccess = (e) => {
                resolve(req.result);
            };
            req.onupgradeneeded = (e) => {
                const db = req.result;
                if (e.oldVersion != 0) {
                    try {
                        db.deleteObjectStore("logs");
                    }
                    catch (e) {
                        console.error(e);
                    }
                }
                db.createObjectStore("logs", { keyPath: "id", autoIncrement: true });
            };
        });
    }
    exports_1("openLoggingDb", openLoggingDb);
    var query_1, unknownFrame, db, barrier, loggingDbVersion, logsStore, info, debug, warn, error;
    return {
        setters: [
            function (query_1_1) {
                query_1 = query_1_1;
            }
        ],
        execute: function () {/*
             This file is part of TALER
             (C) 2016 Inria
            
             TALER is free software; you can redistribute it and/or modify it under the
             terms of the GNU General Public License as published by the Free Software
             Foundation; either version 3, or (at your option) any later version.
            
             TALER is distributed in the hope that it will be useful, but WITHOUT ANY
             WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
             A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
            
             You should have received a copy of the GNU General Public License along with
             TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
             */
            unknownFrame = {
                file: "(unknown)",
                method: "(unknown)",
                line: 0,
                column: 0
            };
            db = undefined;
            loggingDbVersion = 1;
            logsStore = new query_1.Store("logs");
            exports_1("info", info = makeInfo());
            exports_1("debug", debug = makeDebug());
            exports_1("warn", warn = makeWarn());
            exports_1("error", error = makeError());
        }
    };
});
//# sourceMappingURL=logging.js.map