/*
 This file is part of TALER
 (C) 2016 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
System.register([], function (exports_1, context_1) {
    /**
     * Helpers for doing XMLHttpRequest-s that are based on ES6 promises.
     * @module Http
     * @author Florian Dold
     */
    "use strict";
    var __moduleName = context_1 && context_1.id;
    var BrowserHttpLib, RequestException;
    return {
        setters: [],
        execute: function () {
            BrowserHttpLib = class BrowserHttpLib {
                req(method, url, options) {
                    let urlString;
                    if (url instanceof URI) {
                        urlString = url.href();
                    }
                    else if (typeof url === "string") {
                        urlString = url;
                    }
                    return new Promise((resolve, reject) => {
                        let myRequest = new XMLHttpRequest();
                        myRequest.open(method, urlString);
                        if (options && options.req) {
                            myRequest.send(options.req);
                        }
                        else {
                            myRequest.send();
                        }
                        myRequest.addEventListener("readystatechange", (e) => {
                            if (myRequest.readyState == XMLHttpRequest.DONE) {
                                let resp = {
                                    status: myRequest.status,
                                    responseText: myRequest.responseText
                                };
                                resolve(resp);
                            }
                        });
                    });
                }
                get(url) {
                    return this.req("get", url);
                }
                postJson(url, body) {
                    return this.req("post", url, { req: JSON.stringify(body) });
                }
                postForm(url, form) {
                    return this.req("post", url, { req: form });
                }
            };
            exports_1("BrowserHttpLib", BrowserHttpLib);
            RequestException = class RequestException {
                constructor(detail) {
                }
            };
            exports_1("RequestException", RequestException);
        }
    };
});
//# sourceMappingURL=http.js.map