/*
 This file is part of TALER
 (C) 2016 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
System.register(["./types"], function (exports_1, context_1) {
    "use strict";
    var __moduleName = context_1 && context_1.id;
    function substituteFulfillmentUrl(url, vars) {
        url = url.replace("${H_contract}", vars.H_contract);
        url = url.replace("${$}", "$");
        return url;
    }
    exports_1("substituteFulfillmentUrl", substituteFulfillmentUrl);
    function amountToPretty(amount) {
        let x = amount.value + amount.fraction / types_1.Amounts.fractionalBase;
        return `${x} ${amount.currency}`;
    }
    exports_1("amountToPretty", amountToPretty);
    /**
     * Canonicalize a base url, typically for the exchange.
     *
     * See http://api.taler.net/wallet.html#general
     */
    function canonicalizeBaseUrl(url) {
        let x = new URI(url);
        if (!x.protocol()) {
            x.protocol("https");
        }
        x.path(x.path() + "/").normalizePath();
        x.fragment("");
        x.query();
        return x.href();
    }
    exports_1("canonicalizeBaseUrl", canonicalizeBaseUrl);
    function parsePrettyAmount(pretty) {
        const res = /([0-9]+)(.[0-9]+)?\s*(\w+)/.exec(pretty);
        if (!res) {
            return undefined;
        }
        return {
            value: parseInt(res[1], 10),
            fraction: res[2] ? (parseFloat(`0.${res[2]}`) / types_1.Amounts.fractionalBase) : 0,
            currency: res[3]
        };
    }
    exports_1("parsePrettyAmount", parsePrettyAmount);
    /**
     * Convert object to JSON with canonical ordering of keys
     * and whitespace omitted.
     */
    function canonicalJson(obj) {
        // Check for cycles, etc.
        JSON.stringify(obj);
        if (typeof obj == "string" || typeof obj == "number" || obj === null) {
            return JSON.stringify(obj);
        }
        if (Array.isArray(obj)) {
            let objs = obj.map((e) => canonicalJson(e));
            return `[${objs.join(',')}]`;
        }
        let keys = [];
        for (let key in obj) {
            keys.push(key);
        }
        keys.sort();
        let s = "{";
        for (let i = 0; i < keys.length; i++) {
            let key = keys[i];
            s += JSON.stringify(key) + ":" + canonicalJson(obj[key]);
            if (i != keys.length - 1) {
                s += ",";
            }
        }
        return s + "}";
    }
    exports_1("canonicalJson", canonicalJson);
    function deepEquals(x, y) {
        if (x === y) {
            return true;
        }
        if (Array.isArray(x) && x.length !== y.length) {
            return false;
        }
        var p = Object.keys(x);
        return Object.keys(y).every((i) => p.indexOf(i) !== -1) &&
            p.every((i) => deepEquals(x[i], y[i]));
    }
    exports_1("deepEquals", deepEquals);
    function flatMap(xs, f) {
        return xs.reduce((acc, next) => [...f(next), ...acc], []);
    }
    exports_1("flatMap", flatMap);
    function getTalerStampSec(stamp) {
        const m = stamp.match(/\/?Date\(([0-9]*)\)\/?/);
        if (!m) {
            return null;
        }
        return parseInt(m[1]);
    }
    exports_1("getTalerStampSec", getTalerStampSec);
    function getTalerStampDate(stamp) {
        let sec = getTalerStampSec(stamp);
        if (sec == null) {
            return null;
        }
        return new Date(sec * 1000);
    }
    exports_1("getTalerStampDate", getTalerStampDate);
    var types_1;
    return {
        setters: [
            function (types_1_1) {
                types_1 = types_1_1;
            }
        ],
        execute: function () {/*
             This file is part of TALER
             (C) 2016 GNUnet e.V.
            
             TALER is free software; you can redistribute it and/or modify it under the
             terms of the GNU General Public License as published by the Free Software
             Foundation; either version 3, or (at your option) any later version.
            
             TALER is distributed in the hope that it will be useful, but WITHOUT ANY
             WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
             A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
            
             You should have received a copy of the GNU General Public License along with
             TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
             */
        }
    };
});
//# sourceMappingURL=helpers.js.map