System.register(["testlib/talertest", "./helpers"], function (exports_1, context_1) {
    "use strict";
    var __moduleName = context_1 && context_1.id;
    var talertest_1, helpers;
    return {
        setters: [
            function (talertest_1_1) {
                talertest_1 = talertest_1_1;
            },
            function (helpers_1) {
                helpers = helpers_1;
            }
        ],
        execute: function () {
            talertest_1.test("URL canonicalization", (t) => {
                // converts to relative, adds https
                t.assertEqualsStrict("https://alice.example.com/exchange/", helpers.canonicalizeBaseUrl("alice.example.com/exchange"));
                // keeps http, adds trailing slash
                t.assertEqualsStrict("http://alice.example.com/exchange/", helpers.canonicalizeBaseUrl("http://alice.example.com/exchange"));
                // keeps http, adds trailing slash
                t.assertEqualsStrict("http://alice.example.com/exchange/", helpers.canonicalizeBaseUrl("http://alice.example.com/exchange#foobar"));
                t.pass();
            });
        }
    };
});
//# sourceMappingURL=helpers-test.js.map