System.register(["testlib/talertest", "./emscriptif"], function (exports_1, context_1) {
    "use strict";
    var __moduleName = context_1 && context_1.id;
    var talertest_1, native;
    return {
        setters: [
            function (talertest_1_1) {
                talertest_1 = talertest_1_1;
            },
            function (native_1) {
                native = native_1;
            }
        ],
        execute: function () {
            talertest_1.test("string hashing", (t) => {
                let x = native.ByteArray.fromStringWithNull("hello taler");
                let h = "8RDMADB3YNF3QZBS3V467YZVJAMC2QAQX0TZGVZ6Q5PFRRAJFT70HHN0QF661QR9QWKYMMC7YEMPD679D2RADXCYK8Y669A2A5MKQFR";
                let hc = x.hash().toCrock();
                console.log(`# hc ${hc}`);
                t.assert(h === hc, "must equal");
                t.pass();
            });
            talertest_1.test("signing", (t) => {
                let x = native.ByteArray.fromStringWithNull("hello taler");
                let priv = native.EddsaPrivateKey.create();
                let pub = priv.getPublicKey();
                let purpose = new native.EccSignaturePurpose(native.SignaturePurpose.TEST, x);
                let sig = native.eddsaSign(purpose, priv);
                t.assert(native.eddsaVerify(native.SignaturePurpose.TEST, purpose, sig, pub));
                t.pass();
            });
        }
    };
});
//# sourceMappingURL=emscriptif-test.js.map