/*
 This file is part of TALER
 (C) 2016 GNUnet e.V.

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
System.register([], function (exports_1, context_1) {
    "use strict";
    var __moduleName = context_1 && context_1.id;
    var NUM_PRIO, CryptoApi;
    return {
        setters: [],
        execute: function () {/*
             This file is part of TALER
             (C) 2016 GNUnet e.V.
            
             TALER is free software; you can redistribute it and/or modify it under the
             terms of the GNU General Public License as published by the Free Software
             Foundation; either version 3, or (at your option) any later version.
            
             TALER is distributed in the hope that it will be useful, but WITHOUT ANY
             WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
             A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
            
             You should have received a copy of the GNU General Public License along with
             TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
             */
            /**
             * Number of different priorities. Each priority p
             * must be 0 <= p < NUM_PRIO.
             */
            NUM_PRIO = 5;
            CryptoApi = class CryptoApi {
                constructor() {
                    this.nextRpcId = 1;
                    /**
                     * Number of busy workers.
                     */
                    this.numBusy = 0;
                    this.workers = new Array(navigator["hardwareConcurrency"] || 2);
                    for (let i = 0; i < this.workers.length; i++) {
                        this.workers[i] = {
                            w: null,
                            terminationTimerHandle: null,
                            currentWorkItem: null,
                        };
                    }
                    this.workQueues = [];
                    for (let i = 0; i < NUM_PRIO; i++) {
                        this.workQueues.push([]);
                    }
                }
                /**
                 * Start a worker (if not started) and set as busy.
                 */
                wake(ws, work) {
                    if (ws.currentWorkItem != null) {
                        throw Error("assertion failed");
                    }
                    ws.currentWorkItem = work;
                    this.numBusy++;
                    if (!ws.w) {
                        let w = new Worker("/src/cryptoWorker.js");
                        w.onmessage = (m) => this.handleWorkerMessage(ws, m);
                        w.onerror = (e) => this.handleWorkerError(ws, e);
                        ws.w = w;
                    }
                    let msg = {
                        operation: work.operation, args: work.args,
                        id: work.rpcId
                    };
                    this.resetWorkerTimeout(ws);
                    ws.w.postMessage(msg);
                }
                resetWorkerTimeout(ws) {
                    if (ws.terminationTimerHandle != null) {
                        clearTimeout(ws.terminationTimerHandle);
                    }
                    let destroy = () => {
                        // terminate worker if it's idle
                        if (ws.w && ws.currentWorkItem == null) {
                            ws.w.terminate();
                            ws.w = null;
                        }
                    };
                    ws.terminationTimerHandle = setTimeout(destroy, 20 * 1000);
                }
                handleWorkerError(ws, e) {
                    if (ws.currentWorkItem) {
                        console.error(`error in worker during ${ws.currentWorkItem.operation}`, e);
                    }
                    else {
                        console.error("error in worker", e);
                    }
                    console.error(e.message);
                    try {
                        ws.w.terminate();
                        ws.w = null;
                    }
                    catch (e) {
                        console.error(e);
                    }
                    if (ws.currentWorkItem != null) {
                        ws.currentWorkItem.reject(e);
                        ws.currentWorkItem = null;
                        this.numBusy--;
                    }
                    this.findWork(ws);
                }
                findWork(ws) {
                    // try to find more work for this worker
                    for (let i = 0; i < NUM_PRIO; i++) {
                        let q = this.workQueues[NUM_PRIO - i - 1];
                        if (q.length != 0) {
                            let work = q.shift();
                            this.wake(ws, work);
                            return;
                        }
                    }
                }
                handleWorkerMessage(ws, msg) {
                    let id = msg.data.id;
                    if (typeof id !== "number") {
                        console.error("rpc id must be number");
                        return;
                    }
                    let currentWorkItem = ws.currentWorkItem;
                    ws.currentWorkItem = null;
                    this.numBusy--;
                    this.findWork(ws);
                    if (!currentWorkItem) {
                        console.error("unsolicited response from worker");
                        return;
                    }
                    if (id != currentWorkItem.rpcId) {
                        console.error(`RPC with id ${id} has no registry entry`);
                        return;
                    }
                    currentWorkItem.resolve(msg.data.result);
                }
                doRpc(operation, priority, ...args) {
                    let start = performance.now();
                    let p = new Promise((resolve, reject) => {
                        let rpcId = this.nextRpcId++;
                        let workItem = { operation, args, resolve, reject, rpcId };
                        if (this.numBusy == this.workers.length) {
                            let q = this.workQueues[priority];
                            if (!q) {
                                throw Error("assertion failed");
                            }
                            this.workQueues[priority].push(workItem);
                            return;
                        }
                        for (let i = 0; i < this.workers.length; i++) {
                            let ws = this.workers[i];
                            if (ws.currentWorkItem != null) {
                                continue;
                            }
                            this.wake(ws, workItem);
                            return;
                        }
                        throw Error("assertion failed");
                    });
                    return p.then((r) => {
                        console.log(`rpc ${operation} took ${performance.now() - start}ms`);
                        return r;
                    });
                }
                createPreCoin(denom, reserve) {
                    return this.doRpc("createPreCoin", 1, denom, reserve);
                }
                hashString(str) {
                    return this.doRpc("hashString", 1, str);
                }
                isValidDenom(denom, masterPub) {
                    return this.doRpc("isValidDenom", 2, denom, masterPub);
                }
                signDeposit(offer, cds) {
                    return this.doRpc("signDeposit", 3, offer, cds);
                }
                createEddsaKeypair() {
                    return this.doRpc("createEddsaKeypair", 1);
                }
                rsaUnblind(sig, bk, pk) {
                    return this.doRpc("rsaUnblind", 4, sig, bk, pk);
                }
                createRefreshSession(exchangeBaseUrl, kappa, meltCoin, newCoinDenoms, meltFee) {
                    return this.doRpc("createRefreshSession", 4, exchangeBaseUrl, kappa, meltCoin, newCoinDenoms, meltFee);
                }
            };
            exports_1("CryptoApi", CryptoApi);
        }
    };
});
//# sourceMappingURL=cryptoApi.js.map