/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */
import {
  AmountString,
  TalerCorebankApi,
  setupI18n,
} from "@gnu-taler/taler-util";
import {
  BankApiProviderTesting,
  parseGroupImport,
} from "@gnu-taler/web-util/browser";
import * as tests from "@gnu-taler/web-util/testing";
import * as components from "./components/index.examples.js";
import * as pages from "./pages/index.stories.js";

import { ComponentChildren, VNode, h as create } from "preact";
// import { BankCoreApiProviderTesting } from "./context/config.js";

setupI18n("en", { en: {} });

describe("All the examples:", () => {
  const cms = parseGroupImport({ pages, components });
  cms.forEach((group) => {
    describe(`Example for group "${group.title}:"`, () => {
      group.list.forEach((component) => {
        describe(`Component ${component.name}:`, () => {
          component.examples.forEach((example) => {
            it(`should render example: ${example.name}`, () => {
              tests.renderUI(example.render, DefaultTestingContext);
            });
          });
        });
      });
    });
  });
});

function DefaultTestingContext(_props: { children: ComponentChildren }): VNode {
  const cfg: TalerCorebankApi.Config = {
    name: "libeufin-bank",
    allow_deletions: true,
    bank_name: "taler bank",
    wire_type: "wire t",
    supported_tan_channels: [],
    allow_registrations: true,
    allow_conversion: true,
    allow_edit_cashout_payto_uri: false,
    allow_edit_name: false,
    currency: "ASR",
    currency_specification: {
      name: "ARS",
      alt_unit_names: {},
      num_fractional_input_digits: 2,
      num_fractional_normal_digits: 2,
      num_fractional_trailing_zero_digits: 2,
    },
    default_debit_threshold: "ARS:10" as AmountString,
    version: "1:0:0",
  };
  const ctx2 = create(BankApiProviderTesting, {
    children: [],
    value: cfg as any,
  });
  return ctx2;
}
