/*
 This file is part of GNU Taler
 (C) 2021-2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { h, VNode, FunctionalComponent } from "preact";
import { CreatedSuccessfully as TestedComponent } from "./CreatedSuccessfully.js";
import * as tests from "@gnu-taler/web-util/testing";

export default {
  title: "Pages/Reserve/CreatedSuccessfully",
  component: TestedComponent,
  argTypes: {
    onCreate: { action: "onCreate" },
    onBack: { action: "onBack" },
  },
};

export const OneBankAccount = tests.createExample(TestedComponent, {
  entity: {
    request: {
      exchange_url: "http://exchange.taler/",
      initial_balance: "TESTKUDOS:1",
      wire_method: "x-taler-bank",
    },
    response: {
      accounts: [
        {
          payto_uri: "payto://x-taler-bank/bank.taler:8080/exchange_account",
          credit_restrictions: [],
          debit_restrictions: [],
          master_sig: "asd",
          conversion_url: "",
        },
      ],
      reserve_pub: "WEQWDASDQWEASDADASDQWEQWEASDAS",
    },
  },
});

export const ThreeBankAccount = tests.createExample(TestedComponent, {
  entity: {
    request: {
      exchange_url: "http://exchange.taler/",
      initial_balance: "TESTKUDOS:1",
      wire_method: "x-taler-bank",
    },
    response: {
      accounts: [
        {
          payto_uri: "payto://x-taler-bank/bank.taler:8080/exchange_account",
          credit_restrictions: [],
          debit_restrictions: [],
          master_sig: "asd",
          conversion_url: "",
        },
        {
          payto_uri: "payto://x-taler-bank/bank1.taler:8080/asd",
          credit_restrictions: [],
          debit_restrictions: [],
          master_sig: "asd",
          conversion_url: "",
        },
        {
          payto_uri: "payto://x-taler-bank/bank2.taler:8080/qwe",
          credit_restrictions: [],
          debit_restrictions: [],
          master_sig: "asd",
          conversion_url: "",
        },
      ],
      reserve_pub: "WEQWDASDQWEASDADASDQWEQWEASDAS",
    },
  },
});

export const NoBankAccount = tests.createExample(TestedComponent, {
  entity: {
    request: {
      exchange_url: "http://exchange.taler/",
      initial_balance: "TESTKUDOS:1",
      wire_method: "x-taler-bank",
    },
    response: {
      accounts: [
        {
          payto_uri: "payo://x-talr-bank/bank.taler:8080/exchange_account",
          credit_restrictions: [],
          debit_restrictions: [],
          master_sig: "asd",
          conversion_url: "",
        },
        {
          payto_uri: "payto://x-taler-bank",
          credit_restrictions: [],
          debit_restrictions: [],
          master_sig: "asd",
          conversion_url: "",
        },
      ],
      reserve_pub: "WEQWDASDQWEASDADASDQWEQWEASDAS",
    },
  },
});
