/*
 This file is part of GNU Taler
 (C) 2021-2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { h, VNode } from "preact";
import { useState } from "preact/hooks";
import { FormProvider } from "../../../components/form/FormProvider.js";
import { Input } from "../../../components/form/Input.js";
import { MerchantBackend } from "../../../declaration.js";

type Entity = MerchantBackend.Instances.InstanceReconfigurationMessage;
interface Props {
  onUpdate: () => void;
  onDelete: () => void;
  selected: MerchantBackend.Instances.QueryInstancesResponse;
}

function convert(
  from: MerchantBackend.Instances.QueryInstancesResponse,
): Entity {
  const defaults = {
    default_wire_fee_amortization: 1,
    use_stefan: true,
    default_pay_delay: { d_us: 1000 * 60 * 60 * 1000 }, //one hour
    default_wire_transfer_delay: { d_us: 1000 * 60 * 60 * 2 * 1000 }, //two hours
  };
  return { ...defaults, ...from };
}

export function DetailPage({ selected }: Props): VNode {
  const [value, valueHandler] = useState<Partial<Entity>>(convert(selected));

  const { i18n } = useTranslationContext();

  return (
    <div>
      <section class="hero is-hero-bar">
        <div class="hero-body">
          <div class="level">
            <div class="level-left">
              <div class="level-item">
                <h1 class="title">Here goes the instance description</h1>
              </div>
            </div>
            <div class="level-right" style="display: none;">
              <div class="level-item" />
            </div>
          </div>
        </div>
      </section>

      <section class="section is-main-section">
        <div class="columns">
          <div class="column" />
          <div class="column is-6">
            <FormProvider<Entity> object={value} valueHandler={valueHandler}>
              <Input<Entity> name="name" readonly label={i18n.str`Name`} />
            </FormProvider>
          </div>
          <div class="column" />
        </div>
      </section>
    </div>
  );
}
