/*
 This file is part of GNU Taler
 (C) 2021-2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { h } from "preact";
import * as tests from "@gnu-taler/web-util/testing";
import { InputPaytoForm } from "./InputPaytoForm.js";
import { FormProvider } from "./FormProvider.js";
import { useState } from "preact/hooks";

export default {
  title: "Components/Form/PayTo",
  component: InputPaytoForm,
  argTypes: {
    onUpdate: { action: "onUpdate" },
    onBack: { action: "onBack" },
  },
};

export const Example = tests.createExample(() => {
  const initial = {
    accounts: [],
  };
  const [form, updateForm] = useState<Partial<typeof initial>>(initial);
  return (
    <FormProvider valueHandler={updateForm} object={form}>
      <InputPaytoForm name="accounts" label="Accounts:" />
    </FormProvider>
  );
}, {});
