## AUditor Admin Frontend

Auditor Admin Frontend is a Single Page Application (SPA) that connects with a running Auditor Backend and lets you audit the exchange.

## System requirements

- Node: v16.15.0
- pnpm: 7.14.2
- make

## Compiling from source

Run `pnpm install --frozen-lockfile --filter @gnu-taler/auditor-backoffice...` to install all the nodejs dependencies.

Then the command `pnpm build` create the distribution in the `dist` folder.

By default the installation prefix will be `/usr/local/share/taler/auditor-backoffice/` but it can be overridden by `--prefix` in the configuration process:

```shell
./configure --prefix=/another/directory
```

To install run `make install`

## Running develop

To run a development server run:

```shell
./dev.mjs
```

This should start a watch process that will reload the server every time that a file is saved.

The application need to connect to a auditor-backend properly configured to run.

## Building for deploy

To build and deploy the SPA in your local server run the install script:

```shell
make install
```

## Runtime dependencies

*   preact: Fast 3kB alternative to React with the same modern API

*   preact-router: URL component router for Preact

*   SWR: React Hooks library for data fetching (stale-while-revalidate)

*   Yup: schema builder for value parsing and validation (to be deprecated)

*   Date-fns: library for manipulating javascript date

*   qrcode-generator: simplest qr implementation based on JIS X 0510:1999

*   @gnu-taler/taler-util: types and tooling

*   history: manage the history stack, navigate, and persist state between sessions

*   jed: gettext like library for internationalization

