import { codecForBoolean } from "@gnu-taler/taler-util";
import { buildStorageKey, useMemoryStorage } from "@gnu-taler/web-util/browser";
import { platform } from "../platform/foreground.js";
import { useEffect } from "preact/hooks";

export function useIsOnline(): boolean {
  const { value, update } = useMemoryStorage("online", true);
  useEffect(() => {
    return platform.listenNetworkConnectionState((state) => {
      update(state === "on");
    });
  });
  return value;
}
