/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { Fragment, h, VNode } from "preact";
import { Amount } from "../../components/Amount.js";
import { Part } from "../../components/Part.js";
import { Time } from "../../components/Time.js";
import { Button } from "../../mui/Button.js";
import {
  getAmountWithFee,
  TransferPickupDetails,
} from "../../wallet/Transaction.js";
import { State } from "./index.js";
import { TermsOfService } from "../../components/TermsOfService/index.js";

export function ReadyView({
  accept,
  summary,
  expiration,
  effective,
  exchangeBaseUrl,
  raw,
}: State.Ready): VNode {
  const { i18n } = useTranslationContext();
  return (
    <Fragment>
      <section style={{ textAlign: "left" }}>
        <Part title={i18n.str`Subject`} text={<div>{summary}</div>} />
        <Part title={i18n.str`Amount`} text={<Amount value={raw} />} />
        <Part
          title={i18n.str`Details`}
          text={
            <TransferPickupDetails
              amount={getAmountWithFee(effective, raw, "credit")}
            />
          }
        />

        <Part
          title={i18n.str`Valid until`}
          text={<Time timestamp={expiration} format="dd MMMM yyyy, HH:mm" />}
          kind="neutral"
        />
      </section>
      <section>
        <TermsOfService key="terms" exchangeUrl={exchangeBaseUrl} >
          <Button variant="contained" color="success" onClick={accept.onClick}>
            <i18n.Translate>
              Receive &nbsp; {<Amount value={effective} />}
            </i18n.Translate>
          </Button>
        </TermsOfService>
      </section>
    </Fragment>
  );
}
