/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { ErrorAlertView } from "../../components/CurrentAlerts.js";
import { Loading } from "../../components/Loading.js";
import { ErrorAlert } from "../../context/alert.js";
import { compose, StateViewMap } from "../../utils/index.js";
import { useComponentState } from "./state.js";
import { ReadyView } from "./views.js";
import { PaymentPage } from "../Payment/index.js";
import {
  AmountFieldHandler,
  ButtonHandler,
  TextFieldHandler,
} from "../../mui/handlers.js";

export interface Props {
  talerTemplateUri: string;
  goToWalletManualWithdraw: (amount?: string) => Promise<void>;
  cancel: () => Promise<void>;
  onSuccess: (tx: string) => Promise<void>;
}

export type State =
  | State.Loading
  | State.LoadingUriError
  | State.OrderReady
  | State.FillTemplate;

export namespace State {
  export interface Loading {
    status: "loading";
    error: undefined;
  }
  export interface LoadingUriError {
    status: "error";
    error: ErrorAlert;
  }

  export interface FillTemplate {
    status: "fill-template";
    error: undefined;
    currency: string;
    amount?: AmountFieldHandler;
    summary?: TextFieldHandler;
    onCreate: ButtonHandler;
  }

  export interface OrderReady {
    status: "order-ready";
    error: undefined;
    talerPayUri: string;
    onSuccess: (tx: string) => Promise<void>;
    cancel: () => Promise<void>;
    goToWalletManualWithdraw: () => Promise<void>;
  }
}

const viewMapping: StateViewMap<State> = {
  loading: Loading,
  error: ErrorAlertView,
  "fill-template": ReadyView,
  "order-ready": PaymentPage,
};

export const PaymentTemplatePage = compose(
  "PaymentTemplate",
  (p: Props) => useComponentState(p),
  viewMapping,
);
